/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.commons.text.translate.AggregateTranslator;
import org.apache.commons.text.translate.CharSequenceTranslator;
import org.apache.commons.text.translate.EntityArrays;
import org.apache.commons.text.translate.LookupTranslator;
import org.iplass.mtp.impl.util.random.SecureRandomGenerator;
import org.iplass.mtp.impl.util.random.SecureRandomService;
import org.iplass.mtp.spi.ServiceRegistry;

public class StringUtil {
    private static final Map<CharSequence, CharSequence> APOS_ESCAPE;
    private static final CharSequenceTranslator ESCAPE_HTML4_SP;

    public static String escapeEql(String str) {
        if (str == null) {
            return null;
        }
        return StringUtils.replace((String)str, (String)"'", (String)"''");
    }

    public static String escapeEqlForLike(String str) {
        if (str == null) {
            return null;
        }
        boolean needSanitaizing = false;
        char current = '\u0000';
        for (int i = 0; i < str.length(); ++i) {
            current = str.charAt(i);
            switch (current) {
                case '%': 
                case '\\': 
                case '_': {
                    needSanitaizing = true;
                    break;
                }
            }
            if (needSanitaizing) break;
        }
        if (!needSanitaizing) {
            return str;
        }
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            current = str.charAt(i);
            switch (current) {
                case '%': 
                case '\\': 
                case '_': {
                    buff.append('\\');
                    break;
                }
            }
            buff.append(current);
        }
        return buff.toString();
    }

    public static String escapeXml10(String str) {
        return StringEscapeUtils.escapeXml10((String)str);
    }

    public static String escapeXml10(String str, boolean emptyIfNull) {
        if (emptyIfNull && str == null) {
            return "";
        }
        return StringEscapeUtils.escapeXml10((String)str);
    }

    public static String escapeXml11(String str) {
        return StringEscapeUtils.escapeXml11((String)str);
    }

    public static String escapeXml11(String str, boolean emptyIfNull) {
        if (emptyIfNull && str == null) {
            return "";
        }
        return StringEscapeUtils.escapeXml11((String)str);
    }

    public static String unescapeXml(String str) {
        return StringEscapeUtils.unescapeXml((String)str);
    }

    public static String escapeHtml(String str) {
        return ESCAPE_HTML4_SP.translate((CharSequence)str);
    }

    public static String escapeHtml(String str, boolean emptyIfNull) {
        if (emptyIfNull && str == null) {
            return "";
        }
        return ESCAPE_HTML4_SP.translate((CharSequence)str);
    }

    public static String unescapeHtml(String str) {
        return StringEscapeUtils.unescapeHtml4((String)str);
    }

    public static String randomToken() {
        return RandomHolder.random.secureRandomToken();
    }

    public static boolean isEmpty(String str) {
        return StringUtils.isEmpty((CharSequence)str);
    }

    public static boolean isNotEmpty(String str) {
        return StringUtils.isNotEmpty((CharSequence)str);
    }

    public static boolean isBlank(String str) {
        return StringUtils.isBlank((CharSequence)str);
    }

    public static boolean isNotBlank(String str) {
        return StringUtils.isNotBlank((CharSequence)str);
    }

    public static String deleteWhitespace(String str) {
        return StringUtils.deleteWhitespace((String)str);
    }

    public static String leftPad(String str, int size, char padChar) {
        return StringUtils.leftPad((String)str, (int)size, (char)padChar);
    }

    public static String escapeJavaScript(String str) {
        return StringEscapeUtils.escapeEcmaScript((String)str);
    }

    public static String removeLineFeedCode(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return str;
        }
        return str.replace("\n", "").replace("\r", "");
    }

    public static String capitalize(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String decapitalize(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        char[] chars = name.toCharArray();
        if (chars.length >= 2 && Character.isUpperCase(chars[0]) && Character.isUpperCase(chars[1])) {
            return name;
        }
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    public static String camelize(String s) {
        if (s == null) {
            return null;
        }
        String[] array = (s = s.toLowerCase()).split("_");
        if (array.length == 1) {
            return StringUtil.capitalize(s);
        }
        StringBuffer buf = new StringBuffer(40);
        for (int i = 0; i < array.length; ++i) {
            buf.append(StringUtil.capitalize(array[i]));
        }
        return buf.toString();
    }

    public static String decamelize(String s) {
        if (s == null) {
            return null;
        }
        if (s.length() == 1) {
            return s.toUpperCase();
        }
        StringBuffer buf = new StringBuffer(40);
        int pos = 0;
        for (int i = 1; i < s.length(); ++i) {
            if (!Character.isUpperCase(s.charAt(i))) continue;
            if (buf.length() != 0) {
                buf.append('_');
            }
            buf.append(s.substring(pos, i).toUpperCase());
            pos = i;
        }
        if (buf.length() != 0) {
            buf.append('_');
        }
        buf.append(s.substring(pos, s.length()).toUpperCase());
        return buf.toString();
    }

    public static String remove(String arg0, String arg1) {
        return StringUtils.remove((String)arg0, (String)arg1);
    }

    public static int countMatches(String str, String sub) {
        return StringUtils.countMatches((CharSequence)str, (CharSequence)sub);
    }

    public static String replace(String data, String from, String to) {
        return StringUtils.replace((String)data, (String)from, (String)to);
    }

    public static String replaceEach(String text, String[] searchList, String[] replacementList) {
        return StringUtils.replaceEach((String)text, (String[])searchList, (String[])replacementList);
    }

    public static String lowerCase(String str) {
        return StringUtils.lowerCase((String)str);
    }

    public static boolean startsWithAny(String arg0, String[] arg1) {
        return StringUtils.startsWithAny((CharSequence)arg0, (CharSequence[])arg1);
    }

    public static String[] split(String str, char separatorChar) {
        return StringUtils.split((String)str, (char)separatorChar);
    }

    public static String join(Object[] array, String separator) {
        return StringUtils.join((Object[])array, (String)separator);
    }

    public static String substringAfterLast(String str, String separator) {
        return StringUtils.substringAfterLast((String)str, (String)separator);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return StringUtils.equalsIgnoreCase((CharSequence)str1, (CharSequence)str2);
    }

    public static boolean endsWithIgnoreCase(String str, String suffix) {
        return StringUtils.endsWithIgnoreCase((CharSequence)str, (CharSequence)suffix);
    }

    public static String removeStart(String str, String remove) {
        return StringUtils.removeStart((String)str, (String)remove);
    }

    public static String stripToEmpty(String str) {
        return StringUtils.stripToEmpty((String)str);
    }

    public static String stripToNull(String str) {
        return StringUtils.stripToNull((String)str);
    }

    public static String reverseDelimited(String str, char separatorChar) {
        return StringUtils.reverseDelimited((String)str, (char)separatorChar);
    }

    static {
        HashMap<String, String> initMap = new HashMap<String, String>();
        initMap.put("'", "&#039;");
        APOS_ESCAPE = Collections.unmodifiableMap(initMap);
        ESCAPE_HTML4_SP = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator(EntityArrays.BASIC_ESCAPE), new LookupTranslator(APOS_ESCAPE), new LookupTranslator(EntityArrays.ISO8859_1_ESCAPE), new LookupTranslator(EntityArrays.HTML40_EXTENDED_ESCAPE)});
    }

    private static class RandomHolder {
        static final SecureRandomGenerator random = ServiceRegistry.getRegistry().getService(SecureRandomService.class).createGenerator();

        private RandomHolder() {
        }
    }
}

