/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.async;

import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.async.StartMode;

public class AsyncTaskOption {
    public static final String DEFAULT_QUEUE_NAME = "default";
    public static final String LOCAL_THREAD_QUEUE_NAME = "localThread";
    private String queue;
    private String groupingKey;
    private StartMode startMode = StartMode.AFTER_COMMIT;
    private ExceptionHandlingMode exceptionHandlingMode = ExceptionHandlingMode.RESTART;
    private boolean returnResult = false;
    private long executionTime;

    public AsyncTaskOption() {
    }

    public AsyncTaskOption(boolean returnResult) {
        this.returnResult = returnResult;
    }

    public AsyncTaskOption(String queue, String groupingKey, StartMode startMode, ExceptionHandlingMode exceptionHandlingMode, boolean returnResult, long executionTime) {
        this.queue = queue;
        this.groupingKey = groupingKey;
        this.startMode = startMode;
        this.exceptionHandlingMode = exceptionHandlingMode;
        this.returnResult = returnResult;
        this.executionTime = executionTime;
    }

    public AsyncTaskOption queue(String queue) {
        this.queue = queue;
        return this;
    }

    public AsyncTaskOption groupingKey(String groupingKey) {
        this.groupingKey = groupingKey;
        return this;
    }

    public AsyncTaskOption startMode(StartMode startMode) {
        this.startMode = startMode;
        return this;
    }

    public AsyncTaskOption exceptionHandlingMode(ExceptionHandlingMode exceptionHandlingMode) {
        this.exceptionHandlingMode = exceptionHandlingMode;
        return this;
    }

    public AsyncTaskOption returnResult() {
        this.returnResult = true;
        return this;
    }

    public AsyncTaskOption executionTime(long executionTime) {
        this.executionTime = executionTime;
        return this;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }

    public ExceptionHandlingMode getExceptionHandlingMode() {
        return this.exceptionHandlingMode;
    }

    public void setExceptionHandlingMode(ExceptionHandlingMode exceptionHandlingMode) {
        this.exceptionHandlingMode = exceptionHandlingMode;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public String getGroupingKey() {
        return this.groupingKey;
    }

    public void setGroupingKey(String groupingKey) {
        this.groupingKey = groupingKey;
    }

    public StartMode getStartMode() {
        return this.startMode;
    }

    public void setStartMode(StartMode startMode) {
        this.startMode = startMode;
    }

    public boolean isReturnResult() {
        return this.returnResult;
    }

    public void setReturnResult(boolean returnResult) {
        this.returnResult = returnResult;
    }
}

