/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb;

import java.io.Serializable;
import java.util.concurrent.Callable;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.spi.ServiceRegistry;

public class CallableInput<V>
implements Serializable {
    private static final long serialVersionUID = -2374924829357547133L;
    private final Callable<V> actual;
    private final UserContext userContext;
    private final boolean privilaged;

    public CallableInput(Callable<V> actual, UserContext userContext, boolean privilaged) {
        this.actual = actual;
        this.userContext = userContext;
        this.privilaged = privilaged;
    }

    public Callable<V> getActual() {
        return this.actual;
    }

    public UserContext getUserContext() {
        return this.userContext;
    }

    public boolean isPrivilaged() {
        return this.privilaged;
    }

    public V callImpl() throws Exception {
        if (this.userContext != null) {
            AuthService as = ServiceRegistry.getRegistry().getService(AuthService.class);
            try {
                return (V)as.doSecuredAction(this.userContext, () -> {
                    if (this.privilaged) {
                        return AuthContext.doPrivileged(() -> {
                            try {
                                return this.actual.call();
                            }
                            catch (Exception e) {
                                throw new WrapException(e);
                            }
                        });
                    }
                    try {
                        return this.actual.call();
                    }
                    catch (Exception e) {
                        throw new WrapException(e);
                    }
                });
            }
            catch (WrapException e) {
                throw (Exception)e.getCause();
            }
        }
        return this.actual.call();
    }

    public String toString() {
        return this.actual.toString();
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = -7618439229960105705L;

        public WrapException(Throwable cause) {
            super(cause);
        }
    }
}

