/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.builtin.policy;

import java.util.List;
import org.iplass.mtp.auth.policy.definition.PasswordPolicyDefinition;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.metadata.MetaData;
import org.iplass.mtp.impl.util.ObjectUtil;

public class MetaPasswordPolicy
implements MetaData {
    private static final long serialVersionUID = -2469096937639131962L;
    private int maximumPasswordAge;
    private int minimumPasswordAge;
    private String passwordPattern;
    private String passwordPatternErrorMessage;
    private List<MetaLocalizedString> localizedPasswordPatternErrorMessageList;
    private int passwordHistoryCount;
    private boolean createAccountWithSpecificPassword;
    private boolean resetPasswordWithSpecificPassword;
    private String randomPasswordIncludeSigns;
    private String randomPasswordExcludeChars;
    private int randomPasswordLength;

    public int getMaximumPasswordAge() {
        return this.maximumPasswordAge;
    }

    public void setMaximumPasswordAge(int maximumPasswordAge) {
        this.maximumPasswordAge = maximumPasswordAge;
    }

    public int getMinimumPasswordAge() {
        return this.minimumPasswordAge;
    }

    public void setMinimumPasswordAge(int minimumPasswordAge) {
        this.minimumPasswordAge = minimumPasswordAge;
    }

    public String getPasswordPattern() {
        return this.passwordPattern;
    }

    public void setPasswordPattern(String passwordPattern) {
        this.passwordPattern = passwordPattern;
    }

    public String getPasswordPatternErrorMessage() {
        return this.passwordPatternErrorMessage;
    }

    public void setPasswordPatternErrorMessage(String passwordPatternErrorMessage) {
        this.passwordPatternErrorMessage = passwordPatternErrorMessage;
    }

    public List<MetaLocalizedString> getLocalizedPasswordPatternErrorMessageList() {
        return this.localizedPasswordPatternErrorMessageList;
    }

    public void setLocalizedPasswordPatternErrorMessageList(List<MetaLocalizedString> localizedPasswordPatternErrorMessageList) {
        this.localizedPasswordPatternErrorMessageList = localizedPasswordPatternErrorMessageList;
    }

    public int getPasswordHistoryCount() {
        return this.passwordHistoryCount;
    }

    public void setPasswordHistoryCount(int passwordHistoryCount) {
        this.passwordHistoryCount = passwordHistoryCount;
    }

    public boolean isCreateAccountWithSpecificPassword() {
        return this.createAccountWithSpecificPassword;
    }

    public void setCreateAccountWithSpecificPassword(boolean createAccountWithSpecificPassword) {
        this.createAccountWithSpecificPassword = createAccountWithSpecificPassword;
    }

    public boolean isResetPasswordWithSpecificPassword() {
        return this.resetPasswordWithSpecificPassword;
    }

    public void setResetPasswordWithSpecificPassword(boolean resetPasswordWithSpecificPassword) {
        this.resetPasswordWithSpecificPassword = resetPasswordWithSpecificPassword;
    }

    public String getRandomPasswordIncludeSigns() {
        return this.randomPasswordIncludeSigns;
    }

    public void setRandomPasswordIncludeSigns(String randomPasswordIncludeSigns) {
        this.randomPasswordIncludeSigns = randomPasswordIncludeSigns;
    }

    public String getRandomPasswordExcludeChars() {
        return this.randomPasswordExcludeChars;
    }

    public void setRandomPasswordExcludeChars(String randomPasswordExcludeChars) {
        this.randomPasswordExcludeChars = randomPasswordExcludeChars;
    }

    public int getRandomPasswordLength() {
        return this.randomPasswordLength;
    }

    public void setRandomPasswordLength(int randomPasswordLength) {
        this.randomPasswordLength = randomPasswordLength;
    }

    @Override
    public MetaPasswordPolicy copy() {
        return ObjectUtil.deepCopy(this);
    }

    public void applyConfig(PasswordPolicyDefinition def) {
        this.maximumPasswordAge = def.getMaximumPasswordAge();
        this.minimumPasswordAge = def.getMinimumPasswordAge();
        this.passwordPattern = def.getPasswordPattern();
        this.passwordPatternErrorMessage = def.getPasswordPatternErrorMessage();
        this.localizedPasswordPatternErrorMessageList = I18nUtil.toMeta(def.getLocalizedPasswordPatternErrorMessageList());
        this.passwordHistoryCount = def.getPasswordHistoryCount();
        this.createAccountWithSpecificPassword = def.isCreateAccountWithSpecificPassword();
        this.randomPasswordIncludeSigns = def.getRandomPasswordIncludeSigns();
        this.randomPasswordExcludeChars = def.getRandomPasswordExcludeChars();
        this.randomPasswordLength = def.getRandomPasswordLength();
        this.resetPasswordWithSpecificPassword = def.isResetPasswordWithSpecificPassword();
    }

    public PasswordPolicyDefinition currentConfig() {
        PasswordPolicyDefinition def = new PasswordPolicyDefinition();
        def.setMaximumPasswordAge(this.maximumPasswordAge);
        def.setMinimumPasswordAge(this.minimumPasswordAge);
        def.setPasswordPattern(this.passwordPattern);
        def.setPasswordPatternErrorMessage(this.passwordPatternErrorMessage);
        def.setLocalizedPasswordPatternErrorMessageList(I18nUtil.toDef(this.localizedPasswordPatternErrorMessageList));
        def.setPasswordHistoryCount(this.passwordHistoryCount);
        def.setCreateAccountWithSpecificPassword(this.createAccountWithSpecificPassword);
        def.setRandomPasswordIncludeSigns(this.randomPasswordIncludeSigns);
        def.setRandomPasswordExcludeChars(this.randomPasswordExcludeChars);
        def.setRandomPasswordLength(this.randomPasswordLength);
        def.setResetPasswordWithSpecificPassword(this.resetPasswordWithSpecificPassword);
        return def;
    }
}

