/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.rememberme;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.login.rememberme.RememberMeTokenCredential;
import org.iplass.mtp.auth.login.rememberme.RememberMeTokenInfo;
import org.iplass.mtp.auth.token.AuthTokenInfo;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.AuthenticationPolicyService;
import org.iplass.mtp.impl.auth.authenticate.builtin.policy.MetaAuthenticationPolicy;
import org.iplass.mtp.impl.auth.authenticate.token.AuthToken;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenHandler;
import org.iplass.mtp.impl.auth.authenticate.token.AuthTokenService;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceRegistry;

public class RememberMeTokenHandler
extends AuthTokenHandler {
    public static final String TYPE_REMME_DEFAULT = "REMME";
    private AuthenticationPolicyService policyService;

    @Override
    public void inited(AuthTokenService service, Config config) {
        super.inited(service, config);
        if (this.getType() == null) {
            this.setType(TYPE_REMME_DEFAULT);
        }
        this.policyService = ServiceRegistry.getRegistry().getService(AuthenticationPolicyService.class);
    }

    @Override
    public AuthTokenInfo toAuthTokenInfo(AuthToken authToken) {
        RememberMeTokenInfo info = new RememberMeTokenInfo();
        info.setType(authToken.getType());
        info.setKey(authToken.getSeries());
        Timestamp t = authToken.getStartDate();
        MetaAuthenticationPolicy.AuthenticationPolicyRuntime pol = this.policyService.getOrDefault(authToken.getPolicyName());
        if (pol.getMetaData().getRememberMePolicy() == null) {
            info.setExpired(true);
        } else if (pol.getMetaData().getRememberMePolicy().getLifetimeMinutes() > 0L) {
            Timestamp exp = new Timestamp(t.getTime() + TimeUnit.MINUTES.toMillis(pol.getMetaData().getRememberMePolicy().getLifetimeMinutes()));
            if (exp.getTime() >= System.currentTimeMillis()) {
                info.setExpiryDate(exp);
            } else {
                info.setExpired(true);
            }
        }
        return info;
    }

    @Override
    public Credential toCredential(AuthToken newToken) {
        return new RememberMeTokenCredential(newToken.encodeToken());
    }

    @Override
    protected Serializable createDetails(String seriesString, String tokenString, String userUniqueId, String policyName, AuthTokenInfo tokenInfo) {
        return null;
    }
}

