/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.group;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthContext;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.group.GroupContext;
import org.iplass.mtp.impl.cache.LoadingAdapter;

public class GroupCacheLogic
implements LoadingAdapter<String, GroupContext> {
    private final TenantAuthorizeContext authorizeContext;
    private EntityManager em = ManagerLocator.getInstance().getManager(EntityManager.class);

    public GroupCacheLogic(TenantAuthorizeContext authorizeContext) {
        this.authorizeContext = authorizeContext;
    }

    @Override
    public GroupContext load(String key) {
        return AuthContext.doPrivileged(() -> {
            Query q = new Query().select("oid", "code", "parent.code", "children.code").from("mtp.auth.Group").where(new Equals("code", key));
            final String[] codeAndParentCode = new String[]{null, null, null};
            final ArrayList childCodes = new ArrayList();
            this.em.search(q, new Predicate<Object[]>(){

                @Override
                public boolean test(Object[] dataModel) {
                    codeAndParentCode[0] = (String)dataModel[0];
                    codeAndParentCode[1] = (String)dataModel[1];
                    codeAndParentCode[2] = (String)dataModel[2];
                    if (dataModel[3] != null) {
                        childCodes.add((String)dataModel[3]);
                    }
                    return true;
                }
            });
            if (codeAndParentCode[0] == null) {
                return null;
            }
            return new GroupContext(codeAndParentCode[0], codeAndParentCode[1], codeAndParentCode[2], childCodes.toArray(new String[childCodes.size()]), this.authorizeContext);
        });
    }

    @Override
    public String getKey(GroupContext val) {
        return val.getGroupCode();
    }

    @Override
    public List<GroupContext> loadByIndex(int indexType, Object indexVal) {
        return null;
    }

    @Override
    public long getVersion(GroupContext value) {
        return 0L;
    }

    @Override
    public Object getIndexVal(int indexType, GroupContext value) {
        return null;
    }
}

