/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.AbstractBuiltinCacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.CacheEntryCleaner;
import org.iplass.mtp.impl.cache.store.builtin.LRUMap;
import org.iplass.mtp.impl.cache.store.builtin.MapBaseCacheStore;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;
import org.iplass.mtp.impl.cache.store.builtin.SimpleCacheStoreBase;
import org.iplass.mtp.impl.cache.store.builtin.SimpleLocalCacheHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCacheStoreFactory
extends AbstractBuiltinCacheStoreFactory {
    private static Logger logger = LoggerFactory.getLogger(SimpleCacheStoreFactory.class);
    private static long MIN_POLLING_INTERVAL = TimeUnit.MINUTES.toMillis(1L);
    private int initialCapacity = 16;
    private float loadFactor = 0.75f;
    private int concurrencyLevel = 16;
    private long timeToLive = -1L;
    private int size = -1;
    private boolean multiThreaded = true;
    private long evictionInterval = -1L;

    public long getEvictionInterval() {
        return this.evictionInterval;
    }

    public void setEvictionInterval(long evictionInterval) {
        this.evictionInterval = evictionInterval;
    }

    public boolean isMultiThreaded() {
        return this.multiThreaded;
    }

    public void setMultiThreaded(boolean multiThreaded) {
        this.multiThreaded = multiThreaded;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public void setInitialCapacity(int initialCapacity) {
        this.initialCapacity = initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public void setLoadFactor(float loadFactor) {
        this.loadFactor = loadFactor;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public void setConcurrencyLevel(int concurrencyLevel) {
        this.concurrencyLevel = concurrencyLevel;
    }

    private long pollingInterval() {
        if (this.evictionInterval > 0L) {
            return this.evictionInterval;
        }
        if (this.timeToLive > 0L) {
            long ei = this.timeToLive / 2L;
            if (ei < MIN_POLLING_INTERVAL) {
                return MIN_POLLING_INTERVAL;
            }
            return ei;
        }
        return -1L;
    }

    @Override
    public CacheStore createCacheStore(String namespace) {
        SimpleCacheStoreBase ret;
        if (this.isMultiThreaded()) {
            if (this.getIndexCount() == 0) {
                if (logger.isTraceEnabled()) {
                    logger.trace("create ConcurrentHashMapCacheStore:namespace=" + namespace);
                }
                ret = new ConcurrentHashMapCacheStore(namespace, this, this.initialCapacity, this.loadFactor, this.concurrencyLevel, this.timeToLive, this.size);
            } else {
                if (logger.isTraceEnabled()) {
                    logger.trace("create IndexedConcurrentHashMapCacheStore:namespace=" + namespace);
                }
                ret = new IndexedConcurrentHashMapCacheStore(namespace, this, this.initialCapacity, this.loadFactor, this.concurrencyLevel, this.timeToLive, this.size, this.getIndexCount());
            }
        } else if (this.size > 0) {
            if (logger.isTraceEnabled()) {
                logger.trace("create MapBaseCacheStore(LRUMap):namespace=" + namespace);
            }
            LRUMap lruMap = new LRUMap(this.getInitialCapacity(), this.getLoadFactor(), this.size);
            MapBaseCacheStore store = new MapBaseCacheStore(namespace, lruMap, this.getIndexCount(), this.timeToLive, this);
            lruMap.setStore(store);
            ret = store;
        } else {
            if (logger.isTraceEnabled()) {
                logger.trace("create MapBaseCacheStore(HashMap):namespace=" + namespace);
            }
            ret = new MapBaseCacheStore(namespace, new HashMap<Object, CacheEntry>(this.initialCapacity, this.loadFactor), this.getIndexCount(), this.timeToLive, this);
        }
        if (this.timeToLive > 0L) {
            CacheEntryCleaner.getInstance().register(ret, this.pollingInterval());
        }
        return ret;
    }

    @Override
    public boolean canUseForLocalCache() {
        return true;
    }

    @Override
    public boolean supportsIndex() {
        return true;
    }

    private static boolean isStillAliveOrNull(CacheEntry e, long timeToLive) {
        if (e == null) {
            return true;
        }
        if (timeToLive <= 0L) {
            return true;
        }
        return System.currentTimeMillis() - e.getCreationTime() <= timeToLive;
    }

    @Override
    public CacheHandler createCacheHandler(CacheStore store) {
        return new SimpleLocalCacheHandler(store, this.getConcurrencyLevelOfCacheHandler());
    }

    @Override
    public CacheStoreFactory getLowerLevel() {
        return null;
    }

    public static class IndexedConcurrentHashMapCacheStore
    extends SimpleCacheStoreBase {
        private final ReentrantReadWriteLock indexLock = new ReentrantReadWriteLock();
        private final Cache<Object, CacheEntry> cache;
        private long timeToLive;
        private final HashMap<Object, Object>[] indexCache;

        public IndexedConcurrentHashMapCacheStore(String namespace, CacheStoreFactory factory, int initialCapacity, float loadFactor, int concurrencyLevel, long timeToLive, int size, int indexCount) {
            super(namespace, true, factory);
            this.timeToLive = timeToLive;
            this.cache = size > 0 ? Caffeine.newBuilder().maximumSize((long)size).initialCapacity(initialCapacity).removalListener((key, value, cause) -> {
                if (cause.wasEvicted()) {
                    this.removeFromIndex((CacheEntry)value, false);
                    this.notifyRemoved((CacheEntry)value);
                }
            }).build() : Caffeine.newBuilder().initialCapacity(initialCapacity).build();
            this.indexCache = this.newHashMapArray(indexCount);
            for (int i = 0; i < this.indexCache.length; ++i) {
                this.indexCache[i] = new HashMap();
            }
        }

        private final HashMap<Object, Object>[] newHashMapArray(int size) {
            return new HashMap[size];
        }

        private void addToIndex(CacheEntry entry) {
            for (int i = 0; i < this.indexCache.length; ++i) {
                Object ikey = entry.getIndexValue(i);
                Object key = entry.getKey();
                if (ikey instanceof Object[]) {
                    Object[] ikeyArray = (Object[])ikey;
                    for (int j = 0; j < ikeyArray.length; ++j) {
                        Object ival = this.margeVal(this.indexCache[i].get(ikeyArray[j]), key);
                        this.indexCache[i].put(ikeyArray[j], ival);
                    }
                    continue;
                }
                Object ival = this.margeVal(this.indexCache[i].get(ikey), key);
                this.indexCache[i].put(ikey, ival);
            }
        }

        private void removeFromIndex(CacheEntry entry, boolean loose) {
            for (int i = 0; i < this.indexCache.length; ++i) {
                Object ikey = entry.getIndexValue(i);
                if (ikey instanceof Object[]) {
                    Object[] ikeyArray = (Object[])ikey;
                    for (int j = 0; j < ikeyArray.length; ++j) {
                        Object ival = this.subtractVal(this.indexCache[i].get(ikeyArray[j]), entry.getKey(), loose);
                        this.indexCache[i].put(ikeyArray[j], ival);
                    }
                    continue;
                }
                Object ival = this.subtractVal(this.indexCache[i].get(ikey), entry.getKey(), loose);
                this.indexCache[i].put(ikey, ival);
            }
        }

        @Override
        protected void removeInvalidEntry() {
            List<Object> keys = this.keySet();
            if (keys != null) {
                for (Object k : keys) {
                    this.get(k);
                }
            }
        }

        @Override
        public CacheEntry get(Object key) {
            if (key == null) {
                return null;
            }
            CacheEntry e = (CacheEntry)this.cache.getIfPresent(key);
            if (!SimpleCacheStoreFactory.isStillAliveOrNull(e, this.timeToLive)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("invalidate " + e + ", cause timeToLive");
                }
                this.remove(e);
                return null;
            }
            return e;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEntry put(CacheEntry entry, boolean isClean) {
            this.indexLock.writeLock().lock();
            try {
                CacheEntry previous = this.cache.asMap().put(entry.getKey(), entry);
                if (previous != null) {
                    this.removeFromIndex(previous, false);
                }
                this.addToIndex(entry);
                if (previous == null) {
                    this.notifyPut(entry);
                } else {
                    this.notifyUpdated(previous, entry);
                }
                CacheEntry cacheEntry = previous;
                return cacheEntry;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEntry remove(Object key) {
            this.indexLock.writeLock().lock();
            try {
                CacheEntry previous = (CacheEntry)this.cache.asMap().remove(key);
                if (previous != null) {
                    this.removeFromIndex(previous, false);
                    this.notifyRemoved(previous);
                }
                CacheEntry cacheEntry = previous;
                return cacheEntry;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        @Override
        public void removeAll() {
            this.indexLock.writeLock().lock();
            try {
                if (this.hasListener()) {
                    for (Object k : this.keySet()) {
                        this.remove(k);
                    }
                } else {
                    this.cache.asMap().clear();
                    for (int i = 0; i < this.indexCache.length; ++i) {
                        this.indexCache[i].clear();
                    }
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEntry putIfAbsent(CacheEntry entry) {
            this.indexLock.writeLock().lock();
            try {
                CacheEntry putted = this.cache.asMap().putIfAbsent(entry.getKey(), entry);
                if (putted == null) {
                    this.addToIndex(entry);
                    this.notifyPut(entry);
                }
                CacheEntry cacheEntry = putted;
                return cacheEntry;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(CacheEntry entry) {
            this.indexLock.writeLock().lock();
            try {
                boolean res = this.cache.asMap().remove(entry.getKey(), entry);
                if (res) {
                    this.removeFromIndex(entry, false);
                    this.notifyRemoved(entry);
                }
                boolean bl = res;
                return bl;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEntry replace(CacheEntry entry) {
            this.indexLock.writeLock().lock();
            try {
                CacheEntry previous = this.cache.asMap().replace(entry.getKey(), entry);
                if (previous != null) {
                    this.removeFromIndex(previous, false);
                    this.addToIndex(entry);
                    this.notifyUpdated(previous, entry);
                }
                CacheEntry cacheEntry = previous;
                return cacheEntry;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
            if (!oldEntry.getKey().equals(newEntry.getKey())) {
                throw new IllegalArgumentException("oldEntry key not equals newEntryKey");
            }
            this.indexLock.writeLock().lock();
            try {
                boolean res = this.cache.asMap().replace(newEntry.getKey(), oldEntry, newEntry);
                if (res) {
                    this.removeFromIndex(oldEntry, false);
                    this.addToIndex(newEntry);
                    this.notifyUpdated(oldEntry, newEntry);
                }
                boolean bl = res;
                return bl;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        @Override
        public List<Object> keySet() {
            return new ArrayList<Object>(this.cache.asMap().keySet());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CacheEntry getByIndex(int indexKey, Object indexValue) {
            Object key = null;
            this.indexLock.readLock().lock();
            try {
                key = this.indexCache[indexKey].get(indexValue);
            }
            finally {
                this.indexLock.readLock().unlock();
            }
            if (key == null) {
                return null;
            }
            if (key instanceof Object[]) {
                return this.get(((Object[])key)[0]);
            }
            return this.get(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
            Object key = null;
            this.indexLock.readLock().lock();
            try {
                key = this.indexCache[indexKey].get(indexValue);
            }
            finally {
                this.indexLock.readLock().unlock();
            }
            if (key == null) {
                return Collections.emptyList();
            }
            if (key instanceof Object[]) {
                Object[] keyArray = (Object[])key;
                ArrayList<CacheEntry> result = new ArrayList<CacheEntry>(keyArray.length);
                for (int i = 0; i < keyArray.length; ++i) {
                    CacheEntry entry = this.get(keyArray[i]);
                    if (entry == null) continue;
                    result.add(entry);
                }
                return result;
            }
            CacheEntry entry = this.get(key);
            if (entry == null) {
                return Collections.emptyList();
            }
            return Arrays.asList(entry);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
            this.indexLock.writeLock().lock();
            try {
                List<CacheEntry> list = this.getListByIndex(indexKey, indexValue);
                if (list != null) {
                    for (CacheEntry e : list) {
                        this.remove(e.getKey());
                    }
                }
                List<CacheEntry> list2 = list;
                return list2;
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }

        @Override
        protected void removeNullEntry(NullKey key) {
            this.cache.asMap().remove(key);
        }

        @Override
        public String trace() {
            StringBuilder builder = new StringBuilder();
            builder.append("-----------------------------------");
            builder.append("\nCacheStore Info");
            builder.append("\nCacheStore:" + this);
            builder.append(super.baseTrace());
            ConcurrentMap map = this.cache.asMap();
            builder.append("\n\tcache entry size:" + map.size());
            for (Map.Entry entry : map.entrySet()) {
                builder.append("\n\t\t" + entry.getKey() + "=" + entry.getValue());
            }
            builder.append("\n\tindexCache size:" + this.indexCache.length);
            for (int i = 0; i < this.indexCache.length; ++i) {
                builder.append("\n\tindexCache[" + i + "] entry size:" + this.indexCache[i].size());
                for (Map.Entry<Object, Object> entry : this.indexCache[i].entrySet()) {
                    if (entry.getValue() instanceof Object[]) {
                        builder.append("\n\t\t" + entry.getKey() + "=" + Arrays.toString((Object[])entry.getValue()));
                        continue;
                    }
                    builder.append("\n\t\t" + entry.getKey() + "=" + entry.getValue());
                }
            }
            builder.append("\n-----------------------------------");
            return builder.toString();
        }

        @Override
        public void destroy() {
            this.indexLock.writeLock().lock();
            try {
                this.cache.asMap().clear();
                this.cache.invalidateAll();
                this.cache.cleanUp();
                for (int i = 0; i < this.indexCache.length; ++i) {
                    this.indexCache[i] = null;
                }
            }
            finally {
                this.indexLock.writeLock().unlock();
            }
        }
    }

    public static class ConcurrentHashMapCacheStore
    extends SimpleCacheStoreBase {
        private final Cache<Object, CacheEntry> cache;
        private long timeToLive;

        public ConcurrentHashMapCacheStore(String namespace, CacheStoreFactory factory, int initialCapacity, float loadFactor, int concurrencyLevel, long timeToLive, int size) {
            super(namespace, true, factory);
            this.timeToLive = timeToLive;
            this.cache = size > 0 ? Caffeine.newBuilder().maximumSize((long)size).initialCapacity(initialCapacity).removalListener((key, value, cause) -> {
                if (cause.wasEvicted()) {
                    this.notifyRemoved((CacheEntry)value);
                }
            }).build() : Caffeine.newBuilder().initialCapacity(initialCapacity).build();
        }

        @Override
        protected void removeInvalidEntry() {
            List<Object> keys = this.keySet();
            if (keys != null) {
                for (Object k : keys) {
                    this.get(k);
                }
            }
        }

        @Override
        public CacheEntry get(Object key) {
            if (key == null) {
                return null;
            }
            CacheEntry e = (CacheEntry)this.cache.getIfPresent(key);
            if (!SimpleCacheStoreFactory.isStillAliveOrNull(e, this.timeToLive)) {
                this.remove(e);
                return null;
            }
            return e;
        }

        @Override
        public CacheEntry put(CacheEntry entry, boolean isClean) {
            CacheEntry previous = this.cache.asMap().put(entry.getKey(), entry);
            if (previous == null) {
                this.notifyPut(entry);
            } else {
                this.notifyUpdated(previous, entry);
            }
            return previous;
        }

        @Override
        public CacheEntry remove(Object key) {
            CacheEntry previous = (CacheEntry)this.cache.asMap().remove(key);
            if (previous != null) {
                this.notifyRemoved(previous);
            }
            return previous;
        }

        @Override
        public void removeAll() {
            if (this.hasListener()) {
                for (Object k : this.keySet()) {
                    this.remove(k);
                }
            } else {
                this.cache.asMap().clear();
            }
        }

        @Override
        public CacheEntry putIfAbsent(CacheEntry entry) {
            CacheEntry putted = this.cache.asMap().putIfAbsent(entry.getKey(), entry);
            if (putted == null) {
                this.notifyPut(entry);
            }
            return putted;
        }

        @Override
        public boolean remove(CacheEntry entry) {
            boolean res = this.cache.asMap().remove(entry.getKey(), entry);
            if (res) {
                this.notifyRemoved(entry);
            }
            return res;
        }

        @Override
        public CacheEntry replace(CacheEntry entry) {
            CacheEntry previous = this.cache.asMap().replace(entry.getKey(), entry);
            if (previous != null) {
                this.notifyUpdated(previous, entry);
            }
            return previous;
        }

        @Override
        public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
            if (!oldEntry.getKey().equals(newEntry.getKey())) {
                throw new IllegalArgumentException("oldEntry key not equals newEntryKey");
            }
            boolean res = this.cache.asMap().replace(newEntry.getKey(), oldEntry, newEntry);
            if (res) {
                this.notifyUpdated(oldEntry, newEntry);
            }
            return res;
        }

        @Override
        public List<Object> keySet() {
            return new ArrayList<Object>(this.cache.asMap().keySet());
        }

        @Override
        public CacheEntry getByIndex(int indexKey, Object indexValue) {
            return null;
        }

        @Override
        public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
            return Collections.emptyList();
        }

        @Override
        public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
            List<CacheEntry> list = this.getListByIndex(indexKey, indexValue);
            if (list != null) {
                for (CacheEntry e : list) {
                    this.remove(e.getKey());
                }
            }
            return list;
        }

        @Override
        protected void removeNullEntry(NullKey key) {
            this.cache.asMap().remove(key);
        }

        @Override
        public String trace() {
            StringBuilder builder = new StringBuilder();
            builder.append("-----------------------------------");
            builder.append("\nCacheStore Info");
            builder.append("\nCacheStore:" + this);
            builder.append(super.baseTrace());
            ConcurrentMap map = this.cache.asMap();
            builder.append("\n\tcache entry size:" + map.size());
            for (Map.Entry entry : map.entrySet()) {
                builder.append("\n\t\t" + entry.getKey() + "=" + entry.getValue());
            }
            builder.append("\n-----------------------------------");
            return builder.toString();
        }

        @Override
        public void destroy() {
            this.cache.asMap().clear();
            this.cache.invalidateAll();
            this.cache.cleanUp();
        }
    }
}

