/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cluster.channel.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.StatusLine;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.iplass.mtp.impl.async.AsyncTaskService;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.impl.cluster.channel.MessageChannel;
import org.iplass.mtp.impl.cluster.channel.MessageReceiver;
import org.iplass.mtp.impl.cluster.channel.http.SendMessageTask;
import org.iplass.mtp.impl.core.config.ServerEnv;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpMessageChannel
implements MessageChannel,
ServiceInitListener<ClusterService> {
    private static Logger logger = LoggerFactory.getLogger(HttpMessageChannel.class);
    public static final String PORT_DEF_SYSTEM_PROP_NAME = "mtp.cluster.http.myportno";
    public static final String SERVER_NAME_DEF_SYSTEM_PROP_NAME = "mtp.cluster.http.myservername";
    public static final String INTERFACE_NAME_DEF_SYSTEM_PROP_NAME = "mtp.cluster.http.myinterfacename";
    public static final String ASYNC_TASK_SERVICE_NAME = "AsyncTaskServiceForHttpMessageChannel";
    public static final String CERT_KEY_NAME = "certKey";
    public static final String EVENT_NAME_NAME = "en";
    private List<String> serverUrl;
    private String certKey;
    private MessageReceiver messageHandler;
    private Integer connectionTimeout = 30000;
    private Integer soTimeout = 30000;
    private String proxyHost;
    private Integer proxyPort;
    private Integer poolingMaxTotal;
    private Integer poolingDefaultMaxPerRoute;
    private Integer poolingTimeToLive;
    private Integer retryCount = 3;
    private Integer retryDelay = 10000;
    private CloseableHttpClient httpClient;
    private Timer timer = new Timer("httpMessageChannelRetryTimer", true);
    private AsyncTaskService asyncTaskService;

    HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Integer getPoolingTimeToLive() {
        return this.poolingTimeToLive;
    }

    public void setPoolingTimeToLive(Integer poolingTimeToLive) {
        this.poolingTimeToLive = poolingTimeToLive;
    }

    public Integer getPoolingMaxTotal() {
        return this.poolingMaxTotal;
    }

    public void setPoolingMaxTotal(Integer poolingMaxTotal) {
        this.poolingMaxTotal = poolingMaxTotal;
    }

    public Integer getPoolingDefaultMaxPerRoute() {
        return this.poolingDefaultMaxPerRoute;
    }

    public void setPoolingDefaultMaxPerRoute(Integer poolingDefaultMaxPerRoute) {
        this.poolingDefaultMaxPerRoute = poolingDefaultMaxPerRoute;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public Integer getRetryDelay() {
        return this.retryDelay;
    }

    public void setRetryDelay(Integer retryDelay) {
        this.retryDelay = retryDelay;
    }

    public List<String> getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(List<String> serverUrl) {
        this.serverUrl = serverUrl;
    }

    public String getCertKey() {
        return this.certKey;
    }

    public void setCertKey(String certKey) {
        this.certKey = certKey;
    }

    public Integer getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Integer connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Integer getSoTimeout() {
        return this.soTimeout;
    }

    public void setSoTimeout(Integer soTimeout) {
        this.soTimeout = soTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    @Override
    public void setMessageReceiver(MessageReceiver messageHandler) {
        this.messageHandler = messageHandler;
    }

    public void doReceiveMessage(Message msg, String certKeyFromOther) {
        if (this.certKey != null && !this.certKey.equals(certKeyFromOther)) {
            return;
        }
        this.messageHandler.receiveMessage(msg);
    }

    public MessageReceiver getMessageHandler() {
        return this.messageHandler;
    }

    void doRetry(final SendMessageTask task) {
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                HttpMessageChannel.this.asyncTaskService.execute(task);
            }
        }, this.retryDelay.intValue());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int doSend(Message message, String url) throws IOException {
        int n;
        HttpPost post = null;
        HttpEntity entity = null;
        try {
            post = new HttpPost(url);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            if (this.certKey != null) {
                params.add(new BasicNameValuePair(CERT_KEY_NAME, this.certKey));
            }
            params.add(new BasicNameValuePair(EVENT_NAME_NAME, message.getEventName()));
            if (message.getParam() != null) {
                for (Map.Entry<String, String> e : message.getParam().entrySet()) {
                    params.add(new BasicNameValuePair(e.getKey(), e.getValue()));
                }
            }
            post.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            StatusLine statusLine = response.getStatusLine();
            entity = response.getEntity();
            n = statusLine.getStatusCode();
            if (entity == null) return n;
        }
        catch (IOException e) {
            try {
                if (post == null) throw e;
                post.abort();
                throw e;
                catch (RuntimeException e2) {
                    if (post == null) throw e2;
                    post.abort();
                    throw e2;
                }
            }
            catch (Throwable throwable) {
                if (entity == null) throw throwable;
                try {
                    EntityUtils.consume(entity);
                    throw throwable;
                }
                catch (IOException e3) {
                    logger.error("may be http connection leak... " + e3, (Throwable)e3);
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume((HttpEntity)entity);
            return n;
        }
        catch (IOException e) {
            logger.error("may be http connection leak... " + e, (Throwable)e);
        }
        return n;
    }

    @Override
    public void sendMessage(Message message) {
        if (this.serverUrl != null && this.serverUrl.size() > 0) {
            for (String url : this.serverUrl) {
                this.asyncTaskService.execute(new SendMessageTask(message, url, this.retryCount, this));
            }
        }
    }

    private List<URI> toURI(List<String> urls) throws URISyntaxException {
        ArrayList<URI> ret = new ArrayList<URI>();
        for (String url : urls) {
            URI u = new URI(url);
            ret.add(u);
        }
        return ret;
    }

    private void addHostNameAndAddress(Set<String> list, InetAddress ia) {
        String hostName = ia.getHostName();
        if (ia.isLoopbackAddress()) {
            list.add("localhost");
            list.add(ia.getHostAddress());
        } else {
            list.add(hostName);
            String address = ia.getHostAddress();
            if (hostName.contains(".") && !address.equals(hostName)) {
                list.add(hostName.substring(0, hostName.indexOf(46)));
            }
            list.add(address);
        }
    }

    private String[] getMyServerNameAndAddress() throws SocketException {
        Enumeration<InetAddress> addresses;
        String defHostName = ServerEnv.getInstance().getProperty(SERVER_NAME_DEF_SYSTEM_PROP_NAME);
        if (defHostName == null) {
            defHostName = ServerEnv.getInstance().getProperty("mtp.server.myservername");
        }
        if (defHostName != null) {
            return new String[]{defHostName};
        }
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        String networkInterfaceName = ServerEnv.getInstance().getProperty(INTERFACE_NAME_DEF_SYSTEM_PROP_NAME);
        if (networkInterfaceName == null) {
            networkInterfaceName = ServerEnv.getInstance().getProperty("mtp.server.myinterfacename");
        }
        NetworkInterface ni = null;
        NetworkInterface loopBack = null;
        if (networkInterfaceName != null) {
            ni = NetworkInterface.getByName(networkInterfaceName);
            if (ni == null) {
                throw new ServiceConfigrationException("networkInterfaceName:" + networkInterfaceName + " not found...");
            }
        } else {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface forCheck = e.nextElement();
                if (forCheck.isLoopback()) {
                    loopBack = forCheck;
                    continue;
                }
                if (!forCheck.isUp()) continue;
                ni = forCheck;
                break;
            }
        }
        if (ni != null) {
            addresses = ni.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        if (loopBack != null) {
            addresses = loopBack.getInetAddresses();
            while (addresses.hasMoreElements()) {
                this.addHostNameAndAddress(list, addresses.nextElement());
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private int getMyPort() {
        String portStr = ServerEnv.getInstance().getProperty(PORT_DEF_SYSTEM_PROP_NAME);
        if (portStr == null) {
            return -1;
        }
        return Integer.parseInt(portStr);
    }

    @Override
    public void inited(ClusterService service, Config config) {
        this.asyncTaskService = (AsyncTaskService)config.getDependentService(ASYNC_TASK_SERVICE_NAME);
        if (this.serverUrl != null) {
            try {
                ArrayList<String> newServerUrl = new ArrayList<String>();
                List<URI> uriList = this.toURI(this.serverUrl);
                String[] myServerNames = this.getMyServerNameAndAddress();
                int port = this.getMyPort();
                for (int i = 0; i < uriList.size(); ++i) {
                    URI uri = uriList.get(i);
                    boolean isMyHost = false;
                    for (String myName : myServerNames) {
                        if (uri.getHost().equals(myName)) {
                            if (port == -1) {
                                int portCount = 0;
                                for (URI uu : uriList) {
                                    if (!uu.getHost().equals(uri.getHost())) continue;
                                    ++portCount;
                                }
                                if (portCount > 1) {
                                    if (uri.getPort() == port) {
                                        isMyHost = true;
                                    }
                                } else {
                                    isMyHost = true;
                                }
                            } else if (uri.getPort() == port) {
                                isMyHost = true;
                            }
                        }
                        if (isMyHost) break;
                    }
                    if (!isMyHost) {
                        newServerUrl.add(this.serverUrl.get(i));
                        continue;
                    }
                    if (!logger.isDebugEnabled()) continue;
                    logger.debug(this.serverUrl.get(i) + " is my server(and port) url, so remove notifiy list.");
                }
                this.serverUrl = newServerUrl;
            }
            catch (SocketException | URISyntaxException e) {
                throw new ServiceConfigrationException("clusterservice setting is invalid:" + e.toString(), e);
            }
        }
        if (this.serverUrl != null && this.serverUrl.size() > 0) {
            RequestConfig.Builder builder = RequestConfig.custom().setConnectTimeout(this.connectionTimeout.intValue()).setSocketTimeout(this.soTimeout.intValue());
            if (this.proxyHost != null) {
                builder.setProxy(new HttpHost(this.proxyHost, this.proxyPort.intValue()));
            }
            HttpClientBuilder hcBuilder = HttpClientBuilder.create().setDefaultRequestConfig(builder.build());
            if (this.poolingMaxTotal != null) {
                hcBuilder.setMaxConnTotal(this.poolingMaxTotal.intValue());
            }
            if (this.poolingDefaultMaxPerRoute != null) {
                hcBuilder.setMaxConnPerRoute(this.poolingDefaultMaxPerRoute.intValue());
            }
            if (this.poolingTimeToLive != null) {
                hcBuilder.setConnectionTimeToLive(this.poolingTimeToLive.longValue(), TimeUnit.MILLISECONDS);
            }
            this.httpClient = hcBuilder.build();
        }
    }

    @Override
    public void destroyed() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.httpClient = null;
        this.timer.cancel();
    }
}

