/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.beanutils.ConvertUtils;
import org.iplass.mtp.impl.core.config.NameValue;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.Service;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.iplass.mtp.spi.ServiceInitListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigImpl
implements Config {
    private static final Logger logger = LoggerFactory.getLogger(ConfigImpl.class);
    private static final Map<String, Class<?>> primitiveMap = new HashMap();
    private static final Map<Class<?>, Class<?>> primitiveWrapperMap = new HashMap();
    private String serviceName;
    private LinkedHashMap<String, Instance> beanMap;
    private LinkedHashMap<String, Instance> propMap;
    private Map<String, Service> dependentServices;
    private List<String> dependentServiceNames;

    public ConfigImpl(String serviceName, NameValue[] nameValues, NameValue[] beanNameValues) {
        this.serviceName = serviceName;
        this.beanMap = ConfigImpl.toNameValueMap(beanNameValues, null);
        this.propMap = ConfigImpl.toNameValueMap(nameValues, this.beanMap);
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    public void addDependentService(String type, Service instance) {
        if (this.dependentServices == null) {
            this.dependentServices = new HashMap<String, Service>();
            this.dependentServiceNames = new ArrayList<String>();
        }
        this.dependentServices.put(type, instance);
        this.dependentServiceNames.add(type);
    }

    @Override
    public List<String> getDependentServiceNames() {
        return this.dependentServiceNames;
    }

    @Override
    public <T extends Service> T getDependentService(Class<T> type) {
        if (this.dependentServices == null) {
            return null;
        }
        return (T)this.dependentServices.get(type.getName());
    }

    @Override
    public <T extends Service> T getDependentService(String serviceName) {
        if (this.dependentServices == null) {
            return null;
        }
        return (T)this.dependentServices.get(serviceName);
    }

    private static LinkedHashMap<String, Instance> toNameValueMap(NameValue[] nameValues, Map<String, Instance> sharedMap) {
        LinkedHashMap<String, Instance> nvm = new LinkedHashMap<String, Instance>();
        if (sharedMap == null) {
            sharedMap = nvm;
        }
        if (nameValues != null) {
            for (NameValue nv : nameValues) {
                Instance val = nvm.get(nv.getName());
                if (val == null) {
                    val = new Instance(sharedMap);
                    nvm.put(nv.getName(), val);
                }
                val.add(nv);
            }
        }
        return nvm;
    }

    private Object valueInit(String name, Class<?> type) {
        Instance i = this.propMap.get(name);
        if (i != null) {
            i.init(type);
            return i.instance;
        }
        return null;
    }

    private static Class<?> toClass(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            Class<?> primType = primitiveMap.get(className);
            if (primType != null) {
                return primType;
            }
            throw new ServiceConfigrationException(e);
        }
    }

    private static PropertyDescriptor getPropertyDescriptor(Class<?> clazz, String name) throws IntrospectionException {
        BeanInfo bi = Introspector.getBeanInfo(clazz);
        PropertyDescriptor[] pds = bi.getPropertyDescriptors();
        if (pds != null) {
            for (PropertyDescriptor pd : pds) {
                if (!pd.getName().equals(name)) continue;
                return pd;
            }
        }
        return null;
    }

    private static boolean isSupport(Class<?> type) {
        if (type.isPrimitive()) {
            return true;
        }
        if (type == String.class || type == Boolean.class || type == Integer.class || type == Long.class || type == Float.class || type == Double.class || type == Date.class || type == Timestamp.class || type == Time.class || type == BigDecimal.class || type == Class.class) {
            return true;
        }
        return type.isEnum();
    }

    private static Object conv(Object value, Class<?> type) {
        if (value instanceof String) {
            String str = (String)value;
            if (type == String.class) {
                return value;
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                if ("TRUE".equalsIgnoreCase(str)) {
                    return Boolean.TRUE;
                }
                if ("FALSE".equalsIgnoreCase(str)) {
                    return Boolean.FALSE;
                }
                return null;
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.parseInt(str);
            }
            if (type == Long.class || type == Long.TYPE) {
                return Long.parseLong(str);
            }
            if (type == Float.class || type == Float.TYPE) {
                return Float.valueOf(Float.parseFloat(str));
            }
            if (type == Double.class || type == Double.TYPE) {
                return Double.parseDouble(str);
            }
            if (type == Class.class) {
                try {
                    return Class.forName(str);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, str);
            }
            return ConvertUtils.convert((String)str, type);
        }
        return value;
    }

    @Override
    public Set<String> getNames() {
        return this.propMap.keySet();
    }

    @Override
    public String getValue(String name) {
        Object value = this.valueInit(name, null);
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof List && (value = ((List)value).get(0)) instanceof String) {
            return (String)value;
        }
        Instance i = this.propMap.get(name);
        if (i != null && i.nvl != null && i.nvl.size() > 0) {
            return i.nvl.get(0).value();
        }
        return null;
    }

    @Override
    public List<String> getValues(String name) {
        Instance i;
        Object value = this.valueInit(name, null);
        if (value instanceof String) {
            ArrayList<String> res = new ArrayList<String>();
            res.add((String)value);
            return res;
        }
        if (value instanceof List) {
            boolean isStr = true;
            for (Object o : (List)value) {
                if (o == null || o instanceof String) continue;
                isStr = false;
                break;
            }
            if (isStr) {
                return (List)value;
            }
        }
        if ((i = this.propMap.get(name)) != null && i.nvl != null && i.nvl.size() > 0) {
            ArrayList<String> ret = new ArrayList<String>(i.nvl.size());
            for (NameValue nv : i.nvl) {
                ret.add(nv.value());
            }
            return ret;
        }
        return null;
    }

    @Override
    public <T> T getValue(String name, Class<T> type) {
        Object value;
        if (type == Object.class) {
            type = null;
        }
        if ((value = this.valueInit(name, type)) instanceof List) {
            return (T)((List)value).get(0);
        }
        return (T)value;
    }

    @Override
    public <T> List<T> getValues(String name, Class<T> type) {
        Object value;
        if (type == Object.class) {
            type = null;
        }
        if ((value = this.valueInit(name, type)) == null) {
            return null;
        }
        if (value instanceof List) {
            return (List)value;
        }
        return Collections.singletonList(value);
    }

    @Override
    public <T> T getValue(String name, Class<T> type, T defaultValue) {
        T ret = this.getValue(name, type);
        if (ret == null) {
            return defaultValue;
        }
        return ret;
    }

    @Override
    public <T> List<T> getValues(String name, Class<T> type, List<T> defaultValues) {
        List<T> ret = this.getValues(name, type);
        if (ret == null) {
            return defaultValues;
        }
        return ret;
    }

    @Override
    public Object getBean(String name) {
        return this.getValue(name, null);
    }

    @Override
    public List<?> getBeans(String name) {
        return this.getValues(name, null);
    }

    public void notifyInited(Service service) {
        for (Instance i : this.beanMap.values()) {
            this.inited(service, i);
        }
        for (Instance i : this.propMap.values()) {
            this.inited(service, i);
        }
    }

    private void inited(Service service, Instance i) {
        block3: {
            block4: {
                block2: {
                    i.init(null);
                    if (!(i.instance instanceof ServiceInitListener)) break block2;
                    ((ServiceInitListener)i.instance).inited(service, this);
                    break block3;
                }
                if (!(i.instance instanceof List)) break block4;
                for (Object lp : (List)i.instance) {
                    if (!(lp instanceof ServiceInitListener)) continue;
                    ((ServiceInitListener)lp).inited(service, this);
                }
                break block3;
            }
            if (!(i.instance instanceof Map)) break block3;
            for (Object mp : ((Map)i.instance).values()) {
                if (!(mp instanceof ServiceInitListener)) continue;
                ((ServiceInitListener)mp).inited(service, this);
            }
        }
    }

    public void notifyDestroyed() {
        for (Instance i : this.propMap.values()) {
            this.destroyed(i);
        }
        for (Instance i : this.beanMap.values()) {
            this.destroyed(i);
        }
    }

    private void destroyed(Instance i) {
        block3: {
            block4: {
                block2: {
                    if (!(i.instance instanceof ServiceInitListener)) break block2;
                    ((ServiceInitListener)i.instance).destroyed();
                    break block3;
                }
                if (!(i.instance instanceof List)) break block4;
                for (Object lp : (List)i.instance) {
                    if (!(lp instanceof ServiceInitListener)) continue;
                    ((ServiceInitListener)lp).destroyed();
                }
                break block3;
            }
            if (!(i.instance instanceof Map)) break block3;
            for (Object mp : ((Map)i.instance).values()) {
                if (!(mp instanceof ServiceInitListener)) continue;
                ((ServiceInitListener)mp).destroyed();
            }
        }
    }

    static {
        primitiveMap.put(Boolean.TYPE.getName(), Boolean.TYPE);
        primitiveMap.put(Byte.TYPE.getName(), Byte.TYPE);
        primitiveMap.put(Character.TYPE.getName(), Character.TYPE);
        primitiveMap.put(Short.TYPE.getName(), Short.TYPE);
        primitiveMap.put(Integer.TYPE.getName(), Integer.TYPE);
        primitiveMap.put(Long.TYPE.getName(), Long.TYPE);
        primitiveMap.put(Double.TYPE.getName(), Double.TYPE);
        primitiveMap.put(Float.TYPE.getName(), Float.TYPE);
        primitiveWrapperMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperMap.put(Character.TYPE, Character.class);
        primitiveWrapperMap.put(Short.TYPE, Short.class);
        primitiveWrapperMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperMap.put(Long.TYPE, Long.class);
        primitiveWrapperMap.put(Double.TYPE, Double.class);
        primitiveWrapperMap.put(Float.TYPE, Float.class);
    }

    private static class Instance {
        List<NameValue> nvl;
        Class<?> type;
        Object instance;
        boolean inited;
        Map<String, Instance> beanMap;

        Instance(Map<String, Instance> beanMap) {
            this.beanMap = beanMap;
        }

        void add(NameValue nv) {
            if (this.nvl == null) {
                this.nvl = new LinkedList<NameValue>();
            }
            this.nvl.add(nv);
        }

        private Object toInstance(NameValue nv) {
            Class<?> c2;
            Class<?> c1;
            if (nv.isNull()) {
                return null;
            }
            if (nv.getRef() != null) {
                Instance bi = this.beanMap.get(nv.getRef());
                if (bi == null) {
                    logger.warn("No bean defined on property:" + nv.getName() + "'s ref:" + nv.getRef());
                    return null;
                }
                bi.init(null);
                return bi.instance;
            }
            if (nv.getClassName() == null) {
                if (this.type == null) {
                    return nv.value();
                }
                if (ConfigImpl.isSupport(this.type)) {
                    return ConfigImpl.conv(nv.value(), this.type);
                }
                if (this.type == Map.class) {
                    return this.toBean(HashMap.class, nv.getProperty(), nv.getArg());
                }
                return this.toBean(this.type, nv.getProperty(), nv.getArg());
            }
            Class cn = ConfigImpl.toClass(nv.getClassName());
            if (this.type != null && !this.type.isAssignableFrom(cn) && (c1 = this.toWrapperType(this.type)) != (c2 = this.toWrapperType(cn))) {
                throw new ClassCastException(cn.getName() + " can not assignable to " + this.type.getName());
            }
            if (ConfigImpl.isSupport(cn)) {
                return ConfigImpl.conv(nv.value(), cn);
            }
            return this.toBean(cn, nv.getProperty(), nv.getArg());
        }

        private Class<?> toWrapperType(Class<?> cls) {
            if (cls != null && cls.isPrimitive()) {
                return (Class)primitiveWrapperMap.get(this.type);
            }
            return cls;
        }

        void init(Class<?> type) {
            if (this.inited) {
                return;
            }
            this.type = type;
            if (this.nvl == null || this.nvl.size() == 0) {
                this.instance = null;
            } else if (this.nvl.size() == 1) {
                NameValue nv = this.nvl.get(0);
                this.instance = this.toInstance(nv);
            } else {
                ArrayList<Object> valList = new ArrayList<Object>(this.nvl.size());
                for (NameValue nv : this.nvl) {
                    valList.add(this.toInstance(nv));
                }
                this.instance = valList;
            }
            this.inited = true;
        }

        Object toArray(Class<?> toType) {
            if (this.type != null && !toType.isAssignableFrom(this.type)) {
                throw new ClassCastException(this.type.getName() + " can not assignable to " + toType.getName());
            }
            if (this.instance == null) {
                return null;
            }
            Object array = Array.newInstance(toType, this.nvl.size());
            if (this.nvl.size() == 1) {
                Array.set(array, 0, this.instance);
            } else {
                List l = (List)this.instance;
                for (int i = 0; i < this.nvl.size(); ++i) {
                    Array.set(array, i, l.get(i));
                }
            }
            return array;
        }

        <T> List<T> toList(Class<T> toType) {
            if (this.type != null && !toType.isAssignableFrom(this.type)) {
                throw new ClassCastException(this.type.getName() + " can not assignable to " + toType.getName());
            }
            if (this.instance == null) {
                return null;
            }
            if (this.nvl.size() == 1) {
                ArrayList<Object> l = new ArrayList<Object>(this.nvl.size());
                l.add(this.instance);
                return l;
            }
            return (List)this.instance;
        }

        private Object toBean(Class<?> type, NameValue[] props, NameValue[] args) {
            try {
                Object bean = this.newIns(type, args);
                if (props != null) {
                    LinkedHashMap nvMap = ConfigImpl.toNameValueMap(props, this.beanMap);
                    for (Map.Entry e : nvMap.entrySet()) {
                        this.setProperty(bean, (String)e.getKey(), (Instance)e.getValue());
                    }
                }
                return bean;
            }
            catch (NoSuchMethodException e) {
                throw new ServiceConfigrationException(e);
            }
            catch (InvocationTargetException e) {
                throw new ServiceConfigrationException(e);
            }
            catch (IntrospectionException e) {
                throw new ServiceConfigrationException(e);
            }
            catch (InstantiationException e) {
                throw new ServiceConfigrationException(e);
            }
            catch (IllegalAccessException e) {
                throw new ServiceConfigrationException(e);
            }
        }

        private Object invokeConstructor(Constructor<?> c, LinkedHashMap<String, Instance> argMap) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Parameter[] params = c.getParameters();
            Object[] paramValues = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                Parameter p = params[i];
                Instance ins = argMap.get(p.getName());
                if (ins == null) {
                    return null;
                }
                Class<?> type = p.getType();
                if (type != null) {
                    if (type.isArray()) {
                        type = type.getComponentType();
                    } else if (Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type)) {
                        boolean resolve = false;
                        Type gt = p.getParameterizedType();
                        if (gt instanceof ParameterizedType) {
                            ParameterizedType pt = (ParameterizedType)gt;
                            Type t = pt.getActualTypeArguments()[0];
                            if (t instanceof Class && !Object.class.equals((Object)t)) {
                                type = (Class<?>)t;
                                resolve = true;
                            } else if (t instanceof ParameterizedType) {
                                type = ((ParameterizedType)t).getRawType().getClass();
                                resolve = true;
                            }
                        }
                        if (!resolve) {
                            type = null;
                        }
                    }
                }
                if (type != null && ins.inited && ins.type != null && !type.isAssignableFrom(ins.type)) {
                    ins.inited = false;
                }
                ins.init(type);
                Object value = ins.instance == null ? null : (p.getType().isArray() ? ins.toArray(type) : (p.getType() == List.class ? ins.toList(type) : ins.instance));
                paramValues[i] = value;
            }
            return c.newInstance(paramValues);
        }

        /*
         * WARNING - void declaration
         */
        private Object newIns(Class<?> type, NameValue[] args) throws InstantiationException, IllegalAccessException {
            void var7_9;
            if (args == null) {
                return type.newInstance();
            }
            LinkedHashMap argMap = ConfigImpl.toNameValueMap(args, this.beanMap);
            ArrayList targets = new ArrayList();
            Constructor<?>[] constructorArray = type.getConstructors();
            int n = constructorArray.length;
            boolean bl = false;
            while (var7_9 < n) {
                Constructor<?> c = constructorArray[var7_9];
                if (argMap.size() == c.getParameterCount()) {
                    targets.add(c);
                }
                ++var7_9;
            }
            Exception ee = null;
            for (Constructor constructor : targets) {
                try {
                    Object ins = this.invokeConstructor(constructor, argMap);
                    if (ins == null) continue;
                    return ins;
                }
                catch (Exception e) {
                    if (ee == null) {
                        ee = e;
                        continue;
                    }
                    ee.addSuppressed(e);
                }
            }
            if (ee != null) {
                throw new ServiceConfigrationException("no suitable constructor " + type.getName() + " with args:" + Arrays.toString(args), ee);
            }
            throw new ServiceConfigrationException("no suitable constructor " + type.getName() + " with args:" + Arrays.toString(args));
        }

        private void setProperty(Object bean, String propName, Instance val) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IntrospectionException {
            try {
                PropertyDescriptor pd = ConfigImpl.getPropertyDescriptor(bean.getClass(), propName);
                if (pd == null) {
                    if (bean instanceof Map) {
                        val.init(null);
                        ((Map)bean).put(propName, val.instance);
                    } else {
                        logger.warn("No property defined: " + propName + " on " + bean.getClass().getName());
                    }
                    return;
                }
                Class<?> type = pd.getPropertyType();
                if (type != null) {
                    if (type.isArray()) {
                        type = type.getComponentType();
                    } else if (Map.class == type) {
                        type = HashMap.class;
                    } else if (Collection.class.isAssignableFrom(type)) {
                        boolean resolve = false;
                        Method getter = pd.getReadMethod();
                        Type gt = getter.getGenericReturnType();
                        if (gt instanceof ParameterizedType) {
                            ParameterizedType pt = (ParameterizedType)gt;
                            Type t = pt.getActualTypeArguments()[0];
                            if (t instanceof Class && !Object.class.equals((Object)t)) {
                                type = (Class<?>)t;
                                resolve = true;
                            } else if (t instanceof ParameterizedType) {
                                type = ((ParameterizedType)t).getRawType().getClass();
                                resolve = true;
                            }
                        }
                        if (!resolve) {
                            type = null;
                        }
                    }
                }
                val.init(type);
                Object value = val.instance;
                if (value != null) {
                    if (pd.getPropertyType().isArray()) {
                        Object array = val.toArray(type);
                        if (pd.getWriteMethod() != null) {
                            pd.getWriteMethod().invoke(bean, array);
                        } else {
                            logger.warn("writeMethod not defined, so can't set array value to " + propName + " on " + bean.getClass().getName());
                        }
                    } else if (pd.getPropertyType() == List.class) {
                        List<?> list = (List<?>)pd.getReadMethod().invoke(bean, new Object[0]);
                        if (list == null) {
                            list = val.toList(type);
                            if (pd.getWriteMethod() != null) {
                                pd.getWriteMethod().invoke(bean, list);
                            } else {
                                logger.warn("writeMethod not defined, so can't set list value to " + propName + " on " + bean.getClass().getName());
                            }
                        } else {
                            list.clear();
                            list.addAll(val.toList(type));
                        }
                    } else if (pd.getWriteMethod() != null) {
                        pd.getWriteMethod().invoke(bean, value);
                    } else {
                        logger.warn("writeMethod not defined, so can't set value to " + propName + " on " + bean.getClass().getName());
                    }
                }
            }
            catch (RuntimeException e) {
                throw new ServiceConfigrationException("cant set property value:" + propName + " to " + bean, e);
            }
        }
    }
}

