/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.sql.Timestamp;
import java.util.List;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlConverter;
import org.iplass.mtp.impl.datastore.grdb.sql.queryconvert.SqlQueryContext;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.properties.extend.VirtualType;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class ObjStoreInsertSql
extends UpdateSqlHandler {
    public String copyToTemporaryTable(EntityHandler handler, Where cond, RdbAdapter rdb, EntityContext entityContext) {
        Query q = new Query();
        q.select("oid", "version").from(handler.getMetaData().getName()).setWhere(cond);
        SqlQueryContext qc = new SqlQueryContext(handler, entityContext, rdb);
        SqlConverter conv = new SqlConverter(qc, false);
        q.accept(conv);
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO " + rdb.getTemplaryTablePrefix() + "OBJ_STORE_TMP");
        sb.append(" ");
        sb.append(qc.toSelectSql());
        return sb.toString();
    }

    public String insertSubPage(int tenantId, EntityHandler eh, Entity model, int pageNo, RdbAdapter rdbAdaptor, EntityContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append("(TENANT_ID,OBJ_DEF_ID,OBJ_ID,OBJ_VER,PG_NO");
        List<PropertyHandler> propList = eh.getDeclaredPropertyList();
        this.handlePropList(sb, tenantId, propList, model, pageNo, rdbAdaptor);
        sb.append(") VALUES(");
        sb.append(tenantId).append(",'");
        sb.append(rdbAdaptor.sanitize(eh.getMetaData().getId())).append("',");
        sb.append("'").append(rdbAdaptor.sanitize(model.getOid())).append("'");
        sb.append(",");
        sb.append(model.getVersion()).append(",");
        sb.append(pageNo);
        this.handleValue(sb, tenantId, propList, model, pageNo, rdbAdaptor);
        sb.append(")");
        return sb.toString();
    }

    private void handlePropList(StringBuilder sb, int tenantId, List<PropertyHandler> propList, Entity model, int pageNo, RdbAdapter rdbAdaptor) {
        for (PropertyHandler p : propList) {
            if (!(p instanceof PrimitivePropertyHandler) || ((PrimitivePropertyHandler)p).getMetaData().getType().isVirtual()) continue;
            GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)p.getStoreSpecProperty());
            Object val = model.getValue(p.getName());
            if (!colDef.isMulti()) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)colDef;
                if (scol.getMetaData().getPageNo() == pageNo && val != null) {
                    sb.append(",");
                    sb.append(scol.getMetaData().getColumnName());
                }
                if (scol.getIndexColName() == null || scol.getMetaData().getIndexPageNo() != pageNo) continue;
                String indexColName = scol.getIndexColName();
                switch (scol.getIndexType()) {
                    case UNIQUE: {
                        sb.append(",");
                        sb.append(indexColName).append("_TD");
                        sb.append(",");
                        sb.append(indexColName);
                        break;
                    }
                    case UNIQUE_WITHOUT_NULL: 
                    case NON_UNIQUE: {
                        if (val == null) break;
                        sb.append(",");
                        sb.append(indexColName).append("_TD");
                        sb.append(",");
                        sb.append(indexColName);
                        break;
                    }
                }
                continue;
            }
            if (val == null) continue;
            MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler mcol = (MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler)colDef;
            for (MetaGRdbPropertyStore metaCol : mcol.getMetaData().getStore()) {
                if (metaCol.getPageNo() != pageNo) continue;
                sb.append(",");
                sb.append(metaCol.getColumnName());
            }
        }
    }

    private void handleValue(StringBuilder sb, int tenantId, List<PropertyHandler> propList, Entity model, int pageNo, RdbAdapter rdbAdaptor) {
        for (PropertyHandler p : propList) {
            if (!(p instanceof PrimitivePropertyHandler) || ((PrimitivePropertyHandler)p).getMetaData().getType() instanceof VirtualType) continue;
            GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)p.getStoreSpecProperty());
            Object val = model.getValue(p.getName());
            if (!colDef.isMulti()) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)colDef;
                if (scol.getMetaData().getPageNo() == pageNo && val != null) {
                    sb.append(",");
                    if (colDef.isNative()) {
                        colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(val, sb, rdbAdaptor);
                    } else {
                        colDef.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(val, sb, rdbAdaptor));
                    }
                }
                if (scol.getIndexColName() == null || scol.getMetaData().getIndexPageNo() != pageNo) continue;
                switch (scol.getIndexType()) {
                    case UNIQUE: {
                        sb.append(",'");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdbAdaptor.sanitize(p.getParent().getMetaData().getId()), pageNo));
                        sb.append("',");
                        colDef.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(val, sb, rdbAdaptor));
                        break;
                    }
                    case UNIQUE_WITHOUT_NULL: 
                    case NON_UNIQUE: {
                        if (val == null) break;
                        sb.append(",'");
                        sb.append(MetaGRdbPropertyStore.makeInternalIndexKey(tenantId, rdbAdaptor.sanitize(p.getParent().getMetaData().getId()), pageNo));
                        sb.append("',");
                        colDef.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(val, sb, rdbAdaptor));
                        break;
                    }
                }
                continue;
            }
            if (val == null) continue;
            Object[] valList = val instanceof Object[] ? (Object[])val : new Object[]{val};
            MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler mcol = (MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler)colDef;
            for (int i = 0; i < mcol.getMetaData().getStore().size(); ++i) {
                MetaGRdbPropertyStore metaCol = mcol.getMetaData().getStore().get(i);
                if (metaCol.getPageNo() != pageNo) continue;
                sb.append(",");
                if (i < valList.length) {
                    int index = i;
                    if (colDef.isNative()) {
                        colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(valList[index], sb, rdbAdaptor);
                        continue;
                    }
                    colDef.getSingleColumnRdbTypeAdapter().appendToTypedCol(sb, rdbAdaptor, () -> colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(valList[index], sb, rdbAdaptor));
                    continue;
                }
                sb.append("null");
            }
        }
    }

    public String insertMain(int tenantId, EntityHandler eh, Entity model, RdbAdapter rdbAdaptor, EntityContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("INSERT INTO ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_STORE());
        sb.append("(TENANT_ID,OBJ_DEF_ID,OBJ_ID,OBJ_VER,PG_NO,OBJ_DEF_VER,STATUS,OBJ_NAME,OBJ_DESC,CRE_DATE,UP_DATE,S_DATE,E_DATE,LOCK_USER,CRE_USER,UP_USER");
        List<PropertyHandler> propList = eh.getDeclaredPropertyList();
        this.handlePropList(sb, tenantId, propList, model, 0, rdbAdaptor);
        sb.append(") VALUES(");
        sb.append(tenantId).append(",'");
        sb.append(rdbAdaptor.sanitize(eh.getMetaData().getId())).append("',");
        sb.append("'").append(rdbAdaptor.sanitize(model.getOid())).append("'");
        sb.append(",");
        sb.append(model.getVersion()).append(",");
        sb.append("0,");
        sb.append(((MetaGRdbEntityStore)eh.getMetaData().getEntityStoreDefinition()).getVersion()).append(",");
        if (model.getValue("state") != null) {
            PropertyHandler p = eh.getProperty("state", context);
            GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)p.getStoreSpecProperty());
            colDef.getSingleColumnRdbTypeAdapter().appendToSqlAsRealType(model.getValue("state"), sb, rdbAdaptor);
            sb.append(",");
        } else {
            sb.append("'V',");
        }
        sb.append("'").append(rdbAdaptor.sanitize(model.getName())).append("',");
        if (model.getDescription() != null) {
            sb.append("'").append(rdbAdaptor.sanitize(model.getDescription())).append("',");
        } else {
            sb.append("null,");
        }
        Timestamp createDate = model.getCreateDate();
        if (createDate == null) {
            sb.append(rdbAdaptor.systimestamp()).append(",");
        } else {
            sb.append(rdbAdaptor.toTimeStampExpression(createDate)).append(",");
        }
        Timestamp updateDate = model.getUpdateDate();
        if (model.getUpdateDate() == null) {
            sb.append(rdbAdaptor.systimestamp()).append(",");
        } else {
            sb.append(rdbAdaptor.toTimeStampExpression(updateDate)).append(",");
        }
        if (model.getStartDate() != null) {
            sb.append(rdbAdaptor.toTimeStampExpression(model.getStartDate())).append(",");
        } else {
            sb.append("null,");
        }
        if (model.getEndDate() != null) {
            sb.append(rdbAdaptor.toTimeStampExpression(model.getEndDate())).append(",");
        } else {
            sb.append("null,");
        }
        if (model.getLockedBy() != null) {
            sb.append("'").append(rdbAdaptor.sanitize(model.getLockedBy())).append("',");
        } else {
            sb.append("null,");
        }
        sb.append("'").append(rdbAdaptor.sanitize(model.getCreateBy())).append("',");
        sb.append("'").append(rdbAdaptor.sanitize(model.getUpdateBy())).append("'");
        this.handleValue(sb, tenantId, propList, model, 0, rdbAdaptor);
        sb.append(")");
        return sb.toString();
    }
}

