/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.sql;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.GRdbPropertyStoreRuntime;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbMultiplePropertyStore;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbPropertyStore;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.ColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.DirectColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.FixedExpressionColumnValueMapper;
import org.iplass.mtp.impl.datastore.grdb.strategy.bulkupdate.mapper.PropertyColumnValueMapper;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.properties.extend.VirtualType;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;

public class ObjStoreBulkUpdateSql {
    public static boolean canUpdateProperty(PropertyHandler pHandler) {
        if (pHandler instanceof ReferencePropertyHandler) {
            return false;
        }
        PrimitivePropertyHandler pph = (PrimitivePropertyHandler)pHandler;
        if (pph.getMetaData().getType() instanceof VirtualType) {
            return false;
        }
        String propName = pHandler.getName();
        return !propName.equals("oid") && !propName.equals("updateDate") && !propName.equals("version") && !propName.equals("createBy") && !propName.equals("createDate");
    }

    private static boolean handlePropAndVal(List<ColumnValueMapper> values, int tenantId, EntityHandler eh, int pageNo, List<String> updateProperties, RdbAdapter rdbAdaptor, EntityContext context) {
        boolean ret = false;
        for (PropertyHandler p : eh.getPropertyList(context)) {
            if (!ObjStoreBulkUpdateSql.canUpdateProperty(p) || !ObjStoreBulkUpdateSql.contains(updateProperties, p.getName())) continue;
            GRdbPropertyStoreRuntime colDef = (GRdbPropertyStoreRuntime)((Object)p.getStoreSpecProperty());
            if (!colDef.isMulti()) {
                MetaGRdbPropertyStore.GRdbPropertyStoreHandler scol = (MetaGRdbPropertyStore.GRdbPropertyStoreHandler)colDef;
                if (scol.getMetaData().getPageNo() != pageNo && (scol.getIndexColName() == null || scol.getMetaData().getIndexPageNo() != pageNo)) continue;
                values.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)p, pageNo));
                ret = true;
                continue;
            }
            MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler mcol = (MetaGRdbMultiplePropertyStore.GRdbMultiplePropertyStoreHandler)colDef;
            boolean isAdd = false;
            for (MetaGRdbPropertyStore metaCol : mcol.getMetaData().getStore()) {
                if (metaCol.getPageNo() != pageNo) continue;
                isAdd = true;
                break;
            }
            if (!isAdd) continue;
            values.add(new PropertyColumnValueMapper(tenantId, eh, (PrimitivePropertyHandler)p, pageNo));
            ret = true;
        }
        return ret;
    }

    private static boolean contains(List<String> updateProperties, String name) {
        if (updateProperties == null) {
            return true;
        }
        return updateProperties.contains(name);
    }

    private static void keys(List<ColumnValueMapper> keys, int tenantId, EntityHandler eh, int pageNo, RdbAdapter rdb) {
        keys.add(new FixedExpressionColumnValueMapper("TENANT_ID", Integer.toString(tenantId)));
        keys.add(new FixedExpressionColumnValueMapper("OBJ_DEF_ID", rdb.toSqlExp(eh.getMetaData().getId())));
        keys.add(new DirectColumnValueMapper("OBJ_ID", "oid", null));
        keys.add(new DirectColumnValueMapper("OBJ_VER", "version", 0L));
        keys.add(new FixedExpressionColumnValueMapper("PG_NO", Integer.toString(pageNo)));
    }

    public static ObjStoreBulkUpdateSqlResult updateMain(int tenantId, EntityHandler eh, List<String> updateProperties, RdbAdapter rdb, EntityContext context) {
        ObjStoreBulkUpdateSqlResult res = new ObjStoreBulkUpdateSqlResult();
        res.keys = new ArrayList<ColumnValueMapper>(5);
        ObjStoreBulkUpdateSql.keys(res.keys, tenantId, eh, 0, rdb);
        res.values = new ArrayList<ColumnValueMapper>();
        ObjStoreBulkUpdateSql.handlePropAndVal(res.values, tenantId, eh, 0, updateProperties, rdb, context);
        res.values.add(new FixedExpressionColumnValueMapper("UP_DATE", rdb.systimestamp()));
        res.additionalConditionExpression = "OBJ_DEF_VER<=" + ((MetaGRdbEntityStore)eh.getEntityStoreRuntime().getMetaData()).getVersion();
        return res;
    }

    public static ObjStoreBulkUpdateSqlResult updateSub(int tenantId, EntityHandler eh, int pageNo, List<String> updateProperties, RdbAdapter rdb, EntityContext context) {
        ObjStoreBulkUpdateSqlResult res = new ObjStoreBulkUpdateSqlResult();
        res.keys = new ArrayList<ColumnValueMapper>(5);
        ObjStoreBulkUpdateSql.keys(res.keys, tenantId, eh, pageNo, rdb);
        res.values = new ArrayList<ColumnValueMapper>();
        boolean isAdd = ObjStoreBulkUpdateSql.handlePropAndVal(res.values, tenantId, eh, pageNo, updateProperties, rdb, context);
        if (isAdd) {
            return res;
        }
        return null;
    }

    public static class ObjStoreBulkUpdateSqlResult {
        public List<ColumnValueMapper> keys;
        public List<ColumnValueMapper> values;
        public String additionalConditionExpression;
    }
}

