/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.List;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.hint.FetchSizeHint;
import org.iplass.mtp.entity.query.hint.Hint;
import org.iplass.mtp.entity.query.hint.TimeoutHint;

public class QueryOption {
    private int fetchSize = 0;
    private int queryTimeout = 0;

    public QueryOption() {
    }

    public QueryOption(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public static QueryOption getQueryOption(Query query) {
        List<Hint> list;
        QueryOption qo = null;
        if (query.getSelect().getHintComment() != null && (list = query.getSelect().getHintComment().getHintList()) != null) {
            for (Hint h : list) {
                if (h instanceof FetchSizeHint) {
                    if (qo == null) {
                        qo = new QueryOption();
                    }
                    qo.setFetchSize(((FetchSizeHint)h).getSize());
                    continue;
                }
                if (!(h instanceof TimeoutHint)) continue;
                if (qo == null) {
                    qo = new QueryOption();
                }
                qo.setQueryTimeout(((TimeoutHint)h).getSeconds());
            }
        }
        return qo;
    }
}

