/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.csv;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TimeZone;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import org.apache.commons.text.StringEscapeUtils;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.query.Limit;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.entity.csv.EntityCsvException;
import org.iplass.mtp.impl.entity.csv.QueryWriteOption;
import org.iplass.mtp.util.DateUtil;
import org.iplass.mtp.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryCsvWriter
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(QueryCsvWriter.class);
    private static final String DOUBLE_QUOT = "\"";
    private static final int BOM = 65279;
    private static final String CR = "\n";
    private final Query query;
    private final QueryWriteOption option;
    private final EntityManager em;
    private Writer writer;
    private boolean isInit;
    private String dateFormat;
    private String dateTimeFormat;
    private String timeFormat;
    private ObjectMapper mapper;

    public QueryCsvWriter(OutputStream out, Query query) throws IOException {
        this(out, query, new QueryWriteOption());
    }

    public QueryCsvWriter(OutputStream out, Query query, QueryWriteOption option) throws IOException {
        this.query = query;
        this.option = option;
        this.em = ManagerLocator.manager(EntityManager.class);
        this.writer = new BufferedWriter(new OutputStreamWriter(out, option.getCharset()));
    }

    public int write() throws IOException {
        this.writeHeader();
        return this.search();
    }

    public void writeError(String message) throws IOException {
        this.init();
        if (this.writer != null) {
            this.writer.flush();
            this.writer.write(message);
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            try {
                this.writer.close();
            }
            catch (IOException e) {
                logger.warn("fail to close QueryCsvWriter resource. check whether resource is leak or not.", (Throwable)e);
            }
            this.writer = null;
        }
    }

    private void writeHeader() {
        this.init();
        List<ValueExpression> cols = this.query.getSelect().getSelectValues();
        IntStream.range(0, cols.size()).forEach(i -> {
            ValueExpression col = (ValueExpression)cols.get(i);
            this.writeText(col.toString());
            if (i < cols.size() - 1) {
                this.writeComma();
            }
        });
        this.newLine();
    }

    private void writeValues(Object[] values) {
        this.init();
        IntStream.range(0, values.length).forEach(i -> {
            Object value = values[i];
            if (value != null && value.getClass().isArray()) {
                Object[] array = (Object[])value;
                ArrayList<String> valueList = new ArrayList<String>();
                for (int j = 0; j < array.length; ++j) {
                    if (array[j] != null) {
                        if (this.option.isQuoteAll()) {
                            valueList.add(DOUBLE_QUOT + this.stringValue(array[j]) + DOUBLE_QUOT);
                            continue;
                        }
                        valueList.add(this.stringValue(array[j]));
                        continue;
                    }
                    valueList.add("");
                }
                this.writeText(this.toJsonString(valueList));
            } else {
                this.writeText(this.stringValue(value));
            }
            if (i < values.length - 1) {
                this.writeComma();
            }
        });
        this.newLine();
    }

    private void init() {
        if (this.isInit) {
            return;
        }
        if ("UTF-8".equalsIgnoreCase(this.option.getCharset())) {
            try {
                this.writer.write(65279);
            }
            catch (IOException e) {
                throw new EntityCsvException(e);
            }
        }
        this.isInit = true;
    }

    private int search() {
        final Query optQuery = this.option.getBeforeSearch().apply(this.query);
        if (this.option.getLimit() > 0) {
            optQuery.setLimit(new Limit(this.option.getLimit()));
        }
        final int[] count = new int[1];
        this.em.search(optQuery, new Predicate<Object[]>(){

            @Override
            public boolean test(Object[] values) {
                QueryCsvWriter.this.option.getAfterSearch().accept(optQuery.copy(), values);
                QueryCsvWriter.this.writeValues(values);
                count[0] = count[0] + 1;
                return true;
            }
        });
        return count[0];
    }

    private String stringValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)value;
            return bd.toPlainString();
        }
        if (value instanceof Double) {
            BigDecimal bd = BigDecimal.valueOf((Double)value);
            return bd.toPlainString();
        }
        if (value instanceof Float) {
            BigDecimal bd = BigDecimal.valueOf(((Float)value).floatValue());
            return bd.toPlainString();
        }
        if (value instanceof Boolean) {
            Boolean b = (Boolean)value;
            return b != false ? "1" : "0";
        }
        if (value instanceof SelectValue) {
            SelectValue sv = (SelectValue)value;
            return sv.getValue();
        }
        if (value instanceof BinaryReference) {
            BinaryReference br = (BinaryReference)value;
            LinkedHashMap<String, String> valueMap = new LinkedHashMap<String, String>();
            valueMap.put("lobid", String.valueOf(br.getLobId()));
            valueMap.put("name", br.getName());
            valueMap.put("type", br.getType());
            return this.toJsonString(valueMap);
        }
        if (value instanceof Date) {
            return DateUtil.getSimpleDateFormat(this.getDateFormat(), false).format((Date)value);
        }
        if (value instanceof Timestamp) {
            return DateUtil.getSimpleDateFormat(this.getDateTimeFormat(), false).format((Timestamp)value);
        }
        if (value instanceof Time) {
            return DateUtil.getSimpleDateFormat(this.getTimeFormat(), false).format((Time)value);
        }
        return value.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String toJsonString(Object value) {
        if (this.mapper == null) {
            this.mapper = new ObjectMapper();
            this.mapper.configOverride(Date.class).setFormat(JsonFormat.Value.forPattern((String)"yyyy-MM-dd").withTimeZone(TimeZone.getDefault()));
        }
        try (StringWriter writer = new StringWriter();){
            this.mapper.writeValue((Writer)writer, value);
            String string = writer.toString();
            return string;
        }
        catch (JsonProcessingException e) {
            throw new EntityCsvException(e);
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
    }

    private void newLine() {
        try {
            this.writer.write(CR);
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
    }

    private void writeComma() {
        try {
            this.writer.write(",");
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
    }

    private void writeText(String text) {
        try {
            if (StringUtil.isEmpty(text)) {
                return;
            }
            String outText = StringEscapeUtils.escapeCsv((String)text);
            if (this.option.isQuoteAll()) {
                if (outText.startsWith(DOUBLE_QUOT) && outText.endsWith(DOUBLE_QUOT)) {
                    this.writer.write(outText);
                } else {
                    this.writer.write(DOUBLE_QUOT);
                    this.writer.write(outText);
                    this.writer.write(DOUBLE_QUOT);
                }
            } else {
                this.writer.write(outText);
            }
        }
        catch (IOException e) {
            throw new EntityCsvException(e);
        }
    }

    private String getDateFormat() {
        if (this.dateFormat != null) {
            return this.dateFormat;
        }
        this.dateFormat = this.option.getDateFormat() != null ? this.option.getDateFormat() : ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDateFormat();
        return this.dateFormat;
    }

    private String getDateTimeFormat() {
        if (this.dateTimeFormat != null) {
            return this.dateTimeFormat;
        }
        this.dateTimeFormat = this.option.getDatetimeSecFormat() != null ? this.option.getDatetimeSecFormat() : ExecuteContext.getCurrentContext().getLocaleFormat().getOutputDatetimeSecFormat();
        return this.dateTimeFormat;
    }

    private String getTimeFormat() {
        if (this.timeFormat != null) {
            return this.timeFormat;
        }
        this.timeFormat = this.option.getTimeSecFormat() != null ? this.option.getTimeSecFormat() : ExecuteContext.getCurrentContext().getLocaleFormat().getOutputTimeSecFormat();
        return this.timeFormat;
    }
}

