/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.lob.sql;

import java.util.List;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class LobStoreUpdateSql
extends UpdateSqlHandler {
    public String toPrepareSqlForLobUpdate(boolean manageLobSizeOnRdb, RdbAdapter rdbAdaptor) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE LOB_STORE").append(" SET B_DATA=?");
        if (manageLobSizeOnRdb) {
            sql.append(" ,LOB_SIZE=?");
        }
        sql.append(" WHERE TENANT_ID=? ").append(" AND LOB_DATA_ID=?");
        return sql.toString();
    }

    public String toPrepareSqlForLobSizeUpdate(RdbAdapter rdbAdaptor) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE LOB_STORE").append(" SET LOB_SIZE=?").append(" WHERE TENANT_ID=? ").append(" AND LOB_DATA_ID=?");
        return sql.toString();
    }

    public String toPrepareSqlForRefCountUpdate(RdbAdapter rdbAdaptor) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE LOB_STORE SET REF_COUNT=REF_COUNT+?");
        sql.append(" WHERE TENANT_ID=? AND ");
        sql.append("LOB_DATA_ID=?");
        return sql.toString();
    }

    public String toSqlForRefCountUpdateByList(RdbAdapter rdbAdaptor, int tenantId, List<String> lobDataIdList, int count) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE LOB_STORE SET REF_COUNT=REF_COUNT+");
        sql.append(count);
        sql.append(" WHERE TENANT_ID=");
        sql.append(tenantId);
        sql.append(" AND ");
        sql.append("LOB_DATA_ID in ");
        for (int i = 0; i < lobDataIdList.size(); ++i) {
            if (i != 0) {
                sql.append(",");
            }
            sql.append(lobDataIdList.get(i));
        }
        sql.append(")");
        return sql.toString();
    }
}

