/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.mail.smime;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.iplass.mtp.impl.mail.smime.CertificateKeyPair;
import org.iplass.mtp.impl.mail.smime.SmimeCertStore;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSmimeCertStore
implements SmimeCertStore {
    private static Logger logger = LoggerFactory.getLogger(SimpleSmimeCertStore.class);
    private String keyStoreType = "PKCS12";
    private String keyStoreProvider;
    private String keyStoreFilePath;
    private String keyStorePassword;
    private Map<String, String> keyPasswordMap;
    private Integer keyStoreReloadIntervalMinutes;
    private volatile CertStore certStore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CertStore getStore() {
        if (this.certStore == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        if (this.certStore.expires < now) {
            SimpleSmimeCertStore simpleSmimeCertStore = this;
            synchronized (simpleSmimeCertStore) {
                if (this.certStore.expires < now) {
                    try {
                        this.certStore = new CertStore();
                    }
                    catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                        logger.error("Can't load KeyStore", (Throwable)e);
                    }
                }
            }
        }
        return this.certStore;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreProvider() {
        return this.keyStoreProvider;
    }

    public void setKeyStoreProvider(String keyStoreProvider) {
        this.keyStoreProvider = keyStoreProvider;
    }

    public String getKeyStoreFilePath() {
        return this.keyStoreFilePath;
    }

    public void setKeyStoreFilePath(String keyStoreFilePath) {
        this.keyStoreFilePath = keyStoreFilePath;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public Map<String, String> getKeyPasswordMap() {
        return this.keyPasswordMap;
    }

    public void setKeyPasswordMap(Map<String, String> keyPasswordMap) {
        this.keyPasswordMap = keyPasswordMap;
    }

    public Integer getKeyStoreReloadIntervalMinutes() {
        return this.keyStoreReloadIntervalMinutes;
    }

    public void setKeyStoreReloadIntervalMinutes(Integer keyStoreReloadIntervalMinutes) {
        this.keyStoreReloadIntervalMinutes = keyStoreReloadIntervalMinutes;
    }

    @Override
    public X509Certificate getCertificate(String mailAddress) {
        CertStore cs = this.getStore();
        if (cs != null) {
            try {
                X509Certificate c = (X509Certificate)cs.store.getCertificate(mailAddress);
                c.checkValidity();
                return c;
            }
            catch (CertificateExpiredException e) {
                logger.warn("Certificate:" + mailAddress + " is expired.");
            }
            catch (CertificateNotYetValidException e) {
                logger.warn("Certificate:" + mailAddress + " is not yet valid.");
            }
            catch (KeyStoreException e) {
                logger.error("Can't get Certificate:" + mailAddress + " cause:" + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public CertificateKeyPair getCertificateKeyPair(String mailAddress, String keyPass) {
        CertStore cs = this.getStore();
        if (cs != null) {
            if (keyPass == null) {
                if (this.keyPasswordMap != null) {
                    keyPass = this.keyPasswordMap.get(mailAddress);
                }
                if (keyPass == null) {
                    keyPass = this.keyStorePassword;
                }
            }
            try {
                X509Certificate c = (X509Certificate)cs.store.getCertificate(mailAddress);
                c.checkValidity();
                try {
                    Key k = cs.store.getKey(mailAddress, keyPass.toCharArray());
                    if (k instanceof PrivateKey) {
                        return new CertificateKeyPair(c, (PrivateKey)k);
                    }
                }
                catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
                    logger.error("PrivateKey:" + mailAddress + " can't recover by password.", (Throwable)e);
                }
            }
            catch (CertificateExpiredException e) {
                logger.warn("Certificate:" + mailAddress + " is expired.");
            }
            catch (CertificateNotYetValidException e) {
                logger.warn("Certificate:" + mailAddress + " is not yet valid.");
            }
            catch (KeyStoreException e) {
                logger.error("Can't get Certificate:" + mailAddress + " cause:" + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void inited() {
        if (this.keyStoreType != null) {
            try {
                this.certStore = new CertStore();
            }
            catch (IOException | KeyStoreException | NoSuchAlgorithmException | NoSuchProviderException | CertificateException e) {
                throw new ServiceConfigrationException("Cant load KeyStore", e);
            }
        }
    }

    @Override
    public void destroyed() {
        this.certStore = null;
    }

    private class CertStore {
        private final long expires;
        private final KeyStore store;

        private CertStore() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, NoSuchProviderException {
            KeyStore ks = SimpleSmimeCertStore.this.keyStoreProvider == null ? KeyStore.getInstance(SimpleSmimeCertStore.this.keyStoreType) : KeyStore.getInstance(SimpleSmimeCertStore.this.keyStoreType, SimpleSmimeCertStore.this.keyStoreProvider);
            if (SimpleSmimeCertStore.this.keyStoreFilePath != null) {
                try (FileInputStream is = new FileInputStream(SimpleSmimeCertStore.this.keyStoreFilePath);
                     BufferedInputStream bis = new BufferedInputStream(is);){
                    if (SimpleSmimeCertStore.this.keyStorePassword != null) {
                        ks.load(bis, SimpleSmimeCertStore.this.keyStorePassword.toCharArray());
                    }
                    ks.load(bis, null);
                }
            } else if (SimpleSmimeCertStore.this.keyStorePassword != null) {
                ks.load(null, SimpleSmimeCertStore.this.keyStorePassword.toCharArray());
            } else {
                ks.load(null, null);
            }
            this.store = ks;
            this.expires = SimpleSmimeCertStore.this.keyStoreReloadIntervalMinutes != null && SimpleSmimeCertStore.this.keyStoreReloadIntervalMinutes > 0 ? System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(SimpleSmimeCertStore.this.keyStoreReloadIntervalMinutes.intValue()) : Long.MAX_VALUE;
        }
    }
}

