/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.message;

import java.util.List;
import org.iplass.mtp.definition.DefinitionModifyResult;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.AbstractTypedDefinitionManager;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.message.MessageService;
import org.iplass.mtp.impl.message.MetaMessageCategory;
import org.iplass.mtp.impl.message.MetaMessageItem;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.message.MessageCategory;
import org.iplass.mtp.message.MessageItem;
import org.iplass.mtp.message.MessageManager;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageManagerImpl
extends AbstractTypedDefinitionManager<MessageCategory>
implements MessageManager {
    private static final Logger logger = LoggerFactory.getLogger(MessageManagerImpl.class);
    private MessageService service = ServiceRegistry.getRegistry().getService(MessageService.class);

    @Override
    @Deprecated
    public DefinitionModifyResult createMessage(MessageCategory messageCategory) {
        return this.create(messageCategory);
    }

    @Override
    @Deprecated
    public DefinitionModifyResult updateMessage(MessageCategory messageCategory) {
        return this.update(messageCategory);
    }

    @Override
    @Deprecated
    public DefinitionModifyResult deleteMessage(String name) {
        return this.remove(name);
    }

    @Override
    public DefinitionModifyResult createMessageItem(String category, MessageItem messageItem) {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.service.getRuntimeByName(category);
        MetaMessageItem metaMessageItem = new MetaMessageItem();
        metaMessageItem.setValue(messageItem);
        if (handler == null) {
            MetaMessageCategory metaCategoryMessage = new MetaMessageCategory();
            metaCategoryMessage.setName(category);
            metaCategoryMessage.addMessage(metaMessageItem);
            try {
                this.service.createMetaData(metaCategoryMessage);
            }
            catch (Exception e) {
                this.setRollbackOnly();
                if (e.getCause() != null) {
                    logger.error("exception occured during message category definition create:" + e.getCause().getMessage(), e.getCause());
                    return new DefinitionModifyResult(false, "exception occured during message category definition create:" + e.getCause().getMessage());
                }
                logger.error("exception occured during message category definition create:" + e.getMessage(), (Throwable)e);
                return new DefinitionModifyResult(false, "exception occured during message category definition create:" + e.getMessage());
            }
        }
        MetaMessageCategory metaCategoryMessage = handler.getMetaData();
        metaCategoryMessage.addMessage(metaMessageItem);
        try {
            this.service.updateMetaData(metaCategoryMessage);
        }
        catch (Exception e) {
            this.setRollbackOnly();
            if (e.getCause() != null) {
                logger.error("exception occured during message category definition update:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during message category definition update:" + e.getCause().getMessage());
            }
            logger.error("exception occured during message category definition update:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during message category definition update:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    @Override
    public DefinitionModifyResult updateMessageItem(String category, MessageItem messageItem) {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.service.getRuntimeByName(category);
        if (handler == null) {
            logger.error("exception occured during message category definition update:\u6307\u5b9a\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u30ab\u30c6\u30b4\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u30ab\u30c6\u30b4\u30ea\u540d=" + category);
            return new DefinitionModifyResult(false, "exception occured during message category definition update:\u6307\u5b9a\u306e\u30e1\u30c3\u30bb\u30fc\u30b8\u30ab\u30c6\u30b4\u30ea\u306f\u5b58\u5728\u3057\u307e\u305b\u3093\u3002\u30e1\u30c3\u30bb\u30fc\u30b8\u30ab\u30c6\u30b4\u30ea\u540d=" + category);
        }
        MetaMessageItem metaMessageItem = new MetaMessageItem();
        metaMessageItem.setValue(messageItem);
        MetaMessageCategory metaCategoryMessage = handler.getMetaData();
        metaCategoryMessage.addMessage(metaMessageItem);
        try {
            this.service.updateMetaData(metaCategoryMessage);
        }
        catch (Exception e) {
            this.setRollbackOnly();
            if (e.getCause() != null) {
                logger.error("exception occured during message category definition update:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during message category definition update:" + e.getCause().getMessage());
            }
            logger.error("exception occured during message category definition update:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during message category definition update:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    @Override
    public DefinitionModifyResult deleteMessageItem(String category, String messageId) {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.service.getRuntimeByName(category);
        if (handler == null) {
            return new DefinitionModifyResult(true);
        }
        MetaMessageCategory metaCategoryMessage = handler.getMetaData();
        metaCategoryMessage.getMessages().remove(messageId);
        try {
            this.service.updateMetaData(metaCategoryMessage);
        }
        catch (Exception e) {
            this.setRollbackOnly();
            if (e.getCause() != null) {
                logger.error("exception occured during message category definition update:" + e.getCause().getMessage(), e.getCause());
                return new DefinitionModifyResult(false, "exception occured during message category definition update:" + e.getCause().getMessage());
            }
            logger.error("exception occured during message category definition update:" + e.getMessage(), (Throwable)e);
            return new DefinitionModifyResult(false, "exception occured during message category definition update:" + e.getMessage());
        }
        return new DefinitionModifyResult(true);
    }

    @Override
    @Deprecated
    public MessageCategory getMessageCategoryByName(String name) {
        return (MessageCategory)this.get(name);
    }

    @Override
    public List<String> getMessageIdList(String category) {
        int tenantId = ExecuteContext.getCurrentContext().getClientTenantId();
        return this.service.getMessageIdList(tenantId, category);
    }

    @Override
    public MessageItem getMessageItem(String category, String messageId) {
        MetaMessageCategory.MetaMessageCategoryHandler handler = (MetaMessageCategory.MetaMessageCategoryHandler)this.service.getRuntimeByName(category);
        if (handler == null) {
            return null;
        }
        MessageItem ret = handler.createMessageItem(messageId);
        return ret;
    }

    @Override
    public Class<MessageCategory> getDefinitionType() {
        return MessageCategory.class;
    }

    @Override
    protected RootMetaData newInstance(MessageCategory definition) {
        return new MetaMessageCategory();
    }

    @Override
    protected TypedMetaDataService getService() {
        return this.service;
    }
}

