/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.binary;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.iplass.mtp.definition.binary.BinaryDefinition;
import org.iplass.mtp.impl.metadata.MetaDataIllegalStateException;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaData;
import org.iplass.mtp.impl.metadata.binary.BinaryMetaDataService;
import org.iplass.mtp.impl.metadata.binary.RefBinaryDefinition;
import org.iplass.mtp.spi.ServiceRegistry;

public class SimpleBinaryMetaData
implements BinaryMetaData,
Externalizable {
    private String name;
    private long size;
    private byte[] inMemory;
    private Path tempPath;
    private volatile SoftReference<byte[]> cache;
    protected BinaryMetaDataService service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);

    public SimpleBinaryMetaData() {
    }

    public SimpleBinaryMetaData(String name) {
        this.name = name;
    }

    public SimpleBinaryMetaData(String name, Path source) {
        this.name = name;
        try (OutputStream os = this.getOutputStream();){
            Files.copy(source, os);
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't copy BinaryMetaData's source/tempFile:" + source + "/" + this.tempPath, e);
        }
    }

    public SimpleBinaryMetaData(BinaryDefinition def) {
        this.name = def.getName();
        try (OutputStream os = this.getOutputStream();
             InputStream is = def.getInputStream();){
            IOUtils.copyLarge((InputStream)is, (OutputStream)os);
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't copy BinaryMetaData's definition/tempFile:" + def.getName() + "/" + this.tempPath, e);
        }
    }

    @Override
    public BinaryDefinition currentConfig() {
        return new RefBinaryDefinition(this);
    }

    public Path getTempPath() {
        return this.tempPath;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public InputStream getInputStream() {
        byte[] bd;
        if (this.inMemory != null) {
            return new ByteArrayInputStream(this.inMemory);
        }
        SoftReference<byte[]> refCache = this.cache;
        if (refCache != null && (bd = refCache.get()) != null) {
            return new ByteArrayInputStream(bd);
        }
        if (this.tempPath == null) {
            return null;
        }
        try {
            if (this.size > (long)this.service.getCacheMemoryThreshold()) {
                return Files.newInputStream(this.tempPath, new OpenOption[0]);
            }
            bd = new byte[(int)this.size];
            try (InputStream is = Files.newInputStream(this.tempPath, new OpenOption[0]);){
                int len = IOUtils.read((InputStream)is, (byte[])bd);
                if (this.size != (long)len) {
                    throw new IOException("unmatch size:" + this.size + " != Files.length:" + len);
                }
            }
            this.cache = new SoftReference<byte[]>(bd);
            return new ByteArrayInputStream(bd);
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't open/read BinaryMetaData's tempFile:" + this.tempPath, e);
        }
    }

    @Override
    public OutputStream getOutputStream() {
        try {
            return new SimpleBinaryMetaDataOutputStream();
        }
        catch (IOException e) {
            throw new MetaDataIllegalStateException("can't open/write BinaryMetaData's tempFile:" + this.tempPath, e);
        }
    }

    private Path initTempFile() throws IOException {
        if (this.tempPath != null) {
            Files.deleteIfExists(this.tempPath);
        }
        Path tempDir = this.service.getTempFileDir();
        this.tempPath = Files.createTempFile(tempDir, "sbmd_", ".tmp", new FileAttribute[0]);
        return this.tempPath;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        try (InputStream is = this.getInputStream();){
            if (is != null) {
                IOUtils.copy((InputStream)is, (OutputStream)out);
            }
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeLong(this.size);
        if (this.inMemory != null) {
            out.write(this.inMemory);
            if (this.size != (long)this.inMemory.length) {
                throw new IOException("unmatch size:" + this.size + " != inMemory.length:" + this.inMemory.length);
            }
        } else {
            try (InputStream is = this.getInputStream();){
                byte[] buff = new byte[8192];
                long count = 0L;
                int n = 0;
                while (-1 != (n = is.read(buff))) {
                    out.write(buff, 0, n);
                    count += (long)n;
                }
                if (this.size != count) {
                    throw new IOException("unmatch size:" + this.size + " != InputStream length:" + count);
                }
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.service = ServiceRegistry.getRegistry().getService(BinaryMetaDataService.class);
        this.name = in.readUTF();
        this.size = in.readLong();
        if ((long)this.service.getKeepInMemoryThreshold() < this.size) {
            try (OutputStream os = Files.newOutputStream(this.initTempFile(), new OpenOption[0]);){
                int ren;
                byte[] buff = new byte[8192];
                for (long remain = this.size; remain > 0L; remain -= (long)ren) {
                    ren = remain >= (long)buff.length ? in.read(buff) : in.read(buff, 0, (int)remain);
                    if (ren < 0) {
                        throw new EOFException("cant read data correctly");
                    }
                    os.write(buff, 0, ren);
                }
            }
        } else {
            int ren;
            byte[] dat = new byte[(int)this.size];
            for (long loaded = 0L; loaded < this.size; loaded += (long)ren) {
                ren = in.read(dat, (int)loaded, (int)(this.size - loaded));
                if (ren >= 0) continue;
                throw new EOFException("cant read data correctly");
            }
            this.inMemory = dat;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.tempPath != null) {
            Files.deleteIfExists(this.tempPath);
        }
    }

    static /* synthetic */ byte[] access$302(SimpleBinaryMetaData x0, byte[] x1) {
        x0.inMemory = x1;
        return x1;
    }

    private class SimpleBinaryMetaDataOutputStream
    extends FilterOutputStream {
        private boolean isInMemory;
        private boolean flushed;

        private SimpleBinaryMetaDataOutputStream() throws IOException {
            super(SimpleBinaryMetaData.this.service.getKeepInMemoryThreshold() > 0 ? new ByteArrayOutputStream(SimpleBinaryMetaData.this.service.getKeepInMemoryThreshold()) : Files.newOutputStream(SimpleBinaryMetaData.this.initTempFile(), new OpenOption[0]));
            this.isInMemory = SimpleBinaryMetaData.this.service.getKeepInMemoryThreshold() > 0;
        }

        @Override
        public void write(int b) throws IOException {
            this.flushed = false;
            SimpleBinaryMetaData.this.size++;
            this.checkSize();
            this.out.write(b);
        }

        private void checkSize() throws IOException {
            this.flushed = false;
            if (this.isInMemory && SimpleBinaryMetaData.this.size > (long)SimpleBinaryMetaData.this.service.getKeepInMemoryThreshold()) {
                ByteArrayOutputStream current = (ByteArrayOutputStream)this.out;
                this.out = Files.newOutputStream(SimpleBinaryMetaData.this.initTempFile(), new OpenOption[0]);
                current.writeTo(this.out);
                SimpleBinaryMetaData.access$302(SimpleBinaryMetaData.this, null);
                this.isInMemory = false;
            }
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if ((off | len | b.length - (len + off) | off + len) < 0) {
                throw new IndexOutOfBoundsException();
            }
            this.flushed = false;
            SimpleBinaryMetaData.this.size = SimpleBinaryMetaData.this.size + (long)len;
            this.checkSize();
            this.out.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            if (this.isInMemory && !this.flushed) {
                SimpleBinaryMetaData.access$302(SimpleBinaryMetaData.this, ((ByteArrayOutputStream)this.out).toByteArray());
                this.flushed = true;
            }
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            if (this.isInMemory && !this.flushed) {
                SimpleBinaryMetaData.access$302(SimpleBinaryMetaData.this, ((ByteArrayOutputStream)this.out).toByteArray());
                this.flushed = true;
            }
            super.close();
        }
    }
}

