/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.composite;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.metadata.MetaDataEntry;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRepository;
import org.iplass.mtp.impl.metadata.MetaDataRuntimeException;
import org.iplass.mtp.impl.metadata.MetaDataStore;
import org.iplass.mtp.impl.metadata.composite.MetaDataStorePathMapping;
import org.iplass.mtp.impl.metadata.rdb.RdbMetaDataStore;
import org.iplass.mtp.spi.Config;
import org.iplass.mtp.spi.ServiceConfigrationException;

public class CompositeMetaDataStore
implements MetaDataStore {
    private MetaDataStorePathMapping[] pathMapping;
    private Map<String, MetaDataStore> container = new HashMap<String, MetaDataStore>();
    private MetaDataStore[] store;
    private MetaDataStore defaultStore;
    private String defaultStoreClass;

    @Override
    public void destroyed() {
    }

    @Override
    public void inited(MetaDataRepository service, Config config) {
        if (this.store == null) {
            throw new ServiceConfigrationException("CompositeMetaDataStore must be set 'store' property.");
        }
        for (MetaDataStore sil : this.store) {
            sil.inited(service, config);
        }
        if (this.defaultStoreClass == null) {
            throw new ServiceConfigrationException("CompositeMetaDataStore must be set 'defaultStoreClassName' property.");
        }
        for (MetaDataStore ds : this.store) {
            if (!ds.getClass().getName().equals(this.defaultStoreClass)) continue;
            this.defaultStore = ds;
            break;
        }
        if (this.pathMapping != null) {
            for (MetaDataStorePathMapping m : this.pathMapping) {
                String pathPrefix = m.getPathPrefix();
                String className = m.getStore();
                MetaDataStore mdstore = null;
                for (MetaDataStore ds : this.store) {
                    if (!ds.getClass().getName().equals(className)) continue;
                    mdstore = ds;
                    break;
                }
                this.container.put(pathPrefix, mdstore);
            }
        }
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id) {
        return this.loadById(tenantId, id, -1);
    }

    @Override
    public MetaDataEntry loadById(int tenantId, String id, int version) {
        MetaDataEntry ent = this.defaultStore.loadById(tenantId, id, version);
        if (ent == null) {
            for (Map.Entry<String, MetaDataStore> e : this.container.entrySet()) {
                MetaDataStore ds = e.getValue();
                String pathOfStore = e.getKey();
                if (ds.getClass().isInstance(this.defaultStore) || (ent = ds.loadById(tenantId, id, version)) == null || !ent.getPath().startsWith(pathOfStore)) continue;
                break;
            }
        } else {
            String path = ent.getPath();
            MetaDataStore pathMappedStore = this.resolveStore(path);
            if (!pathMappedStore.getClass().isInstance(this.defaultStore)) {
                ent = pathMappedStore.loadById(tenantId, id, version);
            }
        }
        return ent;
    }

    @Override
    public List<MetaDataEntryInfo> definitionList(int tenantId, String prefixPath) throws MetaDataRuntimeException {
        MetaDataStore ds;
        if ("/".equals(prefixPath)) {
            ArrayList<MetaDataEntryInfo> ret = new ArrayList<MetaDataEntryInfo>();
            for (Map.Entry<String, MetaDataStore> e : this.container.entrySet()) {
                String path = e.getKey();
                MetaDataStore ds2 = e.getValue();
                ret.addAll(ds2.definitionList(tenantId, path));
            }
            List<MetaDataEntryInfo> defaultList = this.defaultStore.definitionList(tenantId, prefixPath);
            Iterator<MetaDataEntryInfo> ite = defaultList.iterator();
            while (ite.hasNext()) {
                MetaDataEntryInfo e = ite.next();
                for (String pathPrefix : this.container.keySet()) {
                    if (!e.getPath().startsWith(pathPrefix)) continue;
                    ite.remove();
                }
            }
            ret.addAll(defaultList);
            return ret;
        }
        String key = prefixPath;
        if (key.startsWith("/")) {
            key = key.substring(1);
        }
        if ((ds = this.container.get(key = "/" + key.split("/")[0] + "/")) != null) {
            return ds.definitionList(tenantId, prefixPath);
        }
        return this.defaultStore.definitionList(tenantId, prefixPath);
    }

    @Override
    public MetaDataEntry load(int tenantId, String path) throws MetaDataRuntimeException {
        int version = -1;
        return this.load(tenantId, path, -1);
    }

    @Override
    public MetaDataEntry load(int tenantId, String path, int version) throws MetaDataRuntimeException {
        MetaDataStore ds = this.resolveStore(path);
        return ds.load(tenantId, path, version);
    }

    @Override
    public void store(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        MetaDataStore ds = this.resolveStore(metaDataEntry.getPath());
        ds.store(tenantId, metaDataEntry);
    }

    @Override
    public void update(int tenantId, MetaDataEntry metaDataEntry) throws MetaDataRuntimeException {
        MetaDataStore ds = this.resolveStore(metaDataEntry.getPath());
        ds.update(tenantId, metaDataEntry);
    }

    @Override
    public void remove(int tenantId, String path) throws MetaDataRuntimeException {
        MetaDataStore ds = this.resolveStore(path);
        ds.remove(tenantId, path);
    }

    @Override
    public void updateConfigById(int tenantId, String id, MetaDataConfig config) {
        MetaDataStore ds = this.resolveStoreById(tenantId, id);
        ds.updateConfigById(tenantId, id, config);
    }

    @Override
    public List<MetaDataEntryInfo> getHistoryById(int tenantId, String id) {
        MetaDataStore ds = this.resolveStoreById(tenantId, id);
        return ds.getHistoryById(tenantId, id);
    }

    public boolean hasOverwriteMetaData(int sharedTenantId, MetaDataEntry entry) {
        RdbMetaDataStore rdb = this.getRdbStore();
        if (rdb != null) {
            return rdb.hasOverwriteMetaData(sharedTenantId, entry.getMetaData().getId());
        }
        return false;
    }

    public List<Integer> getOverwriteTenantIdList(int sharedTenantId, String metaDataId) {
        RdbMetaDataStore rdb = this.getRdbStore();
        if (rdb != null) {
            return rdb.getOverwriteTenantIdList(sharedTenantId, metaDataId);
        }
        return new ArrayList<Integer>();
    }

    public List<MetaDataEntryInfo> getInvalidEntryList(int tenantId) {
        RdbMetaDataStore rdb = this.getRdbStore();
        if (rdb != null) {
            return rdb.getInvalidEntryList(tenantId);
        }
        return Collections.emptyList();
    }

    public void purgeById(int tenantId, String id) throws MetaDataRuntimeException {
        RdbMetaDataStore rdb = this.getRdbStore();
        if (rdb != null) {
            rdb.purgeById(tenantId, id);
        }
    }

    public MetaDataStore resolveStore(String path) {
        if (!"/".equals(path) && path != null) {
            for (Map.Entry<String, MetaDataStore> e : this.container.entrySet()) {
                String pathOfStore = e.getKey();
                if (!path.startsWith(pathOfStore)) continue;
                return e.getValue();
            }
            return this.defaultStore;
        }
        return this.defaultStore;
    }

    public <T extends MetaDataStore> T getStore(Class<T> storeType) {
        MetaDataStore store = null;
        for (Map.Entry<String, MetaDataStore> e : this.container.entrySet()) {
            store = e.getValue();
            if (!storeType.isInstance(store)) continue;
            return (T)((MetaDataStore)storeType.cast(store));
        }
        if (storeType.isInstance(this.defaultStore)) {
            return (T)((MetaDataStore)storeType.cast(this.defaultStore));
        }
        return null;
    }

    private MetaDataStore resolveStoreById(int tenantId, String id) {
        for (Map.Entry<String, MetaDataStore> e : this.container.entrySet()) {
            MetaDataStore ds = e.getValue();
            if (ds.loadById(tenantId, id) == null) continue;
            return ds;
        }
        return this.defaultStore;
    }

    private RdbMetaDataStore getRdbStore() {
        return this.getStore(RdbMetaDataStore.class);
    }

    public MetaDataStore[] getStore() {
        return this.store;
    }

    public void setStore(MetaDataStore[] store) {
        this.store = store;
    }

    public String getDefaultStoreClass() {
        return this.defaultStoreClass;
    }

    public void setDefaultStoreClass(String defaultStoreClass) {
        this.defaultStoreClass = defaultStoreClass;
    }

    public MetaDataStorePathMapping[] getPathMapping() {
        return this.pathMapping;
    }

    public void setPathMapping(MetaDataStorePathMapping[] pathMapping) {
        this.pathMapping = pathMapping;
    }
}

