/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.metadata.rdb;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class UpdateConfigSQL
extends UpdateSqlHandler {
    private static final String UPDATE_CONFIG_SQL = "UPDATE OBJ_META SET SHARABLE=? ,OVERWRITABLE=? ,UP_USER=? ,UP_DATE=systimestamp WHERE TENANT_ID=? AND OBJ_DEF_ID=? AND STATUS= 'V'";

    public String createUpdateSQL(RdbAdapter rdb) {
        return UPDATE_CONFIG_SQL.replaceAll("systimestamp", rdb.systimestamp());
    }

    public void setUpdateParameter(RdbAdapter rdb, PreparedStatement ps, int tenantId, String id, boolean share, boolean dataShare, boolean permissionShare, boolean overwrite) throws SQLException {
        int num = 1;
        String clientId = ExecuteContext.getCurrentContext().getClientId();
        String shareStr = UpdateConfigSQL.toCharShare(share, dataShare, permissionShare);
        String overwriteStr = UpdateConfigSQL.toCharOverwrite(overwrite);
        ps.setString(num++, shareStr);
        ps.setString(num++, overwriteStr);
        ps.setString(num++, clientId);
        ps.setInt(num++, tenantId);
        ps.setString(num++, id);
    }

    static String toCharOverwrite(boolean flag) {
        if (flag) {
            return "1";
        }
        return "0";
    }

    static boolean toBooleanOverwrite(String flagStr) {
        return "1".equals(flagStr);
    }

    static String toCharShare(boolean sharable, boolean dataSharable, boolean permissionSharable) {
        int val = 0;
        if (sharable) {
            ++val;
        }
        if (dataSharable) {
            val += 2;
        }
        if (permissionSharable) {
            val += 4;
        }
        return Integer.toString(val);
    }

    static boolean[] toBooleanShare(String flagStr) {
        if (flagStr == null || flagStr.trim().length() == 0) {
            return new boolean[]{false, false, false};
        }
        int val = Integer.parseInt(flagStr);
        boolean[] ret = new boolean[]{(val & 1) == 1, (val & 2) == 2, (val & 4) == 4};
        return ret;
    }
}

