/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.properties.basic;

import java.math.BigDecimal;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.DecimalProperty;
import org.iplass.mtp.entity.definition.properties.RoundingMode;
import org.iplass.mtp.impl.properties.basic.BasicType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecimalType
extends BasicType {
    private static final long serialVersionUID = -6395734773660560934L;
    private static Logger logger = LoggerFactory.getLogger(DecimalType.class);
    private int scale;
    private java.math.RoundingMode roundingMode;

    public DecimalType() {
    }

    public DecimalType(int scale, java.math.RoundingMode roundingMode) {
        this.scale = scale;
        this.roundingMode = roundingMode;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.roundingMode == null ? 0 : this.roundingMode.hashCode());
        result = 31 * result + this.scale;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DecimalType other = (DecimalType)obj;
        if (this.roundingMode == null ? other.roundingMode != null : !this.roundingMode.equals((Object)other.roundingMode)) {
            return false;
        }
        return this.scale == other.scale;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public java.math.RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    public void setRoundingMode(java.math.RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
    }

    @Override
    public DecimalProperty createPropertyDefinitionInstance() {
        DecimalProperty def = new DecimalProperty();
        def.setScale(this.scale);
        switch (this.roundingMode) {
            case UP: {
                def.setRoundingMode(RoundingMode.UP);
                break;
            }
            case DOWN: {
                def.setRoundingMode(RoundingMode.DOWN);
                break;
            }
            case CEILING: {
                def.setRoundingMode(RoundingMode.CEILING);
                break;
            }
            case FLOOR: {
                def.setRoundingMode(RoundingMode.FLOOR);
                break;
            }
            case HALF_UP: {
                def.setRoundingMode(RoundingMode.HALF_UP);
                break;
            }
            case HALF_DOWN: {
                def.setRoundingMode(RoundingMode.HALF_DOWN);
                break;
            }
            case HALF_EVEN: {
                def.setRoundingMode(RoundingMode.HALF_EVEN);
                break;
            }
        }
        return def;
    }

    @Override
    public void applyDefinition(PropertyDefinition def) {
        super.applyDefinition(def);
        this.scale = ((DecimalProperty)def).getScale();
        switch (((DecimalProperty)def).getRoundingMode()) {
            case UP: {
                this.setRoundingMode(java.math.RoundingMode.UP);
                break;
            }
            case DOWN: {
                this.setRoundingMode(java.math.RoundingMode.DOWN);
                break;
            }
            case CEILING: {
                this.setRoundingMode(java.math.RoundingMode.CEILING);
                break;
            }
            case FLOOR: {
                this.setRoundingMode(java.math.RoundingMode.FLOOR);
                break;
            }
            case HALF_UP: {
                this.setRoundingMode(java.math.RoundingMode.HALF_UP);
                break;
            }
            case HALF_DOWN: {
                this.setRoundingMode(java.math.RoundingMode.HALF_DOWN);
                break;
            }
            case HALF_EVEN: {
                this.setRoundingMode(java.math.RoundingMode.HALF_EVEN);
                break;
            }
        }
    }

    @Override
    public DecimalType copy() {
        return new DecimalType(this.scale, this.roundingMode);
    }

    @Override
    public Class<?> storeType() {
        return BigDecimal.class;
    }

    @Override
    public PropertyDefinitionType getEnumType() {
        return PropertyDefinitionType.DECIMAL;
    }

    @Override
    public Object toDataStore(Object toDataStore) {
        if (toDataStore == null) {
            return toDataStore;
        }
        if (toDataStore instanceof BigDecimal) {
            if (((BigDecimal)toDataStore).scale() != this.scale) {
                return ((BigDecimal)toDataStore).setScale(this.scale, this.roundingMode);
            }
            return toDataStore;
        }
        throw new EntityRuntimeException("DecimalProperty must set BigDecimal value");
    }

    @Override
    public String toString(Object value) {
        if (value == null) {
            return null;
        }
        if (((BigDecimal)value).scale() != this.scale) {
            return ((BigDecimal)value).setScale(this.scale, this.roundingMode).toString();
        }
        return ((BigDecimal)value).toString();
    }

    @Override
    public Object fromString(String strValue) {
        if (strValue == null) {
            return null;
        }
        try {
            return new BigDecimal(strValue);
        }
        catch (NumberFormatException e) {
            if (logger.isDebugEnabled()) {
                logger.debug("Can't parse to Decimal:" + strValue);
            }
            return null;
        }
    }
}

