/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.condition.predicate;

import org.iplass.mtp.entity.query.condition.predicate.ComparisonPredicate;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.condition.predicate.Greater;
import org.iplass.mtp.entity.query.condition.predicate.GreaterEqual;
import org.iplass.mtp.entity.query.condition.predicate.Lesser;
import org.iplass.mtp.entity.query.condition.predicate.LesserEqual;
import org.iplass.mtp.entity.query.condition.predicate.NotEquals;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class ComparisonPredicateSyntax
implements Syntax<ComparisonPredicate>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public ComparisonPredicate parse(ParseContext str) throws ParseException {
        ComparisonPredicate cp = null;
        if (str.startsWith("=")) {
            cp = new Equals();
            str.consumeChars("=".length());
        } else if (str.startsWith(">=")) {
            cp = new GreaterEqual();
            str.consumeChars(">=".length());
        } else if (str.startsWith(">")) {
            cp = new Greater();
            str.consumeChars(">".length());
        } else if (str.startsWith("<=")) {
            cp = new LesserEqual();
            str.consumeChars("<=".length());
        } else if (str.startsWith("<")) {
            cp = new Lesser();
            str.consumeChars("<".length());
        } else if (str.startsWith("!=")) {
            cp = new NotEquals();
            str.consumeChars("!=".length());
        } else {
            throw new ParseException(new EvalError("operator expected.", this, str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        ValueExpression value = this.polynomial.parse(str);
        cp.setValue(value);
        return cp;
    }
}

