/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.query.value.primary;

import java.util.ArrayList;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.parser.EvalError;
import org.iplass.mtp.impl.parser.ParseContext;
import org.iplass.mtp.impl.parser.ParseException;
import org.iplass.mtp.impl.parser.Syntax;
import org.iplass.mtp.impl.parser.SyntaxContext;
import org.iplass.mtp.impl.query.QueryConstants;
import org.iplass.mtp.impl.query.value.expr.PolynomialSyntax;

public class FunctionSyntax
implements Syntax<Function>,
QueryConstants {
    private PolynomialSyntax polynomial;

    @Override
    public void init(SyntaxContext context) {
        this.polynomial = context.getSyntax(PolynomialSyntax.class);
    }

    @Override
    public Function parse(ParseContext str) throws ParseException {
        String funcName = str.nextToken(ParseContext.TOKEN_DELIMITERS);
        if (funcName == null) {
            throw new ParseException(new EvalError("function name expected.", this, str));
        }
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (!str.startsWith("(")) {
            throw new ParseException(new EvalError("( expected.", this, str));
        }
        str.consumeChars(1);
        str.consumeChars(ParseContext.WHITE_SPACES);
        Function func = new Function(funcName, new ValueExpression[0]);
        boolean isFirst = true;
        ArrayList<ValueExpression> values = new ArrayList<ValueExpression>();
        while (!str.startsWith(")") && !str.isEnd()) {
            if (isFirst) {
                isFirst = false;
            } else {
                if (!str.consumeChars(",".length())) {
                    throw new ParseException(new EvalError(", expected.", this, str));
                }
                str.consumeChars(ParseContext.WHITE_SPACES);
            }
            values.add(this.polynomial.parse(str));
            str.consumeChars(ParseContext.WHITE_SPACES);
        }
        if (!str.startsWith(")")) {
            throw new ParseException(new EvalError(") expected.", this, str));
        }
        str.consumeChars(")".length());
        str.consumeChars(ParseContext.WHITE_SPACES);
        if (values.size() != 0) {
            func.setArguments(values);
        }
        return func;
    }
}

