/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.adapter.function;

import java.util.List;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public abstract class BaseFunctionAdapter
implements FunctionAdapter {
    private String functionName;
    private String sqlFunctionName;

    public BaseFunctionAdapter(String functionName) {
        this.functionName = functionName;
        this.sqlFunctionName = functionName;
    }

    public BaseFunctionAdapter(String functionName, String sqlFunctionName) {
        this.functionName = functionName;
        this.sqlFunctionName = sqlFunctionName;
    }

    @Override
    public abstract Class<?> getType(Function var1, FunctionAdapter.ArgumentTypeResolver var2);

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        context.append(this.sqlFunctionName);
        context.append("(");
        if (function.getArguments() != null) {
            for (int i = 0; i < function.getArguments().size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.appendArgument(function.getArguments().get(i));
            }
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        context.append(this.sqlFunctionName);
        context.append("(");
        if (args != null) {
            for (int i = 0; i < args.size(); ++i) {
                if (i != 0) {
                    context.append(",");
                }
                context.append(args.get(i));
            }
        }
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return this.functionName;
    }
}

