/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.iplass.mtp.impl.rdb.connection.ConnectionWrapper;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalTransactionConnectionWrapper
extends ConnectionWrapper {
    private static final Logger logger = LoggerFactory.getLogger(LocalTransactionConnectionWrapper.class);
    private boolean inTransaction;
    private ResourceHolder resourceHolder;
    private boolean isClosed = false;
    private volatile boolean isClosePhysical;

    LocalTransactionConnectionWrapper(Connection wrapped, boolean inTransaction, ResourceHolder resourceHolder, int warnLogThreshold, boolean warnLogBefore) {
        super(wrapped, warnLogThreshold, warnLogBefore);
        this.inTransaction = inTransaction;
        this.resourceHolder = resourceHolder;
    }

    public void closePhysical() throws SQLException {
        if (this.resourceHolder != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("back to ResourceHolder:" + this.getWrapped());
            }
            this.resourceHolder.releaseConnection(this.getWrapped());
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("close physical connection:" + this.getWrapped());
            }
            this.getWrapped().close();
        }
        this.isClosePhysical = true;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (!this.isClosePhysical) {
            logger.warn("connection not closed. this cause connection leak... Connection:" + this.getWrapped());
            this.getWrapped().close();
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        if (!this.inTransaction) {
            this.closePhysical();
        }
    }

    @Override
    public void commit() throws SQLException {
        if (!this.inTransaction) {
            this.getWrapped().commit();
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        boolean physicalClosed = this.getWrapped().isClosed();
        if (physicalClosed) {
            return physicalClosed;
        }
        return this.isClosed;
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        if (!this.inTransaction) {
            this.getWrapped().releaseSavepoint(savepoint);
        }
    }

    @Override
    public void rollback() throws SQLException {
        if (!this.inTransaction) {
            this.getWrapped().rollback();
        }
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        if (!this.inTransaction) {
            this.getWrapped().rollback(savepoint);
        }
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!this.inTransaction) {
            this.getWrapped().setAutoCommit(autoCommit);
        }
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        if (!this.inTransaction) {
            return this.getWrapped().setSavepoint();
        }
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        if (!this.inTransaction) {
            return this.getWrapped().setSavepoint(name);
        }
        return null;
    }

    public boolean isInTransaction() {
        return this.inTransaction;
    }
}

