/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.connection;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.iplass.mtp.impl.rdb.connection.ConnectionWrapper;
import org.iplass.mtp.impl.rdb.connection.ResultSetWrapper;
import org.iplass.mtp.impl.rdb.connection.SQLExecution;
import org.iplass.mtp.impl.rdb.connection.StatementWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreparedStatementWrapper
extends StatementWrapper
implements PreparedStatement {
    private static Logger logger = LoggerFactory.getLogger(PreparedStatementWrapper.class);
    private PreparedStatement wrapped;
    private ConnectionWrapper con;
    private String sql;
    private List<Object> values;
    private List<Integer> indexs;

    PreparedStatementWrapper(PreparedStatement wrapped, ConnectionWrapper con, String sql, int warnLogThreshold, boolean warnLogBefore) {
        super(wrapped, con, warnLogThreshold, warnLogBefore);
        this.wrapped = wrapped;
        this.con = con;
        this.sql = sql;
        this.values = new ArrayList<Object>();
        this.indexs = new ArrayList<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T> T withLog(String method, String sql, boolean withParam, SQLExecution<T> s) throws SQLException {
        long start = System.currentTimeMillis();
        try {
            if (this.warnLogBefore && this.additionalWarnLogInfo != null && this.additionalWarnLogInfo.logBefore()) {
                logger.warn(this.logStr(method, sql, -1L, withParam));
            }
            T t = s.run();
            return t;
        }
        finally {
            long queryTime = System.currentTimeMillis() - start;
            if (this.warnLogThreshold > 0 && queryTime > (long)this.warnLogThreshold) {
                if (logger.isWarnEnabled()) {
                    logger.warn(this.logStr(method, sql, queryTime, withParam));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug(this.logStr(method, sql, queryTime, withParam));
            }
        }
    }

    private String logStr(String method, String sql, long queryTime, boolean withParam) {
        StringBuilder log = new StringBuilder();
        log.append(method);
        if (queryTime > -1L) {
            log.append(" time= ");
            log.append(queryTime);
            log.append(" ms.");
        }
        if (sql != null) {
            log.append(" sql=");
            log.append(sql);
        }
        log.append(" -- ");
        if (withParam) {
            log.append("index= ");
            log.append(this.indexs);
            log.append(" values= ");
            log.append(this.values);
        }
        if (this.additionalWarnLogInfo != null) {
            log.append(" ");
            log.append(this.additionalWarnLogInfo);
        }
        return log.toString();
    }

    @Override
    public void addBatch() throws SQLException {
        try {
            this.wrapped.addBatch();
            if (logger.isDebugEnabled()) {
                logger.debug(this.logStr("addBatch()", null, -1L, true));
            }
        }
        finally {
            this.values.clear();
            this.indexs.clear();
        }
    }

    @Override
    public void clearParameters() throws SQLException {
        try {
            this.wrapped.clearParameters();
        }
        finally {
            this.values.clear();
            this.indexs.clear();
        }
    }

    @Override
    public boolean execute() throws SQLException {
        try {
            boolean bl = this.withLog("execute", this.sql, true, () -> this.wrapped.execute());
            return bl;
        }
        finally {
            this.values.clear();
            this.indexs.clear();
        }
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        try {
            ResultSet resultSet = this.withLog("query", this.sql, true, () -> new ResultSetWrapper(this.wrapped.executeQuery(), this));
            return resultSet;
        }
        finally {
            this.values.clear();
            this.indexs.clear();
        }
    }

    @Override
    public int executeUpdate() throws SQLException {
        try {
            int n = this.withLog("update", this.sql, true, () -> this.wrapped.executeUpdate());
            return n;
        }
        finally {
            this.values.clear();
            this.indexs.clear();
        }
    }

    @Override
    public final int[] executeBatch() throws SQLException {
        return this.withLog("batch", this.sql, false, () -> this.wrapped.executeBatch());
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.wrapped.getMetaData();
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this.wrapped.getParameterMetaData();
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.wrapped.setArray(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrapped.setAsciiStream(parameterIndex, x, length);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.wrapped.setAsciiStream(parameterIndex, x, length);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        this.wrapped.setAsciiStream(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.wrapped.setBigDecimal(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrapped.setBinaryStream(parameterIndex, x, length);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        this.wrapped.setBinaryStream(parameterIndex, x, length);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        this.wrapped.setBinaryStream(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, Blob x) throws SQLException {
        this.wrapped.setBlob(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream, long length) throws SQLException {
        this.wrapped.setBlob(parameterIndex, inputStream, length);
        this.setValues(parameterIndex, inputStream);
    }

    @Override
    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        this.wrapped.setBlob(parameterIndex, inputStream);
        this.setValues(parameterIndex, inputStream);
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.wrapped.setBoolean(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.wrapped.setByte(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.wrapped.setBytes(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this.wrapped.setCharacterStream(parameterIndex, reader, length);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader, long length) throws SQLException {
        this.wrapped.setCharacterStream(parameterIndex, reader, length);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        this.wrapped.setCharacterStream(parameterIndex, reader);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Clob x) throws SQLException {
        this.wrapped.setClob(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.wrapped.setClob(parameterIndex, reader, length);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        this.wrapped.setClob(parameterIndex, reader);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.wrapped.setDate(parameterIndex, x, cal);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.wrapped.setDate(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.wrapped.setDouble(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.wrapped.setFloat(parameterIndex, x);
        this.setValues(parameterIndex, Float.valueOf(x));
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.wrapped.setInt(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.wrapped.setLong(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value, long length) throws SQLException {
        this.wrapped.setNCharacterStream(parameterIndex, value, length);
        this.setValues(parameterIndex, value);
    }

    @Override
    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        this.wrapped.setNCharacterStream(parameterIndex, value);
        this.setValues(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        this.wrapped.setNClob(parameterIndex, value);
        this.setValues(parameterIndex, value);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        this.wrapped.setNClob(parameterIndex, reader, length);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        this.wrapped.setNClob(parameterIndex, reader);
        this.setValues(parameterIndex, reader);
    }

    @Override
    public void setNString(int parameterIndex, String value) throws SQLException {
        this.wrapped.setNString(parameterIndex, value);
        this.setValues(parameterIndex, value);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.wrapped.setNull(parameterIndex, sqlType, typeName);
        this.setValues(parameterIndex, typeName + ":" + sqlType);
    }

    @Override
    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this.wrapped.setNull(parameterIndex, sqlType);
        this.setValues(parameterIndex, sqlType);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.wrapped.setObject(parameterIndex, x, targetSqlType, scaleOrLength);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this.wrapped.setObject(parameterIndex, x, targetSqlType);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.wrapped.setObject(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setRef(int parameterIndex, Ref x) throws SQLException {
        this.wrapped.setRef(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        this.wrapped.setRowId(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.wrapped.setShort(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        this.wrapped.setSQLXML(parameterIndex, xmlObject);
        this.setValues(parameterIndex, xmlObject);
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.wrapped.setString(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.wrapped.setTime(parameterIndex, x, cal);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setTime(int parameterIndex, Time x) throws SQLException {
        this.wrapped.setTime(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.wrapped.setTimestamp(parameterIndex, x, cal);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.wrapped.setTimestamp(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this.wrapped.setUnicodeStream(parameterIndex, x, length);
        this.setValues(parameterIndex, x);
    }

    @Override
    public void setURL(int parameterIndex, URL x) throws SQLException {
        this.wrapped.setURL(parameterIndex, x);
        this.setValues(parameterIndex, x);
    }

    private final void setValues(int index, Object value) {
        this.values.add(value);
        this.indexs.add(index);
    }
}

