/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.mysql;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.iplass.mtp.entity.query.GroupBy;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.impl.i18n.I18nService;
import org.iplass.mtp.impl.rdb.adapter.HintPlace;
import org.iplass.mtp.impl.rdb.adapter.MultiInsertContext;
import org.iplass.mtp.impl.rdb.adapter.MultiTableUpdateMethod;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UnsupportedDataTypeException;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.BulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.InOperatorBulkDeleteContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkInsertContext;
import org.iplass.mtp.impl.rdb.adapter.bulk.PreparedBulkUpdateContext;
import org.iplass.mtp.impl.rdb.adapter.function.DynamicTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.StaticTypedFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentDateTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.CurrentTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.ExtractDateFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.LocalTimeFunctionAdapter;
import org.iplass.mtp.impl.rdb.common.function.RoundTruncFunctionAdapter;
import org.iplass.mtp.impl.rdb.connection.ConnectionException;
import org.iplass.mtp.impl.rdb.connection.ConnectionFactory;
import org.iplass.mtp.impl.rdb.mysql.MysqlMultiInsertContext;
import org.iplass.mtp.impl.rdb.mysql.function.MysqlDateAddFunctionAdapter;
import org.iplass.mtp.impl.rdb.mysql.function.MysqlDateDiffFunctionAdapter;
import org.iplass.mtp.spi.ServiceRegistry;

public class MysqlRdbAdaptor
extends RdbAdapter {
    private static final String DATE_MIN = "10000101000000000";
    private static final String DATE_MAX = "99991231235959999";
    private static final String[] optimizerHintBracket = new String[]{"/*+", "*/"};
    private boolean useFractionalSecondsOnTimestamp = true;
    private boolean supportOptimizerHint = false;
    private boolean supportWindowFunction = false;
    private boolean localTemporaryTableManageOutsideTransaction = false;
    private boolean localTemporaryTableCreatedByDataSource = false;
    private String timestampMethod = "NOW(3)";
    private boolean enableBindHint;
    private int batchSize = 100;
    private int thresholdCountOfUsePrepareStatement = -1;
    private int maxFetchSize = 100;
    private int defaultQueryTimeout;
    long dateMin;
    long dateMax;
    private static final String[] CAST_VARCHAR = new String[]{"CAST(", " AS CHAR)"};
    private static final String[] CAST_BIGINT = new String[]{"CAST(", " AS SIGNED)"};
    private static final String[] CAST_DECIMAL = new String[]{"CAST(", " AS DECIMAL(65,30))"};
    private static final String[] CAST_DATE = new String[]{"CAST(", " AS DATE)"};
    private static final String[] CAST_DOUBLE = new String[]{"CAST(", " AS DECIMAL(65,30))"};
    private static final String[] CAST_TIME = new String[]{"STR_TO_DATE(CONCAT('1970-01-01 ',TIME_FORMAT(CAST(", " AS TIME),'%H:%i:%s')),'%Y-%m-%d %H:%i:%s')"};
    private static final String[] CAST_TIME_WITH_FS = new String[]{"STR_TO_DATE(CONCAT('1970-01-01 ',TIME_FORMAT(CAST(", " AS TIME),'%H:%i:%s')),'%Y-%m-%d %H:%i:%s.%f')"};
    private static final String[] CAST_TIMESTAMP = new String[]{"CAST(", " AS DATETIME)"};
    private static final String[] CAST_TIMESTAMP_WITH_FS = new String[]{"CAST(", " AS DATETIME(3))"};

    public MysqlRdbAdaptor() {
        this.addFunction(new StaticTypedFunctionAdapter("CHAR_LENGTH", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("INSTR", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("CONCAT", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("SUBSTR", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("REPLACE", String.class));
        this.addFunction(new DynamicTypedFunctionAdapter("MOD", new int[]{0, 1}));
        this.addFunction(new StaticTypedFunctionAdapter("SQRT", Double.class));
        this.addFunction(new DynamicTypedFunctionAdapter("POWER", new int[]{0, 1}));
        this.addFunction(new DynamicTypedFunctionAdapter("ABS", new int[]{0}));
        this.addFunction(new StaticTypedFunctionAdapter("CEIL", Long.class));
        this.addFunction(new StaticTypedFunctionAdapter("FLOOR", Long.class));
        this.addFunction(new RoundTruncFunctionAdapter("ROUND", "ROUND"));
        this.addFunction(new RoundTruncFunctionAdapter("TRUNCATE", "TRUNCATE"));
        this.addFunction(new StaticTypedFunctionAdapter("UPPER", String.class));
        this.addFunction(new StaticTypedFunctionAdapter("LOWER", String.class));
        this.addFunction(new ExtractDateFunctionAdapter("SECOND"));
        this.addFunction(new ExtractDateFunctionAdapter("MINUTE"));
        this.addFunction(new ExtractDateFunctionAdapter("HOUR"));
        this.addFunction(new ExtractDateFunctionAdapter("DAY"));
        this.addFunction(new ExtractDateFunctionAdapter("MONTH"));
        this.addFunction(new ExtractDateFunctionAdapter("YEAR"));
        this.addFunction(new MysqlDateAddFunctionAdapter());
        this.addFunction(new MysqlDateDiffFunctionAdapter());
        this.addFunction(new CurrentDateFunctionAdapter());
        this.addFunction(new CurrentTimeFunctionAdapter());
        this.addFunction(new CurrentDateTimeFunctionAdapter());
        this.addFunction(new LocalTimeFunctionAdapter());
        I18nService i18n = ServiceRegistry.getRegistry().getService(I18nService.class);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmssSSS");
        sdf.setTimeZone(i18n.getTimezone());
        try {
            this.dateMin = sdf.parse(DATE_MIN).getTime();
            this.dateMax = sdf.parse(DATE_MAX).getTime();
        }
        catch (ParseException e) {
            throw new UnsupportedDataTypeException(e);
        }
    }

    @Override
    public Connection getConnection(String connectionFactoryName) throws SQLException {
        ConnectionFactory cf = null;
        cf = connectionFactoryName == null ? ServiceRegistry.getRegistry().getService(ConnectionFactory.class) : (ConnectionFactory)ServiceRegistry.getRegistry().getService(connectionFactoryName);
        if (this.localTemporaryTableManageOutsideTransaction && !this.localTemporaryTableCreatedByDataSource) {
            return cf.getConnection((Connection con) -> {
                try {
                    boolean isAutoCommit = con.getAutoCommit();
                    if (!isAutoCommit) {
                        con.setAutoCommit(true);
                    }
                    try (Statement stmt = con.createStatement();){
                        stmt.executeUpdate(this.createLocalTemporaryTableInternal("OBJ_STORE_TMP", "OBJ_STORE", new String[]{"OBJ_ID", "OBJ_VER"}));
                    }
                    con.setAutoCommit(isAutoCommit);
                    return con;
                }
                catch (SQLException e) {
                    throw new ConnectionException("Exeception occured in the handler that after get physical connection.", e);
                }
            });
        }
        return cf.getConnection();
    }

    @Override
    public int getDefaultQueryTimeout() {
        return this.defaultQueryTimeout;
    }

    public void setDefaultQueryTimeout(int defaultQueryTimeout) {
        this.defaultQueryTimeout = defaultQueryTimeout;
    }

    @Override
    public int getMaxFetchSize() {
        return this.maxFetchSize;
    }

    public void setMaxFetchSize(int maxFetchSize) {
        this.maxFetchSize = maxFetchSize;
    }

    public boolean isUseFractionalSecondsOnTimestamp() {
        return this.useFractionalSecondsOnTimestamp;
    }

    public void setUseFractionalSecondsOnTimestamp(boolean useFractionalSecondsOnTimestamp) {
        this.useFractionalSecondsOnTimestamp = useFractionalSecondsOnTimestamp;
    }

    public String getTimestampMethod() {
        return this.timestampMethod;
    }

    public void setTimestampMethod(String timestampMethod) {
        this.timestampMethod = timestampMethod;
    }

    @Override
    public MultiInsertContext createMultiInsertContext(Statement stmt) {
        return new MysqlMultiInsertContext(stmt);
    }

    @Override
    public String dual() {
        return "FROM DUAL";
    }

    @Override
    protected String getDataTypeOf(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                return null;
            }
            case -5: {
                return "SIGNED";
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return "DECIMAL(65,30)";
                    }
                    return "DECIMAL(65," + scale + ")";
                }
                if (scale == null) {
                    return "DECIMAL(" + lengthOrPrecision + ",0)";
                }
                return "DECIMAL(" + lengthOrPrecision + "," + scale + ")";
            }
            case 91: {
                if (this.useFractionalSecondsOnTimestamp) {
                    return "DATETIME(3)";
                }
                return "DATETIME";
            }
            case 8: {
                return "DECIMAL(65,30)";
            }
            case 92: 
            case 93: {
                if (this.useFractionalSecondsOnTimestamp) {
                    return "DATETIME(3)";
                }
                return "DATETIME";
            }
        }
        return null;
    }

    @Override
    public String rowLockExpression() {
        return "FOR UPDATE";
    }

    @Override
    public String systimestamp() {
        return this.timestampMethod;
    }

    private void checkDateRange(java.util.Date date) {
        long time;
        if (date != null && (this.dateMin > (time = date.getTime()) || this.dateMax < time)) {
            throw new UnsupportedDataTypeException("out of range Date:" + date);
        }
    }

    @Override
    public String toDateExpression(Date date) {
        this.checkDateRange(date);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return "STR_TO_DATE('" + fmt.format(date) + "','%Y-%m-%d')";
    }

    @Override
    public String toTimeExpression(Time time) {
        this.checkDateRange(time);
        SimpleDateFormat fmt = new SimpleDateFormat("HH:mm:ss");
        return "STR_TO_DATE('1970-01-01 " + fmt.format(time) + "','%Y-%m-%d %H:%i:%s')";
    }

    @Override
    public String toTimeStampExpression(Timestamp date) {
        this.checkDateRange(date);
        if (this.useFractionalSecondsOnTimestamp) {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
            return "STR_TO_DATE('" + fmt.format(date) + "','%Y-%m-%d %H:%i:%s.%f')";
        }
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return "STR_TO_DATE('" + fmt.format(date) + "','%Y-%m-%d %H:%i:%s')";
    }

    @Override
    public String toLimitSql(String selectSql, int limitCount, int offset, boolean asBind) {
        if (asBind) {
            StringBuilder sb = new StringBuilder();
            sb.append(selectSql);
            sb.append(" LIMIT ?,?");
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(selectSql);
        sb.append(" LIMIT " + offset + "," + limitCount);
        return sb.toString();
    }

    @Override
    public Object[] toLimitSqlBindValue(int limitCount, int offset) {
        return new Integer[]{offset, limitCount};
    }

    @Override
    public boolean isDuplicateValueException(SQLException e) {
        if (e.getErrorCode() == 1022 || e.getErrorCode() == 1062) {
            return true;
        }
        return e instanceof BatchUpdateException && e.getMessage() != null && (e.getMessage().contains("Duplicate entry") || e.getMessage().contains("Can't write; duplicate key in table"));
    }

    @Override
    public boolean isDeadLock(SQLException e) {
        return e.getErrorCode() == 1213;
    }

    @Override
    public boolean isLockFailed(SQLException e) {
        return e.getErrorCode() == 1205;
    }

    @Override
    public boolean isCastFailed(SQLException e) {
        return false;
    }

    @Override
    public String addDate(String dateExpression, int day) {
        return "DATE_ADD(" + dateExpression + ", INTERVAL '" + day + "' DAY )";
    }

    @Override
    public String checkStatusQuery() {
        return "SELECT 1 ";
    }

    @Override
    public String likePattern(String str) {
        return str;
    }

    @Override
    public String escape() {
        return "ESCAPE '\\\\'";
    }

    @Override
    public String sanitize(String str) {
        if (str == null) {
            return null;
        }
        boolean containsQuote = false;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\'' && str.charAt(i) != '\\') continue;
            containsQuote = true;
            break;
        }
        if (containsQuote) {
            StringBuilder sb = new StringBuilder();
            char c = '\u0000';
            for (int i = 0; i < str.length(); ++i) {
                c = str.charAt(i);
                if (c == '\'') {
                    sb.append('\'');
                } else if (c == '\\') {
                    sb.append('\\');
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return str;
    }

    @Override
    public String[] castExp(int sqlType, Integer lengthOrPrecision, Integer scale) {
        switch (sqlType) {
            case 12: {
                if (lengthOrPrecision != null) {
                    return new String[]{"CAST(", " AS CHAR(" + lengthOrPrecision + "))"};
                }
                return CAST_VARCHAR;
            }
            case -5: {
                return CAST_BIGINT;
            }
            case 3: {
                if (lengthOrPrecision == null) {
                    if (scale == null) {
                        return CAST_DECIMAL;
                    }
                    if (scale < 0) {
                        return new String[]{"ROUND(CAST(", " AS DECIMAL(65,0))," + scale + ")"};
                    }
                    return new String[]{"CAST(", " AS DECIMAL(65," + scale + "))"};
                }
                if (scale == null) {
                    return new String[]{"CAST(", " AS DECIMAL(" + lengthOrPrecision + ",0))"};
                }
                if (scale < 0) {
                    return new String[]{"ROUND(CAST(", " AS DECIMAL(" + lengthOrPrecision + -scale.intValue() + ",0))," + scale + ")"};
                }
                return new String[]{"CAST(", " AS DECIMAL(" + lengthOrPrecision + "," + scale + "))"};
            }
            case 91: {
                return CAST_DATE;
            }
            case 8: {
                return CAST_DOUBLE;
            }
            case 92: {
                if (this.useFractionalSecondsOnTimestamp) {
                    return CAST_TIME_WITH_FS;
                }
                return CAST_TIME;
            }
            case 93: {
                if (this.useFractionalSecondsOnTimestamp) {
                    return CAST_TIMESTAMP_WITH_FS;
                }
                return CAST_TIMESTAMP;
            }
        }
        return null;
    }

    @Override
    public CharSequence cast(int fromSqlType, int toSqlType, CharSequence valExpr, Integer lengthOrPrecision, Integer scale) {
        if (toSqlType == 3 && scale != null && scale < 0) {
            CharSequence castString = super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, 0);
            return "ROUND(" + castString + "," + scale + ")";
        }
        return super.cast(fromSqlType, toSqlType, valExpr, lengthOrPrecision, scale);
    }

    @Override
    public String tableAlias(String selectSql) {
        return "SELECT X.* FROM (" + selectSql + ") AS X";
    }

    @Override
    public boolean isSupportGroupingExtention(GroupBy.RollType rollType) {
        switch (rollType) {
            case ROLLUP: {
                return true;
            }
            case CUBE: {
                return false;
            }
        }
        return false;
    }

    @Override
    public String rollUpStart(GroupBy.RollType rollType) {
        return "";
    }

    @Override
    public String rollUpEnd(GroupBy.RollType rollType) {
        switch (rollType) {
            case ROLLUP: 
            case CUBE: {
                return " WITH ROLLUP ";
            }
        }
        return "";
    }

    @Override
    public String seqNextSelectSql(String sequenceName, int tenantId, String entityDefId) {
        throw new UnsupportedOperationException("SEQUENCE not supported");
    }

    @Override
    public String initBlob() {
        return "''";
    }

    @Override
    public boolean isUseSubQueryForIndexJoin() {
        return false;
    }

    @Override
    public String getOptimizerHint() {
        return null;
    }

    @Override
    public HintPlace getOptimizerHintPlace() {
        return HintPlace.AFTER_SELECT;
    }

    @Override
    public String[] getOptimizerHintBracket() {
        return optimizerHintBracket;
    }

    @Override
    public boolean isSupportOptimizerHint() {
        return this.supportOptimizerHint;
    }

    public void setSupportOptimizerHint(boolean supportOptimizerHint) {
        this.supportOptimizerHint = supportOptimizerHint;
    }

    @Override
    public boolean isSupportTableHint() {
        return true;
    }

    @Override
    public String[] getTableHintBracket() {
        return null;
    }

    @Override
    public void appendSortSpecExpression(StringBuilder sb, CharSequence sortValue, SortSpec.SortType sortType, SortSpec.NullOrderingSpec nullOrderingSpec) {
        if (nullOrderingSpec != null) {
            sb.append(sortValue);
            switch (nullOrderingSpec) {
                case FIRST: {
                    sb.append(" IS NULL DESC,");
                    break;
                }
                case LAST: {
                    sb.append(" IS NULL ASC,");
                    break;
                }
            }
        }
        sb.append(sortValue);
        if (sortType != null) {
            switch (sortType) {
                case ASC: {
                    sb.append(" ASC");
                    break;
                }
                case DESC: {
                    sb.append(" DESC");
                    break;
                }
            }
        }
    }

    @Override
    public String[] convertTZ(String to) {
        String[] ret = new String[]{"CONVERT_TZ(", ",(SELECT @@session.time_zone),'" + to + "')"};
        return ret;
    }

    @Override
    public boolean isEnableInPartitioning() {
        return false;
    }

    @Override
    public int getInPartitioningSize() {
        return -1;
    }

    @Override
    public String deleteTemporaryTable(String tableName) {
        if (this.localTemporaryTableManageOutsideTransaction || this.localTemporaryTableCreatedByDataSource) {
            return "TRUNCATE TABLE " + tableName;
        }
        return "DROP TEMPORARY TABLE IF EXISTS " + tableName;
    }

    @Override
    public boolean isSupportGlobalTemporaryTable() {
        return false;
    }

    @Override
    public String createLocalTemporaryTable(String tableName, String baseTableName, String[] baseColumnName) {
        if (this.localTemporaryTableManageOutsideTransaction || this.localTemporaryTableCreatedByDataSource) {
            return "DELETE FROM " + tableName + " WHERE 1=2";
        }
        return this.createLocalTemporaryTableInternal(tableName, baseTableName, baseColumnName);
    }

    private String createLocalTemporaryTableInternal(String tableName, String baseTableName, String[] baseColumnName) {
        StringBuilder sb = new StringBuilder();
        sb.append("CREATE TEMPORARY TABLE IF NOT EXISTS ");
        sb.append(tableName);
        sb.append(" ENGINE=MEMORY ");
        sb.append("SELECT ");
        for (int i = 0; i < baseColumnName.length; ++i) {
            if (i != 0) {
                sb.append(",");
            }
            sb.append(baseColumnName[i]);
        }
        sb.append(" FROM ");
        sb.append(baseTableName);
        sb.append(" WHERE 1=2");
        return sb.toString();
    }

    @Override
    public boolean isSupportAutoClearTemporaryTableWhenCommit() {
        return false;
    }

    @Override
    public boolean isSupportGroupingExtentionWithOrderBy() {
        return false;
    }

    @Override
    public boolean isSupportGroupingExtention() {
        return true;
    }

    @Override
    public boolean isEnableBindHint() {
        return this.enableBindHint;
    }

    public void setEnableBindHint(boolean enableBindHint) {
        this.enableBindHint = enableBindHint;
    }

    @Override
    public boolean isAlwaysBind() {
        return false;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public int getThresholdCountOfUsePrepareStatement() {
        return this.thresholdCountOfUsePrepareStatement;
    }

    public void setThresholdCountOfUsePrepareStatement(int thresholdCountOfUsePrepareStatement) {
        this.thresholdCountOfUsePrepareStatement = thresholdCountOfUsePrepareStatement;
    }

    @Override
    public BulkInsertContext createBulkInsertContext() {
        return new PreparedBulkInsertContext();
    }

    @Override
    public BulkUpdateContext createBulkUpdateContext() {
        return new PreparedBulkUpdateContext();
    }

    @Override
    public BulkDeleteContext createBulkDeleteContext() {
        return new InOperatorBulkDeleteContext();
    }

    @Override
    public MultiTableUpdateMethod getMultiTableUpdateMethod() {
        return MultiTableUpdateMethod.DIRECT_JOIN;
    }

    @Override
    public ResultSet getTableNames(String tableNamePattern, Connection con) throws SQLException {
        DatabaseMetaData dbMeta = con.getMetaData();
        return dbMeta.getTables(con.getCatalog(), null, tableNamePattern, null);
    }

    @Override
    public boolean isSupportWindowFunction() {
        return this.supportWindowFunction;
    }

    public void setSupportWindowFunction(boolean supportWindowFunction) {
        this.supportWindowFunction = supportWindowFunction;
    }

    public void setLocalTemporaryTableManageOutsideTransaction(boolean localTemporaryTableManageOutsideTransaction) {
        this.localTemporaryTableManageOutsideTransaction = localTemporaryTableManageOutsideTransaction;
    }

    public void setLocalTemporaryTableCreatedByDataSource(boolean localTemporaryTableCreatedByDataSource) {
        this.localTemporaryTableCreatedByDataSource = localTemporaryTableCreatedByDataSource;
    }
}

