/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.rdb.sqlserver.function;

import java.util.List;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.primary.Function;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.function.FunctionAdapter;

public class SqlServerSubstrFunctionAdapter
implements FunctionAdapter {
    private String field;

    public SqlServerSubstrFunctionAdapter(String field) {
        this.field = field;
    }

    @Override
    public void toSQL(FunctionAdapter.FunctionContext context, Function function, RdbAdapter rdb) {
        if (function.getArguments() == null || function.getArguments().size() < 2 || function.getArguments().size() > 3) {
            throw new QueryException(function.getName() + " must have two or three arguments.");
        }
        context.append("SUBSTRING(");
        context.appendArgument(function.getArguments().get(0));
        context.append(", ");
        context.appendArgument(function.getArguments().get(1));
        if (function.getArguments().size() == 3) {
            context.append(", ");
            context.appendArgument(function.getArguments().get(2));
        } else {
            context.append(", LEN(");
            context.appendArgument(function.getArguments().get(0));
            context.append(")");
        }
        context.append(")");
    }

    @Override
    public void toSQL(StringBuilder context, List<CharSequence> args, RdbAdapter rdb) {
        if (args == null || args.size() < 2 || args.size() > 3) {
            throw new QueryException(this.getFunctionName() + " must have two or three arguments.");
        }
        context.append("SUBSTRING(");
        context.append(args.get(0));
        context.append(", ");
        context.append(args.get(1));
        if (args.size() == 3) {
            context.append(", ");
            context.append(args.get(2));
        } else {
            context.append(", LEN(");
            context.append(args.get(0));
            context.append(")");
        }
        context.append(")");
    }

    @Override
    public String getFunctionName() {
        return this.field;
    }

    @Override
    public Class<?> getType(Function function, FunctionAdapter.ArgumentTypeResolver typeResolver) {
        return String.class;
    }
}

