/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.runtime;

import java.util.HashMap;
import java.util.Map;
import org.iplass.mtp.impl.runtime.EntryPointImpl;
import org.iplass.mtp.runtime.EntryPoint;
import org.iplass.mtp.runtime.EntryPointBuilder;

public class EntryPointBuilderImpl
implements EntryPointBuilder {
    private Map<String, String> customProps;

    private Map<String, String> customProps() {
        if (this.customProps == null) {
            this.customProps = new HashMap<String, String>();
        }
        return this.customProps;
    }

    @Override
    public EntryPoint build() {
        return EntryPointImpl.newEntryPointImpl(this.customProps);
    }

    @Override
    public EntryPointBuilder serverEnvFile(String serverEnvFile) {
        this.customProps().put("mtp.server.env", serverEnvFile);
        return this;
    }

    @Override
    public EntryPointBuilder serverId(String serverId) {
        this.customProps().put("mtp.server.myserverid", serverId);
        return this;
    }

    @Override
    public EntryPointBuilder serverRole(String ... serverRole) {
        String concatRoles = null;
        if (serverRole != null) {
            concatRoles = serverRole.length == 1 ? serverRole[0] : String.join((CharSequence)",", serverRole);
        }
        this.customProps().put("mtp.server.myserverid", concatRoles);
        return this;
    }

    @Override
    public EntryPointBuilder config(String configFileName) {
        this.customProps().put("mtp.config", configFileName);
        return this;
    }

    @Override
    public EntryPointBuilder crypt(String configCryptFileName) {
        this.customProps().put("mtp.config.crypt", configCryptFileName);
        return this;
    }

    @Override
    public EntryPointBuilder loader(String loaderClassName) {
        this.customProps().put("mtp.config.loader", loaderClassName);
        return this;
    }

    @Override
    public EntryPointBuilder property(String name, String value) {
        this.customProps().put(name, value);
        return this;
    }
}

