/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.sms.template;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.definition.DefinableMetaData;
import org.iplass.mtp.impl.mail.template.MetaPlainTextBodyPart;
import org.iplass.mtp.impl.metadata.BaseMetaDataRuntime;
import org.iplass.mtp.impl.metadata.BaseRootMetaData;
import org.iplass.mtp.impl.metadata.MetaDataConfig;
import org.iplass.mtp.impl.script.GroovyScriptEngine;
import org.iplass.mtp.impl.script.ScriptEngine;
import org.iplass.mtp.impl.script.ScriptRuntimeException;
import org.iplass.mtp.impl.script.template.GroovyTemplate;
import org.iplass.mtp.impl.script.template.GroovyTemplateBinding;
import org.iplass.mtp.impl.script.template.GroovyTemplateCompiler;
import org.iplass.mtp.impl.sms.SmsService;
import org.iplass.mtp.impl.sms.template.MetaLocalizedSmsMailTemplate;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.sms.SmsMail;
import org.iplass.mtp.sms.template.definition.LocalizedSmsMailTemplateDefinition;
import org.iplass.mtp.sms.template.definition.SmsMailTemplateDefinition;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.tenant.TenantI18nInfo;
import org.iplass.mtp.util.StringUtil;

@XmlRootElement
public class MetaSmsMailTemplate
extends BaseRootMetaData
implements DefinableMetaData<SmsMailTemplateDefinition> {
    private static final long serialVersionUID = -1361851708003244753L;
    private MetaPlainTextBodyPart message;
    private List<MetaLocalizedSmsMailTemplate> localizedSmsMailTemplateList;
    private String langOrUserBindingName;

    public MetaPlainTextBodyPart getMessage() {
        return this.message;
    }

    public void setMessage(MetaPlainTextBodyPart message) {
        this.message = message;
    }

    public List<MetaLocalizedSmsMailTemplate> getLocalizedSmsMailTemplateList() {
        return this.localizedSmsMailTemplateList;
    }

    public void setLocalizedSmsMailTemplateList(List<MetaLocalizedSmsMailTemplate> localizedSmsMailTemplateList) {
        this.localizedSmsMailTemplateList = localizedSmsMailTemplateList;
    }

    public String getLangOrUserBindingName() {
        return this.langOrUserBindingName;
    }

    public void setLangOrUserBindingName(String langOrUserBindingName) {
        this.langOrUserBindingName = langOrUserBindingName;
    }

    @Override
    public SmsMailTemplateRuntime createRuntime(MetaDataConfig metaDataConfig) {
        return new SmsMailTemplateRuntime();
    }

    @Override
    public MetaSmsMailTemplate copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public void applyConfig(SmsMailTemplateDefinition d) {
        this.name = d.getName();
        this.displayName = d.getDisplayName();
        this.description = d.getDescription();
        if (d.getPlainMessage() != null) {
            this.message = new MetaPlainTextBodyPart();
            this.message.applyConfig(d.getPlainMessage());
        } else {
            this.message = null;
        }
        if (d.getLocalizedSmsMailTemplateList() != null) {
            this.localizedSmsMailTemplateList = new ArrayList<MetaLocalizedSmsMailTemplate>();
            for (LocalizedSmsMailTemplateDefinition ltd : d.getLocalizedSmsMailTemplateList()) {
                MetaLocalizedSmsMailTemplate mt = new MetaLocalizedSmsMailTemplate();
                mt.applyConfig(ltd);
                this.localizedSmsMailTemplateList.add(mt);
            }
        } else {
            this.localizedSmsMailTemplateList = null;
        }
        this.langOrUserBindingName = d.getLangOrUserBindingName();
    }

    @Override
    public SmsMailTemplateDefinition currentConfig() {
        SmsMailTemplateDefinition d = new SmsMailTemplateDefinition();
        d.setName(this.name);
        d.setDisplayName(this.displayName);
        d.setDescription(this.description);
        if (this.message != null) {
            d.setPlainMessage(this.message.currentConfig());
        }
        if (this.localizedSmsMailTemplateList != null) {
            for (MetaLocalizedSmsMailTemplate mt : this.localizedSmsMailTemplateList) {
                d.addLocalizedSmsMailTemplate(mt.currentConfig());
            }
        }
        d.setLangOrUserBindingName(this.langOrUserBindingName);
        return d;
    }

    public class SmsMailTemplateRuntime
    extends BaseMetaDataRuntime {
        private GroovyTemplate messageTemplate;
        private Map<String, GroovyTemplate> templateSetMap = new HashMap<String, GroovyTemplate>();

        @Override
        public MetaSmsMailTemplate getMetaData() {
            return MetaSmsMailTemplate.this;
        }

        public SmsMailTemplateRuntime() {
            try {
                if (MetaSmsMailTemplate.this.localizedSmsMailTemplateList != null && MetaSmsMailTemplate.this.localizedSmsMailTemplateList.size() > 0) {
                    GroovyTemplate messageTemplate = null;
                    ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                    for (MetaLocalizedSmsMailTemplate m : MetaSmsMailTemplate.this.localizedSmsMailTemplateList) {
                        String localeName = m.getLocaleName();
                        if (m.getMessage() != null && m.getMessage().getContent() != null) {
                            messageTemplate = GroovyTemplateCompiler.compile(m.getMessage().getContent(), "SmsMailTemplate_Text" + MetaSmsMailTemplate.this.getName() + "__" + localeName, (GroovyScriptEngine)se);
                        }
                        this.templateSetMap.put(localeName, messageTemplate);
                    }
                }
                ScriptEngine se = ExecuteContext.getCurrentContext().getTenantContext().getScriptEngine();
                if (MetaSmsMailTemplate.this.message != null && MetaSmsMailTemplate.this.message.getContent() != null) {
                    this.messageTemplate = GroovyTemplateCompiler.compile(MetaSmsMailTemplate.this.message.getContent(), "MailTemplate_Text" + MetaSmsMailTemplate.this.getName(), (GroovyScriptEngine)se);
                }
            }
            catch (RuntimeException e) {
                this.setIllegalStateException(e);
            }
        }

        public SmsMail createMail(Map<String, Object> bindings) {
            this.checkState();
            String lang = ExecuteContext.getCurrentContext().getCurrentTenant().getTenantConfig(TenantI18nInfo.class).getLocale();
            if (StringUtil.isNotEmpty(MetaSmsMailTemplate.this.langOrUserBindingName) && bindings.get(MetaSmsMailTemplate.this.langOrUserBindingName) != null) {
                User user;
                String userLang;
                if (bindings.get(MetaSmsMailTemplate.this.langOrUserBindingName) instanceof String) {
                    lang = (String)bindings.get(MetaSmsMailTemplate.this.langOrUserBindingName);
                } else if (bindings.get(MetaSmsMailTemplate.this.langOrUserBindingName) instanceof User && StringUtil.isNotEmpty(userLang = (user = (User)bindings.get(MetaSmsMailTemplate.this.langOrUserBindingName)).getLanguage())) {
                    lang = userLang;
                }
            }
            SmsService service = ServiceRegistry.getRegistry().getService(SmsService.class);
            ExecuteContext ex = ExecuteContext.getCurrentContext();
            GroovyTemplate msgTmpl = this.messageTemplate;
            if (this.templateSetMap.get(lang) != null) {
                msgTmpl = this.templateSetMap.get(lang);
            }
            SmsMail smsMail = service.createMail(ex.getCurrentTenant());
            if (msgTmpl != null) {
                StringWriter sw = new StringWriter();
                GroovyTemplateBinding gtb = new GroovyTemplateBinding(sw);
                if (bindings != null) {
                    for (Map.Entry<String, Object> e : bindings.entrySet()) {
                        gtb.setVariable(e.getKey(), e.getValue());
                    }
                }
                try {
                    msgTmpl.doTemplate(gtb);
                }
                catch (IOException e) {
                    throw new ScriptRuntimeException(e);
                }
                smsMail.setMessage(sw.toString());
            }
            return smsMail;
        }
    }
}

