/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.validation;

import java.util.regex.Pattern;
import org.iplass.mtp.entity.BinaryReference;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.ValidationDefinition;
import org.iplass.mtp.entity.definition.validations.BinaryTypeValidation;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.util.ObjectUtil;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;

public class MetaValidationBinaryType
extends MetaValidation {
    private static final long serialVersionUID = 4585473131357405434L;
    private String acceptMimeTypesPattern;

    public String getAcceptMimeTypesPattern() {
        return this.acceptMimeTypesPattern;
    }

    public void setAcceptMimeTypesPattern(String acceptMimeTypesPattern) {
        this.acceptMimeTypesPattern = acceptMimeTypesPattern;
    }

    @Override
    public MetaValidationBinaryType copy() {
        return ObjectUtil.deepCopy(this);
    }

    @Override
    public ValidationHandler createRuntime(MetaEntity entity, MetaProperty property) {
        return new ValidationHandler(this){
            private Pattern compiledPattern;

            @Override
            public void init() {
                this.compiledPattern = Pattern.compile(MetaValidationBinaryType.this.acceptMimeTypesPattern);
            }

            @Override
            public boolean validate(Object value, ValidationContext context) {
                if (value == null) {
                    return true;
                }
                if (value instanceof BinaryReference) {
                    BinaryReference checkVal = (BinaryReference)value;
                    return this.compiledPattern.matcher(checkVal.getType()).matches();
                }
                throw new EntityRuntimeException("not support type:" + value.getClass());
            }
        };
    }

    @Override
    public BinaryTypeValidation currentConfig(EntityContext context) {
        BinaryTypeValidation def = new BinaryTypeValidation();
        this.fillTo(def);
        def.setAcceptMimeTypesPattern(this.acceptMimeTypesPattern);
        return def;
    }

    @Override
    public void applyConfig(ValidationDefinition definition) {
        this.fillFrom(definition);
        BinaryTypeValidation def = (BinaryTypeValidation)definition;
        this.acceptMimeTypesPattern = def.getAcceptMimeTypesPattern();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.acceptMimeTypesPattern == null ? 0 : this.acceptMimeTypesPattern.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaValidationBinaryType other = (MetaValidationBinaryType)obj;
        return !(this.acceptMimeTypesPattern == null ? other.acceptMimeTypesPattern != null : !this.acceptMimeTypesPattern.equals(other.acceptMimeTypesPattern));
    }
}

