DROP TABLE "T_ACCOUNT" CASCADE CONSTRAINT;
CREATE TABLE "T_ACCOUNT" 
(
    "TENANT_ID" NUMBER(7) NOT NULL,
    "ACCOUNT_ID" VARCHAR2(128 BYTE) NOT NULL, 
    "PASSWORD" VARCHAR2(128 BYTE) NOT NULL, 
    "SALT" VARCHAR2(64 BYTE), 
    "OID" VARCHAR2(128 BYTE) NOT NULL, 
    "LAST_LOGIN_ON" TIMESTAMP (3), 
    "LAST_PASSWORD_CHANGE" DATE, 
    "LOGIN_ERR_CNT" NUMBER(2,0) DEFAULT 0 NOT NULL, 
    "LOGIN_ERR_DATE" TIMESTAMP(6),
    "POL_NAME" VARCHAR2(128 BYTE),    
    "CRE_USER" VARCHAR2(64 BYTE), 
    "CRE_DATE" TIMESTAMP (3), 
    "UP_USER" VARCHAR2(64 BYTE), 
    "UP_DATE" TIMESTAMP (3), 
    CONSTRAINT "T_ACCOUNT_PK" PRIMARY KEY ("TENANT_ID", "ACCOUNT_ID") USING INDEX LOCAL,
    CONSTRAINT "T_ACCOUNT_UQ" UNIQUE ("TENANT_ID", "OID") USING INDEX LOCAL
)
PARTITION BY RANGE (TENANT_ID) INTERVAL(1)
(
    PARTITION T_ACCOUNT_0 VALUES LESS THAN (1)
)
; 
