/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.auth;

import java.util.function.Supplier;
import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.auth.AuthManager;
import org.iplass.mtp.auth.Permission;
import org.iplass.mtp.auth.User;
import org.iplass.mtp.auth.login.Credential;
import org.iplass.mtp.auth.token.AuthTokenInfoList;
import org.iplass.mtp.tenant.Tenant;

public abstract class AuthContext {
    private static AuthManager authManager = ManagerLocator.getInstance().getManager(AuthManager.class);

    public static AuthContext getCurrentContext() {
        return authManager.getContext();
    }

    public abstract Tenant getTenant();

    public abstract User getUser();

    public abstract AuthTokenInfoList getAuthTokenInfos();

    public abstract String getPolicyName();

    public abstract Object getAttribute(String var1);

    public abstract long getAuthTime();

    public abstract boolean isAuthenticated();

    public abstract boolean isCurrentSessionTrusted();

    public abstract Class<? extends Credential> getCredentialTypeForTrust();

    public abstract boolean userInRole(String var1);

    public abstract boolean checkPermission(Permission var1);

    public abstract void refresh();

    public abstract boolean isPrivileged();

    public static <T> T doPrivileged(Supplier<T> function) {
        return authManager.doPrivileged(function);
    }

    public static void doPrivileged(Runnable function) {
        authManager.doPrivileged(() -> {
            function.run();
            return null;
        });
    }
}

