/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.command.beanmapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.beanvalidation.BeanValidation;
import org.iplass.mtp.command.beanmapper.MappingError;
import org.iplass.mtp.command.beanmapper.MappingException;
import org.iplass.mtp.command.beanmapper.MappingResult;
import org.iplass.mtp.impl.command.beanmapper.el.ELMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanParamMapper {
    public static final char DEFAULT_PROPERTY_DELIMITER = '.';
    public static final char DEFAULT_INDEX_PREFIX = '[';
    public static final char DEFAULT_INDEX_POSTFIX = ']';
    public static final int DEFAULT_INDEXED_PROPERTY_SIZE_LIMIT = 128;
    private static Logger log = LoggerFactory.getLogger(BeanParamMapper.class);
    private char propertyDelimiter = (char)46;
    private char indexPrefix = (char)91;
    private char indexPostfix = (char)93;
    private int indexedPropertySizeLimit = 128;
    private String paramPrefix;
    private String whitelistPropertyNameRegex;
    private Pattern whitelistPropertyNameRegexPattern;
    private boolean trim;
    private boolean emptyToNull;
    private boolean withValidation;
    private boolean autoGrow;
    private Validator beanValidator = BeanValidation.getValidator();
    private Consumer<MappingError> typeConversionErrorHandler;
    private boolean validDelim = true;

    public BeanParamMapper withValidation() {
        this.setWithValidation(true);
        return this;
    }

    public BeanParamMapper enableAutoGrow() {
        this.setAutoGrow(true);
        return this;
    }

    public BeanParamMapper enableTrim() {
        this.setTrim(true);
        return this;
    }

    public BeanParamMapper enableEmptyToNull() {
        this.setEmptyToNull(true);
        return this;
    }

    private void checkDelim() {
        if (this.propertyDelimiter == this.indexPrefix) {
            this.validDelim = false;
            return;
        }
        if (this.indexPrefix == this.indexPostfix) {
            this.validDelim = false;
            return;
        }
        if (this.indexPostfix == this.propertyDelimiter) {
            this.validDelim = false;
            return;
        }
        this.validDelim = true;
    }

    public BeanParamMapper delimiters(char propertyDelimiter, char indexPrefix, char indexPostfix) {
        this.propertyDelimiter = propertyDelimiter;
        this.indexPrefix = indexPrefix;
        this.indexPostfix = indexPostfix;
        this.checkDelim();
        return this;
    }

    public BeanParamMapper paramPrefix(String paramPrefix) {
        this.paramPrefix = paramPrefix;
        return this;
    }

    public BeanParamMapper whitelistPropertyNameRegex(String whitelistPropertyNameRegex) {
        this.setWhitelistPropertyNameRegex(whitelistPropertyNameRegex);
        return this;
    }

    public BeanParamMapper indexedPropertySizeLimit(int indexedPropertySizeLimit) {
        this.setIndexedPropertySizeLimit(indexedPropertySizeLimit);
        return this;
    }

    public BeanParamMapper typeConversionError(Consumer<MappingError> typeConversionErrorHandler) {
        this.setTypeConversionErrorHandler(typeConversionErrorHandler);
        return this;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean isEmptyToNull() {
        return this.emptyToNull;
    }

    public void setEmptyToNull(boolean emptyToNull) {
        this.emptyToNull = emptyToNull;
    }

    public boolean isAutoGrow() {
        return this.autoGrow;
    }

    public void setAutoGrow(boolean autoGrow) {
        this.autoGrow = autoGrow;
    }

    public boolean getWithValidation() {
        return this.withValidation;
    }

    public void setWithValidation(boolean withValidation) {
        this.withValidation = withValidation;
    }

    public char getPropertyDelimiter() {
        return this.propertyDelimiter;
    }

    public void setPropertyDelimiter(char propertyDelimiter) {
        this.propertyDelimiter = propertyDelimiter;
        this.checkDelim();
    }

    public char getIndexPrefix() {
        return this.indexPrefix;
    }

    public void setIndexPrefix(char indexPrefix) {
        this.indexPrefix = indexPrefix;
        this.checkDelim();
    }

    public char getIndexPostfix() {
        return this.indexPostfix;
    }

    public void setIndexPostfix(char indexPostfix) {
        this.indexPostfix = indexPostfix;
        this.checkDelim();
    }

    public int getIndexedPropertySizeLimit() {
        return this.indexedPropertySizeLimit;
    }

    public void setIndexedPropertySizeLimit(int indexedPropertySizeLimit) {
        this.indexedPropertySizeLimit = indexedPropertySizeLimit;
    }

    public String getParamPrefix() {
        return this.paramPrefix;
    }

    public void setParamPrefix(String paramPrefix) {
        this.paramPrefix = paramPrefix;
    }

    public String getWhitelistPropertyNameRegex() {
        return this.whitelistPropertyNameRegex;
    }

    public void setWhitelistPropertyNameRegex(String whitelistPropertyNameRegex) {
        this.whitelistPropertyNameRegex = whitelistPropertyNameRegex;
        this.whitelistPropertyNameRegexPattern = whitelistPropertyNameRegex != null ? Pattern.compile(whitelistPropertyNameRegex) : null;
    }

    public Consumer<MappingError> getTypeConversionErrorHandler() {
        return this.typeConversionErrorHandler;
    }

    public void setTypeConversionErrorHandler(Consumer<MappingError> typeConversionErrorHandler) {
        this.typeConversionErrorHandler = typeConversionErrorHandler;
    }

    private String normPath(String path) {
        if (this.propertyDelimiter != '.') {
            path = path.replace(this.propertyDelimiter, '.');
        }
        if (this.indexPrefix != '[') {
            path = path.replace(this.indexPrefix, '[');
        }
        if (this.indexPostfix != ']') {
            path = path.replace(this.indexPostfix, ']');
        }
        return path;
    }

    public void populate(Object bean, Map<String, Object> params, Class<?> ... validationGroups) throws MappingException {
        if (!this.validDelim) {
            throw new SystemException("Delimiter setting invalid. Each delimiter must different char.");
        }
        if (bean == null || params == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("BeanParamMapper.populate(" + bean + ", " + params + ")");
        }
        MappingResult res = new MappingResult(bean);
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object name = entry.getKey();
            if (name == null) continue;
            if (this.paramPrefix != null) {
                if (!((String)name).startsWith(this.paramPrefix)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("no match paramPrefix :" + (String)name);
                    continue;
                }
                name = ((String)name).substring(this.paramPrefix.length());
            }
            if (this.whitelistPropertyNameRegexPattern != null && !this.whitelistPropertyNameRegexPattern.matcher((CharSequence)name).matches()) {
                if (!log.isTraceEnabled()) continue;
                log.trace("no match whitelistPropertyNameRegex :" + (String)name);
                continue;
            }
            name = this.normPath((String)name);
            valueMap.put((String)name, entry.getValue());
        }
        ELMapper beanMapper = new ELMapper();
        beanMapper.setTrim(this.trim);
        beanMapper.setEmptyToNull(this.emptyToNull);
        beanMapper.setAutoGrow(this.autoGrow);
        beanMapper.setIndexedPropertySizeLimit(this.indexedPropertySizeLimit);
        beanMapper.setTypeConversionErrorHandler(this.typeConversionErrorHandler);
        beanMapper.setTargetBean(bean);
        beanMapper.map(valueMap, res);
        if (this.withValidation) {
            Set violationSet;
            HashSet<String> typeConversionErrorProps = new HashSet<String>();
            if (res.hasError()) {
                for (MappingError me : res.getErrors()) {
                    typeConversionErrorProps.add(me.getPropertyPath());
                }
            }
            if ((violationSet = this.beanValidator.validate(bean, (Class[])validationGroups)) != null) {
                for (ConstraintViolation cv : violationSet) {
                    String path = cv.getPropertyPath().toString();
                    if (typeConversionErrorProps.contains(path)) continue;
                    MappingError preError = res.getError(path);
                    if (preError == null) {
                        res.addError(new MappingError(path, cv.getMessage(), cv.getInvalidValue(), (Object)cv));
                        continue;
                    }
                    preError.addMessage(cv.getMessage(), cv);
                }
            }
        }
        if (res.hasError()) {
            if (log.isDebugEnabled()) {
                for (MappingError err : res.getErrors()) {
                    log.debug("mapping fail: property=" + err.getPropertyPath() + ", message=" + err.getErrorMessages() + ", value=" + err.getErrorValue() + ", cause=" + err.getCause(), err.getCause());
                }
            }
            throw new MappingException("mapping failed", res);
        }
    }

    public void validate(Object bean, Class<?> ... validationGroups) throws MappingException {
        MappingResult res = new MappingResult(bean);
        Set violationSet = this.beanValidator.validate(bean, (Class[])validationGroups);
        if (violationSet != null) {
            for (ConstraintViolation cv : violationSet) {
                String path = cv.getPropertyPath().toString();
                MappingError preError = res.getError(path);
                if (preError == null) {
                    res.addError(new MappingError(path, cv.getMessage(), cv.getInvalidValue(), (Object)cv));
                    continue;
                }
                preError.addMessage(cv.getMessage(), cv);
            }
        }
        if (res.hasError()) {
            throw new MappingException("validation failed", res);
        }
    }
}

