/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.definition.properties;

import java.util.ArrayList;
import java.util.List;
import org.iplass.adminconsole.annotation.MultiLang;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.definition.LocalizedSelectValueDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.definition.properties.selectvalue.SelectValueDefinition;

public class SelectProperty
extends PropertyDefinition {
    private static final long serialVersionUID = 3614342763254943340L;
    private String selectValueDefinitionName;
    @MultiLang(isMultiLangValue=false, itemKey="selectValue", itemGetter="getSelectValueList", itemSetter="setSelectValueList", multiLangGetter="getLocalizedSelectValueList", multiLangSetter="setLocalizedSelectValueList", isSelectValue=true)
    private List<SelectValue> selectValueList;
    private List<LocalizedSelectValueDefinition> localizedSelectValueList;

    public SelectProperty() {
    }

    public SelectProperty(String name) {
        this.setName(name);
    }

    public SelectProperty(String name, SelectValue ... value) {
        this.setName(name);
        if (value != null) {
            for (SelectValue v : value) {
                this.addSelectValue(v);
            }
        }
    }

    public SelectProperty(SelectValueDefinition selectValueDefinition, boolean deepCopy) {
        this.applySelectValueDefinition(selectValueDefinition, deepCopy);
    }

    public SelectValue getSelectValue(String value) {
        if (this.selectValueList != null) {
            for (SelectValue s : this.selectValueList) {
                if (!value.equals(s.getValue())) continue;
                return s;
            }
        }
        return null;
    }

    public SelectValue getLocalizedSelectValue(String value, String locale) {
        if (this.localizedSelectValueList != null) {
            for (LocalizedSelectValueDefinition ls : this.localizedSelectValueList) {
                if (!locale.equals(ls.getLocaleName())) continue;
                SelectValue s = ls.getSelectValue(value);
                if (s == null) break;
                return s;
            }
        }
        return this.getSelectValue(value);
    }

    public void applySelectValueDefinition(SelectValueDefinition selectValueDefinition, boolean deepCopy) {
        this.selectValueDefinitionName = selectValueDefinition.getName();
        if (selectValueDefinition.getSelectValueList() != null) {
            if (deepCopy) {
                this.selectValueList = new ArrayList<SelectValue>(selectValueDefinition.getSelectValueList().size());
                for (SelectValue sv : selectValueDefinition.getSelectValueList()) {
                    this.selectValueList.add(sv.copy());
                }
            } else {
                this.selectValueList = selectValueDefinition.getSelectValueList();
            }
        }
        if (selectValueDefinition.getLocalizedSelectValueList() != null) {
            if (deepCopy) {
                this.localizedSelectValueList = new ArrayList<LocalizedSelectValueDefinition>(selectValueDefinition.getLocalizedSelectValueList().size());
                for (LocalizedSelectValueDefinition lsvd : selectValueDefinition.getLocalizedSelectValueList()) {
                    LocalizedSelectValueDefinition copyLsvd = new LocalizedSelectValueDefinition();
                    copyLsvd.setLocaleName(lsvd.getLocaleName());
                    if (lsvd.getSelectValueList() != null) {
                        ArrayList<SelectValue> copyLsvl = new ArrayList<SelectValue>(lsvd.getSelectValueList());
                        for (SelectValue sv : lsvd.getSelectValueList()) {
                            copyLsvl.add(sv.copy());
                        }
                        copyLsvd.setSelectValueList(copyLsvl);
                    }
                    this.localizedSelectValueList.add(copyLsvd);
                }
            } else {
                this.localizedSelectValueList = selectValueDefinition.getLocalizedSelectValueList();
            }
        }
    }

    public String getSelectValueDefinitionName() {
        return this.selectValueDefinitionName;
    }

    public void setSelectValueDefinitionName(String selectValueDefinitionName) {
        this.selectValueDefinitionName = selectValueDefinitionName;
    }

    public void addSelectValue(SelectValue value) {
        if (this.selectValueList == null) {
            this.selectValueList = new ArrayList<SelectValue>();
        }
        this.selectValueList.add(value);
    }

    public List<SelectValue> getSelectValueList() {
        return this.selectValueList;
    }

    public void setSelectValueList(List<SelectValue> selectValueList) {
        this.selectValueList = selectValueList;
    }

    public void addLocalizedSelectValue(LocalizedSelectValueDefinition localizedSelectValue) {
        if (this.localizedSelectValueList == null) {
            this.localizedSelectValueList = new ArrayList<LocalizedSelectValueDefinition>();
        }
        this.localizedSelectValueList.add(localizedSelectValue);
    }

    public List<LocalizedSelectValueDefinition> getLocalizedSelectValueList() {
        return this.localizedSelectValueList;
    }

    public void setLocalizedSelectValueList(List<LocalizedSelectValueDefinition> localizedSelectValueList) {
        this.localizedSelectValueList = localizedSelectValueList;
    }

    @Override
    public Class<?> getJavaType() {
        return SelectValue.class;
    }

    @Override
    public PropertyDefinitionType getType() {
        return PropertyDefinitionType.SELECT;
    }
}

