/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.entity.query.value.window;

import java.util.ArrayList;
import java.util.List;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformer;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.ValueExpressionVisitor;
import org.iplass.mtp.entity.query.value.primary.EntityField;

public class PartitionBy
implements ASTNode {
    private static final long serialVersionUID = 8515685165315099514L;
    private List<ValueExpression> partitionFieldList = new ArrayList<ValueExpression>();

    public List<ValueExpression> getPartitionFieldList() {
        return this.partitionFieldList;
    }

    public void setPartitionFieldList(List<ValueExpression> partitionFieldList) {
        this.partitionFieldList = partitionFieldList;
    }

    @Override
    public ASTNode accept(ASTTransformer transformer) {
        return transformer.visit(this);
    }

    public void accept(ValueExpressionVisitor visitor) {
        if (visitor.visit(this) && this.partitionFieldList != null) {
            for (ValueExpression s : this.partitionFieldList) {
                s.accept(visitor);
            }
        }
    }

    public PartitionBy add(ValueExpression partitionField) {
        if (partitionField == null) {
            throw new NullPointerException("partitionField is null");
        }
        if (this.partitionFieldList == null) {
            this.partitionFieldList = new ArrayList<ValueExpression>();
        }
        this.partitionFieldList.add(partitionField);
        return this;
    }

    public PartitionBy add(Object partitionField) {
        if (partitionField == null) {
            throw new NullPointerException("partitionField is null");
        }
        if (this.partitionFieldList == null) {
            this.partitionFieldList = new ArrayList<ValueExpression>();
        }
        ValueExpression v = null;
        if (partitionField instanceof ValueExpression) {
            v = (ValueExpression)partitionField;
        } else if (partitionField instanceof String) {
            v = new EntityField((String)partitionField);
        } else {
            throw new QueryException("partitionField is ValueExpression or String type required.");
        }
        return this.add(v);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("partition by ");
        if (this.partitionFieldList != null) {
            for (int i = 0; i < this.partitionFieldList.size(); ++i) {
                if (i != 0) {
                    sb.append(",");
                }
                sb.append(this.partitionFieldList.get(i));
            }
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.partitionFieldList == null ? 0 : this.partitionFieldList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PartitionBy other = (PartitionBy)obj;
        return !(this.partitionFieldList == null ? other.partitionFieldList != null : !this.partitionFieldList.equals(other.partitionFieldList));
    }
}

