/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.async.rdb.workers;

import java.util.concurrent.Callable;
import org.iplass.mtp.async.ExceptionHandlingMode;
import org.iplass.mtp.impl.async.AsyncTaskContextImpl;
import org.iplass.mtp.impl.async.ExceptionHandleable;
import org.iplass.mtp.impl.async.rdb.Queue;
import org.iplass.mtp.impl.async.rdb.Task;
import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.core.Executable;
import org.iplass.mtp.impl.core.ExecuteContext;
import org.iplass.mtp.impl.core.TenantContext;
import org.iplass.mtp.impl.core.TenantContextService;
import org.iplass.mtp.impl.rdb.connection.ResourceHolder;
import org.iplass.mtp.spi.ServiceRegistry;
import org.iplass.mtp.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class WorkerCallable
implements Callable<Void> {
    private static Logger logger = LoggerFactory.getLogger(WorkerCallable.class);
    private static Logger mtpLogger = LoggerFactory.getLogger((String)"mtp.async.rdb");
    private static Logger fatalLogger = LoggerFactory.getLogger((String)"mtp.fatal.async.rdb");
    private final Task task;
    private final Queue queue;
    private final boolean trace;
    private final boolean initRH;

    public WorkerCallable(Task task, Queue queue, boolean trace, boolean initRH) {
        this.task = task;
        this.queue = queue;
        this.trace = trace;
        this.initRH = initRH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() throws Exception {
        try {
            MDC.put((String)"taskId", (String)String.valueOf(this.task.getTaskId()));
            if (this.initRH) {
                ResourceHolder.init();
            }
            final AsyncTaskContextImpl asyncTaskContext = new AsyncTaskContextImpl(this.task.getTaskId(), this.queue.getName());
            TenantContext tc = ServiceRegistry.getRegistry().getService(TenantContextService.class).getTenantContext(this.task.getTenantId());
            Void void_ = ExecuteContext.executeAs(tc, new Executable<Void>(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                @Override
                public Void execute() {
                    try {
                        ExecuteContext.getCurrentContext().setAttribute("mtp.async.AsyncTaskContext", asyncTaskContext, false);
                        if (WorkerCallable.this.task.getCallable().getUserContext() != null) {
                            AuthService as = ServiceRegistry.getRegistry().getService(AuthService.class);
                            as.doSecuredAction(WorkerCallable.this.task.getCallable().getUserContext(), () -> {
                                WorkerCallable.this.callImpl();
                                return null;
                            });
                            return null;
                        }
                        WorkerCallable.this.callImpl();
                        return null;
                    }
                    catch (Error | RuntimeException e) {
                        switch (WorkerCallable.this.task.getExceptionHandlingMode()) {
                            case RESTART: {
                                if (WorkerCallable.this.task.getRetryCount() >= WorkerCallable.this.queue.getConfig().getWorker().getMaxRetryCount()) {
                                    fatalLogger.error("queue:" + WorkerCallable.this.queue.getConfig().getName() + "'s task:" + WorkerCallable.this.task.getTaskId() + "(tenantId:" + WorkerCallable.this.task.getTenantId() + ") is failed. max retry count over.", e);
                                    return null;
                                }
                                mtpLogger.warn("queue:" + WorkerCallable.this.queue.getConfig().getName() + "'s task:" + WorkerCallable.this.task.getTaskId() + "(tenantId:" + WorkerCallable.this.task.getTenantId() + ") is failed(cause:" + e + "). re-run after a while.");
                                return null;
                            }
                            case ABORT_LOG_FATAL: 
                            case ABORT: {
                                Transaction.required(transaction -> {
                                    Throwable t = e instanceof WrapException ? e.getCause() : e;
                                    if (WorkerCallable.this.queue.taskAbort(WorkerCallable.this.task, true, t, false, false)) {
                                        if (WorkerCallable.this.task.getCallable().getActual() instanceof ExceptionHandleable) {
                                            try {
                                                ((ExceptionHandleable)((Object)WorkerCallable.this.task.getCallable().getActual())).aborted(t);
                                            }
                                            catch (Throwable ee) {
                                                fatalLogger.error("ExceptionHandleable's aborted() call failed(queue:" + WorkerCallable.this.queue.getConfig().getName() + ", task:" + WorkerCallable.this.task.getTaskId() + ",tenantId:" + WorkerCallable.this.task.getTenantId() + ")", ee);
                                                transaction.setRollbackOnly();
                                            }
                                        }
                                    } else {
                                        logger.warn("task status cant update to [abort].may be another process update status." + WorkerCallable.this.task);
                                    }
                                });
                                return null;
                            }
                        }
                        return null;
                    }
                    finally {
                        ExecuteContext.getCurrentContext().removeAttribute("mtp.async.AsyncTaskContext");
                    }
                }
            });
            return void_;
        }
        finally {
            if (this.initRH) {
                ResourceHolder.fin();
            }
            MDC.remove((String)"taskId");
        }
    }

    private void callImpl() {
        Transaction.required(transaction -> {
            long start = -1L;
            if (this.trace) {
                start = System.currentTimeMillis();
            }
            Throwable t = null;
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug("execute " + this.task);
                }
                Object res = this.task.getCallable().getActual().call();
                if (this.task.isReturnResult()) {
                    this.task.setResult(res);
                }
                this.queue.taskFinish(this.task);
                Object var6_7 = null;
                return var6_7;
            }
            catch (Error | RuntimeException e) {
                transaction.setRollbackOnly();
                t = e;
                throw e;
            }
            catch (Exception e) {
                transaction.setRollbackOnly();
                t = e;
                throw new WrapException(e);
            }
            finally {
                if (t != null) {
                    if (this.trace) {
                        mtpLogger.error(this.task.getCallable().toString() + "(id=" + this.task.getTaskId() + ")," + this.queue.getName() + "," + (System.currentTimeMillis() - start) + "ms,Error," + t.getMessage(), t);
                    } else {
                        mtpLogger.error(this.task.getCallable().toString() + "(id=" + this.task.getTaskId() + ")," + this.queue.getName() + ",Error," + t.getMessage(), t);
                    }
                    if (t instanceof Error || this.task.getExceptionHandlingMode() == ExceptionHandlingMode.ABORT_LOG_FATAL) {
                        fatalLogger.error("queue:" + this.queue.getConfig().getName() + "'s task:" + this.task.getTaskId() + "(tenantId:" + this.task.getTenantId() + ") fatal error.", t);
                    }
                } else if (this.trace) {
                    mtpLogger.info(this.task.getCallable().toString() + "(id=" + this.task.getTaskId() + ")," + this.queue.getName() + "," + (System.currentTimeMillis() - start) + "ms");
                }
            }
        });
    }

    private static class WrapException
    extends RuntimeException {
        private static final long serialVersionUID = 1513733395068136003L;

        public WrapException(Throwable cause) {
            super(cause);
        }
    }
}

