/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authenticate.trust;

import org.iplass.mtp.impl.auth.AuthService;
import org.iplass.mtp.impl.auth.UserContext;
import org.iplass.mtp.impl.auth.authenticate.AccountHandle;
import org.iplass.mtp.impl.auth.authenticate.AuthenticationProvider;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidateResult;
import org.iplass.mtp.impl.auth.authenticate.trust.TrustedAuthValidator;

public class DefaultTrustedAuthValidator
implements TrustedAuthValidator {
    private String accountHandleClass;
    private String requiredCredentialClass;

    public DefaultTrustedAuthValidator(String accountHandleClass, String requiredCredentialClass) {
        this.accountHandleClass = accountHandleClass;
        this.requiredCredentialClass = requiredCredentialClass;
    }

    public String getRequiredCredentialClass() {
        return this.requiredCredentialClass;
    }

    public void setRequiredCredentialClass(String requiredCredentialClass) {
        this.requiredCredentialClass = requiredCredentialClass;
    }

    public String getAccountHandleClass() {
        return this.accountHandleClass;
    }

    public void setAccountHandleClass(String accountHandleClass) {
        this.accountHandleClass = accountHandleClass;
    }

    @Override
    public TrustedAuthValidateResult checkTrusted(UserContext userContext) {
        AccountHandle account = userContext.getAccount();
        if (account.getClass().getName().equals(this.accountHandleClass)) {
            return new TrustedAuthValidateResult(true, null);
        }
        try {
            return new TrustedAuthValidateResult(false, Class.forName(this.requiredCredentialClass));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(this.requiredCredentialClass + " cant resolve:" + e, e);
        }
    }

    @Override
    public void inited(AuthService service, AuthenticationProvider provider) {
    }
}

