/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.group;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;

public class GroupContext
implements Comparable<GroupContext> {
    private String oid;
    private String groupCode;
    private String parentGroupCode;
    private String[] childGroupCodes;
    private TenantAuthorizeContext authContext;

    public GroupContext(String oid, String groupCode, String parentGroupCode, String[] childGroupCodes, TenantAuthorizeContext authContext) {
        this.oid = oid;
        this.groupCode = groupCode;
        this.parentGroupCode = parentGroupCode;
        this.childGroupCodes = childGroupCodes;
        this.authContext = authContext;
    }

    public String getOid() {
        return this.oid;
    }

    public String getGroupCode() {
        return this.groupCode;
    }

    public String getParentGroupCode() {
        return this.parentGroupCode;
    }

    public boolean isRoot() {
        return this.parentGroupCode == null;
    }

    public List<GroupContext> getAllNestedChildGroup() {
        ArrayList<GroupContext> groups = new ArrayList<GroupContext>();
        this.addGroupCascadeChild(groups);
        return groups;
    }

    private void addGroupCascadeChild(List<GroupContext> groups) {
        groups.add(this);
        if (this.childGroupCodes != null) {
            for (String cgc : this.childGroupCodes) {
                GroupContext child = this.authContext.getGroupContext(cgc);
                if (child == null) continue;
                child.addGroupCascadeChild(groups);
            }
        }
    }

    public List<GroupContext> getGroupPath() {
        LinkedList<GroupContext> path = new LinkedList<GroupContext>();
        this.addPath(path);
        return path;
    }

    private void addPath(LinkedList<GroupContext> path) {
        GroupContext parent;
        if (this.parentGroupCode != null && (parent = this.authContext.getGroupContext(this.parentGroupCode)) != null) {
            parent.addPath(path);
        }
        path.add(this);
    }

    @Override
    public int compareTo(GroupContext o) {
        return this.oid.compareTo(o.oid);
    }
}

