/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.auth.authorize.builtin.group;

import org.iplass.mtp.ManagerLocator;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.EntityManager;
import org.iplass.mtp.impl.auth.authorize.builtin.TenantAuthorizeContext;
import org.iplass.mtp.impl.auth.authorize.builtin.group.GroupContext;
import org.iplass.mtp.impl.core.ExecuteContext;

public class GroupEntityEventListener
implements EntityEventListener {
    @Override
    public boolean beforeDelete(Entity entity, EntityEventContext context) {
        Entity before = ManagerLocator.getInstance().getManager(EntityManager.class).load(entity.getOid(), entity.getDefinitionName());
        if (before != null && before.getValue("code") != null) {
            GroupContext beforeGroupContext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).getGroupContext((String)before.getValue("code"));
            context.setAttribute("groupContextForDel", beforeGroupContext);
        }
        return true;
    }

    @Override
    public void afterDelete(Entity entity, EntityEventContext context) {
        GroupContext beforeGroupContext = (GroupContext)context.getAttribute("groupContextForDel");
        if (beforeGroupContext != null) {
            TenantAuthorizeContext authCotnext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
            authCotnext.notifyGroupDelete(beforeGroupContext.getGroupCode(), beforeGroupContext);
            if (beforeGroupContext.getParentGroupCode() != null) {
                authCotnext.notifyGroupUpdate(beforeGroupContext.getParentGroupCode());
            }
        }
    }

    @Override
    public void afterInsert(Entity entity, EntityEventContext context) {
        TenantAuthorizeContext authCotnext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
        String groupCode = (String)entity.getValue("code");
        authCotnext.notifyGroupCreate(groupCode);
        GroupContext created = authCotnext.getGroupContext(groupCode);
        if (created.getParentGroupCode() != null) {
            authCotnext.notifyGroupUpdate(created.getParentGroupCode());
        }
    }

    @Override
    public boolean beforeUpdate(Entity entity, EntityEventContext context) {
        Entity before = ManagerLocator.getInstance().getManager(EntityManager.class).load(entity.getOid(), entity.getDefinitionName());
        if (before != null && before.getValue("code") != null) {
            GroupContext beforeGroupContext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class).getGroupContext((String)before.getValue("code"));
            context.setAttribute("groupContextForUpdate", beforeGroupContext);
        }
        return true;
    }

    @Override
    public void afterUpdate(Entity entity, EntityEventContext context) {
        GroupContext beforeGroupContext = (GroupContext)context.getAttribute("groupContextForUpdate");
        TenantAuthorizeContext tAuth = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
        String newGroupCode = (String)entity.getValue("code");
        if (beforeGroupContext != null && !beforeGroupContext.getGroupCode().equals(newGroupCode)) {
            tAuth.notifyGroupDelete(beforeGroupContext.getGroupCode(), beforeGroupContext);
        }
        tAuth.notifyGroupUpdate(newGroupCode);
        GroupContext updated = tAuth.getGroupContext(newGroupCode);
        if (beforeGroupContext != null && beforeGroupContext.getParentGroupCode() != null && !beforeGroupContext.getParentGroupCode().equals(updated.getParentGroupCode())) {
            tAuth.notifyGroupUpdate(beforeGroupContext.getParentGroupCode());
        }
        if (updated.getParentGroupCode() != null) {
            tAuth.notifyGroupUpdate(updated.getParentGroupCode());
        }
    }

    @Override
    public void afterRestore(Entity entity) {
        TenantAuthorizeContext authCotnext = ExecuteContext.getCurrentContext().getTenantContext().getResource(TenantAuthorizeContext.class);
        String groupCode = (String)entity.getValue("code");
        authCotnext.notifyGroupCreate(groupCode);
        GroupContext created = authCotnext.getGroupContext(groupCode);
        if (created.getParentGroupCode() != null) {
            authCotnext.notifyGroupUpdate(created.getParentGroupCode());
        }
    }
}

