/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.iplass.mtp.SystemException;
import org.iplass.mtp.impl.cache.CacheService;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.AbstractBuiltinCacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.NullKey;
import org.iplass.mtp.impl.cache.store.builtin.SimpleLocalCacheHandler;
import org.iplass.mtp.impl.cache.store.event.CacheCreateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheInvalidateEvent;
import org.iplass.mtp.impl.cache.store.event.CacheRemoveEvent;
import org.iplass.mtp.impl.cache.store.event.CacheUpdateEvent;
import org.iplass.mtp.impl.cache.store.keyresolver.CacheKeyResolver;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapterService;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdbCacheStoreFactory
extends AbstractBuiltinCacheStoreFactory {
    private static final String DEFAULT_TABLE_NAME = "CACHE_STORE";
    private static final String NAMESPACE = "NS";
    private static final String KEY = "C_KEY";
    private static final String INDEX = "CI_";
    private static final String VAL = "C_VAL";
    private static final String VER = "VER";
    private static final String CRE_TIME = "CRE_TIME";
    private static final String INVALID_TIME = "INV_TIME";
    private static final Logger logger = LoggerFactory.getLogger(RdbCacheStoreFactory.class);
    private CacheKeyResolver cacheKeyResolver;
    private List<CacheKeyResolver> cacheIndexResolver;
    private String connectionFactoryName;
    private String rdbArapterName;
    private String tableName = "CACHE_STORE";
    private int retryCount;
    private long timeToLive = -1L;

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setConnectionFactoryName(String connectionFactoryName) {
        this.connectionFactoryName = connectionFactoryName;
    }

    public String getRdbArapterName() {
        return this.rdbArapterName;
    }

    public void setRdbArapterName(String rdbArapterName) {
        this.rdbArapterName = rdbArapterName;
    }

    public CacheKeyResolver getCacheKeyResolver() {
        return this.cacheKeyResolver;
    }

    public void setCacheKeyResolver(CacheKeyResolver cacheKeyResolver) {
        this.cacheKeyResolver = cacheKeyResolver;
    }

    public List<CacheKeyResolver> getCacheIndexResolver() {
        return this.cacheIndexResolver;
    }

    public void setCacheIndexResolver(List<CacheKeyResolver> cacheIndexResolver) {
        this.cacheIndexResolver = cacheIndexResolver;
    }

    @Override
    public CacheStore createCacheStore(String namespace) {
        return new RdbCacheStore(namespace);
    }

    @Override
    public boolean canUseForLocalCache() {
        return false;
    }

    @Override
    public boolean supportsIndex() {
        return true;
    }

    @Override
    public CacheHandler createCacheHandler(CacheStore store) {
        return new SimpleLocalCacheHandler(store, this.getConcurrencyLevelOfCacheHandler());
    }

    public static void deleteInvalidRecord() {
        CacheService cs = ServiceRegistry.getRegistry().getService(CacheService.class);
        List<CacheStoreFactory> list = cs.getFactories();
        HashSet<Target> tlist = new HashSet<Target>();
        Iterator<CacheStoreFactory> iterator = list.iterator();
        while (iterator.hasNext()) {
            CacheStoreFactory csf;
            CacheStoreFactory target = csf = iterator.next();
            while (target.getLowerLevel() != null) {
                target = target.getLowerLevel();
            }
            if (!(target instanceof RdbCacheStoreFactory)) continue;
            RdbCacheStoreFactory t = (RdbCacheStoreFactory)target;
            tlist.add(new Target(t.connectionFactoryName, t.rdbArapterName, t.tableName));
        }
        RdbAdapterService ras = ServiceRegistry.getRegistry().getService(RdbAdapterService.class);
        if (tlist.size() > 0) {
            for (Target t : tlist) {
                if (logger.isDebugEnabled()) {
                    logger.debug("delete invalid cache record of " + t);
                }
                RdbAdapter rdb = ras.getRdbAdapter(t.rdbArapterName);
                try {
                    Connection con = rdb.getConnection(t.connectionFactoryName);
                    Throwable throwable = null;
                    try {
                        String sql = RdbCacheStoreFactory.delInvalidSql(t.tableName);
                        Statement stmt = con.createStatement();
                        Throwable throwable2 = null;
                        try {
                            stmt.executeUpdate(sql);
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (stmt == null) continue;
                            if (throwable2 != null) {
                                try {
                                    stmt.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            stmt.close();
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                    finally {
                        if (con == null) continue;
                        if (throwable != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            continue;
                        }
                        con.close();
                    }
                }
                catch (SQLException e) {
                    throw new SystemException(e);
                }
            }
        }
    }

    private static String delInvalidSql(String tableName) {
        return "DELETE FROM " + tableName + " WHERE " + INVALID_TIME + "<=" + System.currentTimeMillis();
    }

    @Override
    public CacheStoreFactory getLowerLevel() {
        return null;
    }

    public class RdbCacheStore
    implements CacheStore {
        private String namespace;
        private List<CacheEventListener> listeners;
        private RdbAdapter rdb;
        private String getSql;
        private String getSqlWithCheckInvalidDate;
        private String delSql;
        private String delSqlWithVersionCheck;
        private String updateSql;
        private String updateSqlWithVersionCheck;
        private String insertSql;
        private String delAllSql;
        private String keySetSql;

        RdbCacheStore(String namespace) {
            this.delSql = "DELETE FROM " + RdbCacheStoreFactory.this.tableName + " WHERE " + RdbCacheStoreFactory.NAMESPACE + "=? AND " + RdbCacheStoreFactory.KEY + "=?";
            this.delSqlWithVersionCheck = "DELETE FROM " + RdbCacheStoreFactory.this.tableName + " WHERE " + RdbCacheStoreFactory.NAMESPACE + "=? AND " + RdbCacheStoreFactory.KEY + "=? AND " + RdbCacheStoreFactory.VER + "=?";
            this.delAllSql = "DELETE FROM " + RdbCacheStoreFactory.this.tableName + " WHERE " + RdbCacheStoreFactory.NAMESPACE + "=?";
            this.keySetSql = "SELECT C_KEY,CRE_TIME FROM " + RdbCacheStoreFactory.this.tableName + " WHERE " + RdbCacheStoreFactory.NAMESPACE + "=? AND " + RdbCacheStoreFactory.INVALID_TIME + ">?";
            this.namespace = namespace;
            this.listeners = new CopyOnWriteArrayList<CacheEventListener>();
            this.rdb = ServiceRegistry.getRegistry().getService(RdbAdapterService.class).getRdbAdapter(RdbCacheStoreFactory.this.rdbArapterName);
            this.getSql = this.getSql(false);
            this.getSqlWithCheckInvalidDate = this.getSql(true);
            this.updateSql = this.updateSql(false);
            this.updateSqlWithVersionCheck = this.updateSql(true);
            this.insertSql = this.insertSql();
        }

        private String getSql(boolean checkInvalidDate) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT C_VAL,VER,CRE_TIME");
            if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                for (int i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                    sql.append(",CI_");
                    sql.append(i);
                }
            }
            sql.append(" FROM ").append(RdbCacheStoreFactory.this.tableName);
            sql.append(" WHERE NS=? AND C_KEY=?");
            if (checkInvalidDate) {
                sql.append(" AND INV_TIME>?");
            }
            return sql.toString();
        }

        private String getByIndexSql(int indexKey) {
            StringBuilder sql = new StringBuilder();
            sql.append("SELECT C_KEY,C_VAL,VER,CRE_TIME");
            if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                for (int i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                    sql.append(",CI_");
                    sql.append(i);
                }
            }
            sql.append(" FROM ").append(RdbCacheStoreFactory.this.tableName);
            sql.append(" WHERE NS=? AND CI_" + indexKey + "=? AND " + RdbCacheStoreFactory.INVALID_TIME + ">?");
            return sql.toString();
        }

        private String updateSql(boolean withVersionCheck) {
            StringBuilder sql = new StringBuilder();
            sql.append("UPDATE ").append(RdbCacheStoreFactory.this.tableName);
            sql.append(" SET ");
            sql.append("C_VAL=?,VER=?,CRE_TIME=?,INV_TIME=?");
            if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                for (int i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                    sql.append(",CI_");
                    sql.append(i);
                    sql.append("=?");
                }
            }
            sql.append(" WHERE NS=? AND C_KEY=?");
            if (withVersionCheck) {
                sql.append(" AND VER=?");
            }
            return sql.toString();
        }

        private String insertSql() {
            int i;
            StringBuilder sql = new StringBuilder();
            sql.append("INSERT INTO ").append(RdbCacheStoreFactory.this.tableName);
            sql.append("(NS,C_KEY,C_VAL,VER,CRE_TIME,INV_TIME");
            if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                for (i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                    sql.append(",CI_");
                    sql.append(i);
                }
            }
            sql.append(") VALUES(?,?,?,?,?,?");
            if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                for (i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                    sql.append(",?");
                }
            }
            sql.append(")");
            return sql.toString();
        }

        @Override
        public CacheStoreFactory getFactory() {
            return RdbCacheStoreFactory.this;
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        protected void notifyRemoved(CacheEntry entry) {
            if (this.listeners != null) {
                CacheRemoveEvent e = new CacheRemoveEvent(entry);
                for (CacheEventListener l : this.listeners) {
                    l.removed(e);
                }
            }
        }

        protected void notifyPut(CacheEntry entry) {
            if (this.listeners != null) {
                CacheCreateEvent e = new CacheCreateEvent(entry);
                for (CacheEventListener l : this.listeners) {
                    l.created(e);
                }
            }
        }

        protected void notifyUpdated(CacheEntry preEntry, CacheEntry entry) {
            if (this.listeners != null) {
                CacheUpdateEvent e = new CacheUpdateEvent(preEntry, entry);
                for (CacheEventListener l : this.listeners) {
                    l.updated(e);
                }
            }
        }

        protected void notifyInvalidated(CacheEntry entry) {
            if (this.listeners != null) {
                CacheInvalidateEvent e = new CacheInvalidateEvent(entry);
                for (CacheEventListener l : this.listeners) {
                    l.invalidated(e);
                }
            }
        }

        @Override
        public void addCacheEventListenner(CacheEventListener listener) {
            this.listeners.add(listener);
        }

        @Override
        public void removeCacheEventListenner(CacheEventListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public List<CacheEventListener> getListeners() {
            return this.listeners;
        }

        private boolean isStillAliveOrNull(CacheEntry e) {
            if (e == null) {
                return true;
            }
            return this.isStillAlive(e.getCreationTime());
        }

        private boolean isStillAlive(long createTime) {
            if (RdbCacheStoreFactory.this.getTimeToLive() <= 0L) {
                return true;
            }
            return System.currentTimeMillis() - createTime <= RdbCacheStoreFactory.this.getTimeToLive();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CacheEntry put(CacheEntry entry, boolean clean) {
            int count = 0;
            while (count <= RdbCacheStoreFactory.this.retryCount) {
                block28: {
                    try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                        CacheEntry pre = this.getInternal(entry.getKey(), false, con);
                        if (pre == null) {
                            if (this.insertInternal(entry, con)) {
                                this.notifyPut(entry);
                                CacheEntry cacheEntry = pre;
                                return cacheEntry;
                            }
                        } else if (this.updateInternal(entry, true, pre.getVersion(), con)) {
                            if (this.isStillAliveOrNull(pre)) {
                                this.notifyUpdated(pre, entry);
                                CacheEntry cacheEntry = pre;
                                return cacheEntry;
                            }
                            this.notifyPut(entry);
                            CacheEntry cacheEntry = null;
                            return cacheEntry;
                        }
                    }
                    catch (SQLException e) {
                        if (this.rdb.isDuplicateValueException(e)) break block28;
                        throw new SystemException("cant put CacheEntry to RDB:" + entry, e);
                    }
                }
                ++count;
            }
            throw new SystemException("cant put CacheEntry cause retry count over:" + entry);
        }

        /*
         * Exception decompiling
         */
        private CacheEntry getInternal(Object key, boolean checkInvalidDate, Connection con) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private byte[] toBytes(Object val) {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            try {
                ObjectOutputStream out = new ObjectOutputStream(byteOut);
                out.writeObject(val);
            }
            catch (IOException e) {
                throw new SystemException(e);
            }
            return byteOut.toByteArray();
        }

        private boolean updateInternal(CacheEntry entry, boolean checkVersion, long preVersion, Connection con) throws SQLException {
            String sql = checkVersion ? this.updateSqlWithVersionCheck : this.updateSql;
            try (PreparedStatement ps = con.prepareStatement(sql);){
                int ret;
                if (entry.getValue() == null) {
                    ps.setNull(1, 2004);
                } else {
                    ps.setBytes(1, this.toBytes(entry.getValue()));
                }
                ps.setLong(2, entry.getVersion());
                ps.setLong(3, entry.getCreationTime());
                ps.setLong(4, this.invalidTime(entry.getCreationTime()));
                int cnt = 4;
                if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                    for (int i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                        Object ival = entry.getIndexValue(i);
                        ++cnt;
                        if (ival == null) {
                            ps.setNull(cnt, 12);
                            continue;
                        }
                        ps.setString(cnt, ((CacheKeyResolver)RdbCacheStoreFactory.this.cacheIndexResolver.get(i)).toString(ival));
                    }
                }
                ps.setString(++cnt, this.getNamespace());
                ++cnt;
                if (entry.getKey() instanceof NullKey) {
                    ps.setString(cnt, entry.getKey().toString());
                } else {
                    ps.setString(cnt, RdbCacheStoreFactory.this.cacheKeyResolver.toString(entry.getKey()));
                }
                if (checkVersion) {
                    ps.setLong(++cnt, preVersion);
                }
                if ((ret = ps.executeUpdate()) > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        private long invalidTime(long creationTime) {
            if (RdbCacheStoreFactory.this.timeToLive <= 0L) {
                return Long.MAX_VALUE;
            }
            return creationTime + RdbCacheStoreFactory.this.timeToLive;
        }

        private boolean insertInternal(CacheEntry entry, Connection con) throws SQLException {
            try (PreparedStatement ps = con.prepareStatement(this.insertSql);){
                int ret;
                ps.setString(1, this.getNamespace());
                if (entry.getKey() instanceof NullKey) {
                    ps.setString(2, entry.getKey().toString());
                } else {
                    ps.setString(2, RdbCacheStoreFactory.this.cacheKeyResolver.toString(entry.getKey()));
                }
                if (entry.getValue() == null) {
                    ps.setNull(3, 2004);
                } else {
                    ps.setBytes(3, this.toBytes(entry.getValue()));
                }
                ps.setLong(4, entry.getVersion());
                ps.setLong(5, entry.getCreationTime());
                ps.setLong(6, this.invalidTime(entry.getCreationTime()));
                int cnt = 6;
                if (RdbCacheStoreFactory.this.getIndexCount() > 0) {
                    for (int i = 0; i < RdbCacheStoreFactory.this.getIndexCount(); ++i) {
                        Object ival = entry.getIndexValue(i);
                        ++cnt;
                        if (ival == null) {
                            ps.setNull(cnt, 12);
                            continue;
                        }
                        ps.setString(cnt, ((CacheKeyResolver)RdbCacheStoreFactory.this.cacheIndexResolver.get(i)).toString(ival));
                    }
                }
                if ((ret = ps.executeUpdate()) > 0) {
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
        }

        private boolean deleteInternal(Object key, boolean checkVersion, long preVersion, Connection con) throws SQLException {
            String sql = checkVersion ? this.delSqlWithVersionCheck : this.delSql;
            try (PreparedStatement ps = con.prepareStatement(sql);){
                boolean bl = this.deleteInternal(key, checkVersion, preVersion, ps);
                return bl;
            }
        }

        private boolean deleteInternal(Object key, boolean checkVersion, long preVersion, PreparedStatement ps) throws SQLException {
            int ret;
            ps.setString(1, this.getNamespace());
            if (key instanceof NullKey) {
                ps.setString(2, key.toString());
            } else {
                ps.setString(2, RdbCacheStoreFactory.this.cacheKeyResolver.toString(key));
            }
            if (checkVersion) {
                ps.setLong(3, preVersion);
            }
            return (ret = ps.executeUpdate()) > 0;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CacheEntry putIfAbsent(CacheEntry entry) {
            int count = 0;
            while (count <= RdbCacheStoreFactory.this.retryCount) {
                block28: {
                    try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                        CacheEntry pre = this.getInternal(entry.getKey(), false, con);
                        if (pre == null) {
                            if (this.insertInternal(entry, con)) {
                                this.notifyPut(entry);
                                CacheEntry cacheEntry = null;
                                return cacheEntry;
                            }
                        } else {
                            if (this.isStillAliveOrNull(pre)) {
                                CacheEntry cacheEntry = pre;
                                return cacheEntry;
                            }
                            if (this.updateInternal(entry, true, pre.getVersion(), con)) {
                                this.notifyPut(entry);
                                CacheEntry cacheEntry = null;
                                return cacheEntry;
                            }
                        }
                    }
                    catch (SQLException e) {
                        if (this.rdb.isDuplicateValueException(e)) break block28;
                        throw new SystemException("cant putIfAbsent CacheEntry to RDB:" + entry, e);
                    }
                }
                ++count;
            }
            throw new SystemException("cant putIfAbsent CacheEntry cause retry count over:" + entry);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CacheEntry get(Object key) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                CacheEntry cacheEntry = this.getInternal(key, true, con);
                return cacheEntry;
            }
            catch (SQLException e) {
                throw new SystemException("cant get CacheEntry from RDB:key=" + key, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CacheEntry remove(Object key) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                CacheEntry pre = this.getInternal(key, false, con);
                if (pre == null) {
                    CacheEntry cacheEntry = null;
                    return cacheEntry;
                }
                if (this.deleteInternal(key, true, pre.getVersion(), con)) {
                    if (this.isStillAliveOrNull(pre)) {
                        this.notifyRemoved(pre);
                        CacheEntry cacheEntry = pre;
                        return cacheEntry;
                    }
                    CacheEntry cacheEntry = null;
                    return cacheEntry;
                }
                CacheEntry cacheEntry = null;
                return cacheEntry;
            }
            catch (SQLException e) {
                throw new SystemException("cant remove CacheEntry from RDB:key=" + key, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean remove(CacheEntry entry) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                CacheEntry pre = this.getInternal(entry.getKey(), false, con);
                if (pre == null) {
                    boolean bl = false;
                    return bl;
                }
                if (entry.getVersion() != pre.getVersion()) {
                    boolean bl = false;
                    return bl;
                }
                if (this.deleteInternal(entry.getKey(), true, pre.getVersion(), con)) {
                    if (this.isStillAliveOrNull(pre)) {
                        this.notifyRemoved(pre);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                throw new SystemException("cant remove CacheEntry from RDB:" + entry, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CacheEntry replace(CacheEntry entry) {
            int count = 0;
            while (count <= RdbCacheStoreFactory.this.retryCount) {
                try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                    CacheEntry pre = this.getInternal(entry.getKey(), false, con);
                    if (pre == null) {
                        CacheEntry cacheEntry = null;
                        return cacheEntry;
                    }
                    if (this.isStillAliveOrNull(pre)) {
                        if (this.updateInternal(entry, true, pre.getVersion(), con)) {
                            this.notifyUpdated(pre, entry);
                            CacheEntry cacheEntry = pre;
                            return cacheEntry;
                        }
                        CacheEntry cacheEntry = null;
                        return cacheEntry;
                    }
                    CacheEntry cacheEntry = null;
                    return cacheEntry;
                }
                catch (SQLException e) {
                    if (!this.rdb.isDuplicateValueException(e)) {
                        throw new SystemException("cant replace CacheEntry to RDB:" + entry, e);
                    }
                    ++count;
                }
            }
            throw new SystemException("cant replace CacheEntry cause retry count over:" + entry);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                CacheEntry pre = this.getInternal(oldEntry.getKey(), false, con);
                if (pre == null) {
                    boolean bl = false;
                    return bl;
                }
                if (this.isStillAliveOrNull(pre)) {
                    if (oldEntry.getVersion() != pre.getVersion()) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.updateInternal(newEntry, true, oldEntry.getVersion(), con)) {
                        this.notifyUpdated(pre, newEntry);
                        boolean bl = true;
                        return bl;
                    }
                    boolean bl = false;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                throw new SystemException("cant replace CacheEntry to RDB:" + newEntry, e);
            }
        }

        protected boolean hasListener() {
            if (this.listeners == null) {
                return false;
            }
            return this.listeners.size() > 0;
        }

        @Override
        public void removeAll() {
            if (this.hasListener()) {
                for (Object k : this.keySet()) {
                    this.remove(k);
                }
            } else {
                try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);
                     PreparedStatement ps = con.prepareStatement(this.delAllSql);){
                    ps.setString(1, this.getNamespace());
                    ps.executeUpdate();
                }
                catch (SQLException e) {
                    throw new SystemException("cant removeAll CacheEntry from RDB", e);
                }
            }
        }

        private Object toKey(String keyStr) {
            if (keyStr == null) {
                return null;
            }
            if (keyStr.startsWith("NullKey[")) {
                return new NullKey(keyStr.substring("NullKey[".length(), keyStr.length() - 1));
            }
            return RdbCacheStoreFactory.this.cacheKeyResolver.toCacheKey(keyStr);
        }

        /*
         * Exception decompiling
         */
        @Override
        public List<Object> keySet() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        private List<CacheEntry> getByIndexInternal(int indexKey, Object indexValue, boolean onlyFirst, Connection con) throws SQLException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public CacheEntry getByIndex(int indexKey, Object indexValue) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                List<CacheEntry> ret = this.getByIndexInternal(indexKey, indexValue, true, con);
                if (ret.size() > 0) {
                    CacheEntry cacheEntry = ret.get(0);
                    return cacheEntry;
                }
                CacheEntry cacheEntry = null;
                return cacheEntry;
            }
            catch (SQLException e) {
                throw new SystemException("cant getByIndex from RDB:indexKey=" + indexKey + ",indexValue=" + indexValue, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                List<CacheEntry> list = this.getByIndexInternal(indexKey, indexValue, false, con);
                return list;
            }
            catch (SQLException e) {
                throw new SystemException("cant getListByIndex from RDB:indexKey=" + indexKey + ",indexValue=" + indexValue, e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
            try (Connection con = this.rdb.getConnection(RdbCacheStoreFactory.this.connectionFactoryName);){
                List<CacheEntry> ret = this.getByIndexInternal(indexKey, indexValue, false, con);
                if (ret.size() > 0) {
                    try (PreparedStatement ps = con.prepareStatement(this.delSqlWithVersionCheck);){
                        for (CacheEntry ce : ret) {
                            this.deleteInternal(ce.getKey(), true, ce.getVersion(), ps);
                        }
                    }
                }
                List<CacheEntry> list = ret;
                return list;
            }
            catch (SQLException e) {
                throw new SystemException("cant removeByIndex from RDB:indexKey=" + indexKey + ",indexValue=" + indexValue, e);
            }
        }

        @Override
        public String trace() {
            StringBuilder builder = new StringBuilder();
            builder.append("-----------------------------------");
            builder.append("\nCacheStore Info");
            builder.append("\nCacheStore:" + this);
            builder.append("\n\tnamespace:" + this.namespace);
            builder.append("\n-----------------------------------");
            return builder.toString();
        }

        @Override
        public void destroy() {
        }
    }

    private static class Target {
        private String connectionFactoryName;
        private String rdbArapterName;
        private String tableName;

        private Target(String connectionFactoryName, String rdbArapterName, String tableName) {
            this.connectionFactoryName = connectionFactoryName;
            this.rdbArapterName = rdbArapterName;
            this.tableName = tableName;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionFactoryName == null ? 0 : this.connectionFactoryName.hashCode());
            result = 31 * result + (this.rdbArapterName == null ? 0 : this.rdbArapterName.hashCode());
            result = 31 * result + (this.tableName == null ? 0 : this.tableName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Target other = (Target)obj;
            if (this.connectionFactoryName == null ? other.connectionFactoryName != null : !this.connectionFactoryName.equals(other.connectionFactoryName)) {
                return false;
            }
            if (this.rdbArapterName == null ? other.rdbArapterName != null : !this.rdbArapterName.equals(other.rdbArapterName)) {
                return false;
            }
            return !(this.tableName == null ? other.tableName != null : !this.tableName.equals(other.tableName));
        }

        public String toString() {
            return "Target [connectionFactoryName=" + this.connectionFactoryName + ", rdbArapterName=" + this.rdbArapterName + ", tableName=" + this.tableName + "]";
        }
    }
}

