/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.cache.store.builtin;

import java.util.List;
import org.iplass.mtp.impl.cache.store.CacheEntry;
import org.iplass.mtp.impl.cache.store.CacheHandler;
import org.iplass.mtp.impl.cache.store.CacheStore;
import org.iplass.mtp.impl.cache.store.CacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.AbstractBuiltinCacheStoreFactory;
import org.iplass.mtp.impl.cache.store.builtin.SimpleLocalCacheHandler;
import org.iplass.mtp.impl.cache.store.builtin.SyncServerCacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheEventListener;
import org.iplass.mtp.impl.cache.store.event.CacheInvalidateEvent;
import org.iplass.mtp.impl.cache.store.keyresolver.CacheKeyResolver;
import org.iplass.mtp.impl.cluster.ClusterEventListener;
import org.iplass.mtp.impl.cluster.ClusterService;
import org.iplass.mtp.impl.cluster.Message;
import org.iplass.mtp.spi.ServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncServerCacheStoreFactory
extends AbstractBuiltinCacheStoreFactory {
    private static Logger logger = LoggerFactory.getLogger(SyncServerCacheStoreFactory.class);
    private static final String CLUSTER_EVENT_NAME_MARK_DIRTY = "mtp.cache.md/";
    private static final String CLUSTER_EVENT_NAME_REMOVE_ALL = "mtp.cache.ra/";
    private static final String CLUSTER_EVENT_NAME_REMOVE_BY_INDEX = "mtp.cache.ri/";
    private static final String CLUSTER_MESSAGE_CACHE_KEY = "key";
    private static final String CLUSTER_MESSAGE_INDEX_PREFIX = "i";
    private static final String CLUSTER_MESSAGE_INDEX_KEY = "ikey";
    private static final String CLUSTER_MESSAGE_INDEX_VALUE = "ival";
    private CacheStoreFactory store;
    private CacheKeyResolver cacheKeyResolver;
    private List<CacheKeyResolver> cacheIndexResolver;
    private SyncServerCacheEventListener listener;
    private boolean noClusterEventOnPut;

    public boolean isNoClusterEventOnPut() {
        return this.noClusterEventOnPut;
    }

    public void setNoClusterEventOnPut(boolean noClusterEventOnPut) {
        this.noClusterEventOnPut = noClusterEventOnPut;
    }

    public SyncServerCacheEventListener getListener() {
        return this.listener;
    }

    public void setListener(SyncServerCacheEventListener listener) {
        this.listener = listener;
    }

    @Override
    public void setIndexCount(int indexCount) {
        super.setIndexCount(indexCount);
        if (this.store != null) {
            this.store.setIndexCount(indexCount);
        }
    }

    public CacheKeyResolver getCacheKeyResolver() {
        return this.cacheKeyResolver;
    }

    public void setCacheKeyResolver(CacheKeyResolver cacheKeyResolver) {
        this.cacheKeyResolver = cacheKeyResolver;
    }

    public List<CacheKeyResolver> getCacheIndexResolver() {
        return this.cacheIndexResolver;
    }

    public void setCacheIndexResolver(List<CacheKeyResolver> cacheIndexResolver) {
        this.cacheIndexResolver = cacheIndexResolver;
    }

    public CacheStoreFactory getStore() {
        return this.store;
    }

    public void setStore(CacheStoreFactory store) {
        store.setIndexCount(this.getIndexCount());
        this.store = store;
    }

    @Override
    public CacheStore createCacheStore(String namespace) {
        CacheStore wrapped = this.store.createCacheStore(namespace);
        return new SyncServerCacheStore(namespace, wrapped);
    }

    @Override
    public boolean canUseForLocalCache() {
        return false;
    }

    @Override
    public boolean supportsIndex() {
        return this.store.supportsIndex();
    }

    @Override
    public CacheHandler createCacheHandler(CacheStore store) {
        return new SimpleLocalCacheHandler(store, this.getConcurrencyLevelOfCacheHandler());
    }

    @Override
    public CacheStoreFactory getLowerLevel() {
        return this.store;
    }

    public class SyncServerCacheStore
    implements CacheStore {
        private final String namespace;
        private final CacheStore wrapped;
        private final String eventNameMarkDirty;
        private final String eventNameClearAll;
        private final String eventNameRemoveByIndex;
        private final ClusterEventListener cel;

        SyncServerCacheStore(final String namespace, final CacheStore wrapped) {
            this.namespace = namespace;
            this.eventNameMarkDirty = SyncServerCacheStoreFactory.CLUSTER_EVENT_NAME_MARK_DIRTY + namespace;
            this.eventNameClearAll = SyncServerCacheStoreFactory.CLUSTER_EVENT_NAME_REMOVE_ALL + namespace;
            this.eventNameRemoveByIndex = SyncServerCacheStoreFactory.CLUSTER_EVENT_NAME_REMOVE_BY_INDEX + namespace;
            this.wrapped = wrapped;
            this.cel = new ClusterEventListener(){

                @Override
                public void onMessage(Message msg) {
                    if (msg.getEventName().startsWith(SyncServerCacheStoreFactory.CLUSTER_EVENT_NAME_MARK_DIRTY)) {
                        Object key = SyncServerCacheStoreFactory.this.cacheKeyResolver.toCacheKey(msg.getParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_CACHE_KEY));
                        Object[] index = null;
                        if (SyncServerCacheStoreFactory.this.getIndexCount() > 0) {
                            index = new Object[SyncServerCacheStoreFactory.this.getIndexCount()];
                            for (int i = 0; i < index.length; ++i) {
                                String iVal = msg.getParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_INDEX_PREFIX + i);
                                if (iVal == null) continue;
                                index[i] = ((CacheKeyResolver)SyncServerCacheStoreFactory.this.cacheIndexResolver.get(i)).toCacheKey(iVal);
                            }
                        }
                        CacheEntry entry = new CacheEntry(key, (Object)null, 0L, index);
                        wrapped.remove(key);
                        List<CacheEventListener> ls = wrapped.getListeners();
                        if (ls.size() > 0) {
                            CacheInvalidateEvent e = new CacheInvalidateEvent(entry);
                            for (CacheEventListener l : wrapped.getListeners()) {
                                l.invalidated(e);
                            }
                        }
                        if (SyncServerCacheStoreFactory.this.listener != null) {
                            SyncServerCacheStoreFactory.this.listener.markDirty(namespace, entry);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("remove cache entry by cluster message.namespace=" + namespace + ", key=" + key);
                        }
                    } else if (msg.getEventName().startsWith(SyncServerCacheStoreFactory.CLUSTER_EVENT_NAME_REMOVE_BY_INDEX)) {
                        int indexKey = Integer.parseInt(msg.getParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_INDEX_KEY));
                        String iValStr = msg.getParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_INDEX_VALUE);
                        if (iValStr != null) {
                            Object iVal = ((CacheKeyResolver)SyncServerCacheStoreFactory.this.cacheIndexResolver.get(indexKey)).toCacheKey(iValStr);
                            wrapped.removeByIndex(indexKey, iVal);
                            if (logger.isDebugEnabled()) {
                                logger.debug("remove cache entry by cluster message.namespace=" + namespace + ", indexKey=" + indexKey + ", indexValue=" + iVal);
                            }
                        }
                    } else {
                        wrapped.removeAll();
                        if (SyncServerCacheStoreFactory.this.listener != null) {
                            SyncServerCacheStoreFactory.this.listener.removeAll(namespace);
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("remove all cache entry by cluster message.namespace=" + namespace);
                        }
                    }
                }
            };
            ServiceRegistry.getRegistry().getService(ClusterService.class).registerListener(new String[]{this.eventNameMarkDirty, this.eventNameClearAll, this.eventNameRemoveByIndex}, this.cel);
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public CacheEntry put(CacheEntry entry, boolean isClean) {
            CacheEntry previous = this.wrapped.put(entry, isClean);
            if (!isClean && !SyncServerCacheStoreFactory.this.noClusterEventOnPut) {
                this.sendByKeyEvent(entry);
            }
            return previous;
        }

        @Override
        public CacheEntry putIfAbsent(CacheEntry entry) {
            CacheEntry e = this.wrapped.putIfAbsent(entry);
            if (e == null && !SyncServerCacheStoreFactory.this.noClusterEventOnPut) {
                this.sendByKeyEvent(entry);
            }
            return e;
        }

        @Override
        public CacheEntry get(Object key) {
            return this.wrapped.get(key);
        }

        @Override
        public CacheEntry remove(Object key) {
            CacheEntry e = this.wrapped.remove(key);
            if (e != null) {
                this.sendByKeyEvent(e);
            } else {
                CacheEntry forInvalidation = new CacheEntry(key, null, new Object[0]);
                this.sendByKeyEvent(forInvalidation);
            }
            return e;
        }

        @Override
        public boolean remove(CacheEntry entry) {
            boolean isRemove = this.wrapped.remove(entry);
            if (isRemove) {
                this.sendByKeyEvent(entry);
            }
            return isRemove;
        }

        @Override
        public CacheEntry replace(CacheEntry entry) {
            CacheEntry e = this.wrapped.replace(entry);
            if (e != null) {
                this.sendByKeyEvent(entry);
            }
            return e;
        }

        @Override
        public boolean replace(CacheEntry oldEntry, CacheEntry newEntry) {
            boolean isReplace = this.wrapped.replace(oldEntry, newEntry);
            if (isReplace) {
                this.sendByKeyEvent(newEntry);
            }
            return isReplace;
        }

        @Override
        public void removeAll() {
            this.wrapped.removeAll();
            Message msg = new Message(this.eventNameClearAll);
            ServiceRegistry.getRegistry().getService(ClusterService.class).sendMessage(msg);
        }

        @Override
        public List<Object> keySet() {
            return this.wrapped.keySet();
        }

        @Override
        public CacheEntry getByIndex(int indexKey, Object indexValue) {
            return this.wrapped.getByIndex(indexKey, indexValue);
        }

        @Override
        public List<CacheEntry> getListByIndex(int indexKey, Object indexValue) {
            return this.wrapped.getListByIndex(indexKey, indexValue);
        }

        @Override
        public void addCacheEventListenner(CacheEventListener listener) {
            this.wrapped.addCacheEventListenner(listener);
        }

        @Override
        public void removeCacheEventListenner(CacheEventListener listener) {
            this.wrapped.addCacheEventListenner(listener);
        }

        private void sendByKeyEvent(CacheEntry entry) {
            Message msg = new Message(this.eventNameMarkDirty);
            if (entry.getKey() != null) {
                msg.addParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_CACHE_KEY, SyncServerCacheStoreFactory.this.cacheKeyResolver.toString(entry.getKey()));
            }
            if (SyncServerCacheStoreFactory.this.getIndexCount() > 0) {
                for (int i = 0; i < SyncServerCacheStoreFactory.this.getIndexCount(); ++i) {
                    if (entry.getIndexValue(i) == null) continue;
                    msg.addParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_INDEX_PREFIX + i, ((CacheKeyResolver)SyncServerCacheStoreFactory.this.cacheIndexResolver.get(i)).toString(entry.getIndexValue(i)));
                }
            }
            ServiceRegistry.getRegistry().getService(ClusterService.class).sendMessage(msg);
        }

        @Override
        public CacheStoreFactory getFactory() {
            return SyncServerCacheStoreFactory.this;
        }

        @Override
        public List<CacheEntry> removeByIndex(int indexKey, Object indexValue) {
            List<CacheEntry> ret = this.wrapped.removeByIndex(indexKey, indexValue);
            Message msg = new Message(this.eventNameRemoveByIndex);
            msg.addParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_INDEX_KEY, Integer.toString(indexKey));
            if (indexValue != null) {
                String iValStr = ((CacheKeyResolver)SyncServerCacheStoreFactory.this.cacheIndexResolver.get(indexKey)).toString(indexValue);
                msg.addParameter(SyncServerCacheStoreFactory.CLUSTER_MESSAGE_INDEX_VALUE, iValStr);
            }
            ServiceRegistry.getRegistry().getService(ClusterService.class).sendMessage(msg);
            return ret;
        }

        @Override
        public String trace() {
            StringBuilder builder = new StringBuilder();
            builder.append("-----------------------------------");
            builder.append("\nCacheStore Info");
            builder.append("\nCacheStore:" + this);
            builder.append("\n\tnamespace:" + this.namespace);
            builder.append("\n\teventNameMarkDirty:" + this.eventNameMarkDirty);
            builder.append("\n\teventNameClearAll:" + this.eventNameClearAll);
            builder.append("\n\teventNameRemoveByIndex:" + this.eventNameRemoveByIndex);
            builder.append("\n\twrapped:" + this.wrapped);
            builder.append("\n" + this.wrapped.trace());
            builder.append("\n-----------------------------------");
            return builder.toString();
        }

        @Override
        public void destroy() {
            ServiceRegistry.getRegistry().getService(ClusterService.class).removeListener(new String[]{this.eventNameMarkDirty, this.eventNameClearAll, this.eventNameRemoveByIndex}, this.cel);
            this.wrapped.destroy();
        }

        @Override
        public List<CacheEventListener> getListeners() {
            return this.wrapped.getListeners();
        }
    }
}

