/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.core.config;

import java.io.IOException;
import org.iplass.mtp.impl.core.config.ConfigLoader;
import org.iplass.mtp.impl.core.config.FileUtil;
import org.iplass.mtp.impl.core.config.ServiceDefinitionParser;
import org.iplass.mtp.spi.ServiceConfigrationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalResourceConfigLoader
implements ConfigLoader {
    private static final Logger logger = LoggerFactory.getLogger(ServiceDefinitionParser.class);

    @Override
    public String load(String configFileName) {
        try {
            String content = FileUtil.readContent(configFileName);
            if (content == null) {
                throw new ServiceConfigrationException("Config File:" + configFileName + " Not Found.");
            }
            return content;
        }
        catch (IOException e) {
            logger.error("Cant read ConfigFile:" + configFileName, (Throwable)e);
            throw new ServiceConfigrationException("Cant read ConfigFile:" + configFileName, e);
        }
    }
}

