/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.sql;

import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.iplass.mtp.impl.rdb.adapter.UpdateSqlHandler;

public class ReferenceDeleteSql
extends UpdateSqlHandler {
    public String toSql(int tenantId, EntityHandler eh, String oid, Long version, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND OBJ_ID='").append(rdb.sanitize(oid)).append("'");
        if (version != null) {
            sb.append(" AND OBJ_VER=").append(version);
        } else {
            sb.append(" AND OBJ_VER=0");
        }
        return sb.toString();
    }

    public String deleteByOidAndVersion(int tenantId, EntityHandler eh, String refDefId, String oid, Long version, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        sb.append("' AND REF_DEF_ID='").append(rdb.sanitize(refDefId));
        sb.append("' AND OBJ_ID='").append(rdb.sanitize(oid)).append("'");
        if (version != null) {
            sb.append(" AND OBJ_VER=").append(version);
        } else {
            sb.append(" AND OBJ_VER=0");
        }
        return sb.toString();
    }

    public String deleteByTempTable(int tenantId, EntityHandler eh, RdbAdapter rdb, EntityContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId()));
        if (rdb.isSupportRowValueConstructor()) {
            sb.append("' AND (OBJ_ID,OBJ_VER) IN(SELECT OBJ_ID,OBJ_VER FROM " + rdb.getTemplaryTablePrefix() + "OBJ_STORE_TMP" + ")");
        } else {
            String objRefTable = ((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF();
            sb.append("' AND EXISTS (");
            sb.append("SELECT 1 FROM ").append(rdb.getTemplaryTablePrefix()).append("OBJ_STORE_TMP").append(" TMP");
            sb.append(" WHERE ").append("TMP.").append("OBJ_ID").append("=").append(objRefTable).append(".").append("OBJ_ID");
            sb.append(" AND ").append("TMP.").append("OBJ_VER").append("=").append(objRefTable).append(".").append("OBJ_VER");
            sb.append(")");
        }
        return sb.toString();
    }

    public String deleteAll(int tenantId, String defId, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(MetaGRdbEntityStore.makeObjRefTableName(tableNamePostfix));
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(defId)).append("'");
        return sb.toString();
    }

    public String deleteAllByTargetDefId(int tenantId, String targetDefId, String tableNamePostfix, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(MetaGRdbEntityStore.makeObjRefTableName(tableNamePostfix));
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND TARGET_OBJ_DEF_ID='").append(rdb.sanitize(targetDefId)).append("'");
        return sb.toString();
    }

    public String deleteForDefrag(int tenantId, EntityHandler eh, List<String> usedRefPropertyIds, RdbAdapter rdb) {
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ");
        sb.append(((MetaGRdbEntityStore.GRdbEntityStoreRuntime)eh.getEntityStoreRuntime()).OBJ_REF());
        sb.append(" WHERE TENANT_ID=").append(tenantId);
        sb.append(" AND OBJ_DEF_ID='").append(rdb.sanitize(eh.getMetaData().getId())).append("'");
        if (!usedRefPropertyIds.isEmpty()) {
            sb.append(" AND REF_DEF_ID NOT IN (");
            boolean isFirst = true;
            for (String refProperty : usedRefPropertyIds) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append(",");
                }
                sb.append("'").append(rdb.sanitize(refProperty)).append("'");
            }
            sb.append(")");
        }
        return sb.toString();
    }
}

