/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.iplass.mtp.impl.datastore.grdb.MetaGRdbEntityStore;
import org.iplass.mtp.impl.datastore.grdb.StorageSpaceMap;
import org.iplass.mtp.impl.datastore.grdb.sql.ObjStoreMaintenanceSql;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColContext;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.ColResolver;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.DelProperty;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.Diff;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.InsProperty;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.InsReference;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.UpdProperty;
import org.iplass.mtp.impl.datastore.grdb.strategy.metadata.diff.UpdReference;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaRdbColumnMapping;
import org.iplass.mtp.impl.entity.MetaSchemalessRdbStoreMapping;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.entity.property.MetaReferenceProperty;
import org.iplass.mtp.impl.rdb.adapter.RdbAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdEntity
extends Diff {
    private static Logger logger = LoggerFactory.getLogger(UpdEntity.class);
    private MetaEntity previousEntity;
    private MetaEntity nextEntity;
    private ColResolver colResolver;
    private EntityContext context;
    private StorageSpaceMap storage;
    private List<Diff> propertyList;

    private List<MetaProperty> getEmptyListIfNull(List<MetaProperty> list) {
        if (list == null) {
            return new ArrayList<MetaProperty>();
        }
        return list;
    }

    public UpdEntity(MetaEntity previousEntity, MetaEntity nextEntity, EntityContext context, StorageSpaceMap storage, RdbAdapter rdb) {
        this.previousEntity = previousEntity;
        this.nextEntity = nextEntity;
        this.context = context;
        this.storage = storage;
        this.colResolver = new ColResolver(previousEntity, (MetaSchemalessRdbStoreMapping)nextEntity.getStoreMapping(), storage, rdb);
        this.propertyList = new ArrayList<Diff>();
        List<MetaProperty> nextPropList = this.getEmptyListIfNull(nextEntity.getDeclaredPropertyList());
        nextEntity.setDeclaredPropertyList(nextPropList);
        ArrayList<MetaProperty> previousPropList = new ArrayList<MetaProperty>(this.getEmptyListIfNull(previousEntity.getDeclaredPropertyList()));
        for (MetaProperty np : nextPropList) {
            boolean isMatched = false;
            Iterator ppIt = previousPropList.iterator();
            while (ppIt.hasNext()) {
                MetaProperty pp = (MetaProperty)ppIt.next();
                if (!pp.getId().equals(np.getId())) continue;
                isMatched = true;
                this.addUpd(pp, np);
                ppIt.remove();
                break;
            }
            if (isMatched) continue;
            this.addIns(np);
        }
        for (MetaProperty dp : previousPropList) {
            this.addDel(dp);
        }
    }

    private void addDel(MetaProperty del) {
        DelProperty delP = new DelProperty(del);
        this.propertyList.add(delP);
    }

    private void addIns(MetaProperty ins) {
        if (ins instanceof MetaPrimitiveProperty) {
            InsProperty insP = new InsProperty((MetaPrimitiveProperty)ins, this.nextEntity, this.colResolver);
            this.propertyList.add(insP);
        } else if (ins instanceof MetaReferenceProperty) {
            InsReference insR = new InsReference((MetaReferenceProperty)ins, this.nextEntity, this.colResolver);
            this.propertyList.add(insR);
        }
    }

    private void addUpd(MetaProperty pre, MetaProperty next) {
        if (!pre.equals(next) || this.isMappingChanged(next.getId())) {
            logger.debug("diff update (prev:{} next:{})", (Object)pre.getName(), (Object)next.getName());
            if (pre.getClass() != next.getClass()) {
                throw new IllegalArgumentException("Primitive to Reference can not convert, or vice versa.");
            }
            if (pre instanceof MetaPrimitiveProperty) {
                UpdProperty updP = new UpdProperty((MetaPrimitiveProperty)pre, (MetaPrimitiveProperty)next, this.nextEntity, this.colResolver);
                this.propertyList.add(updP);
            } else {
                UpdReference updP = new UpdReference((MetaReferenceProperty)pre, (MetaReferenceProperty)next, this.nextEntity);
                this.propertyList.add(updP);
            }
        }
    }

    private boolean isMappingChanged(String propId) {
        String nextMappedCol;
        String preMappedCol = this.mappedColName((MetaSchemalessRdbStoreMapping)this.previousEntity.getStoreMapping(), propId);
        return !preMappedCol.equals(nextMappedCol = this.mappedColName((MetaSchemalessRdbStoreMapping)this.nextEntity.getStoreMapping(), propId));
    }

    private String mappedColName(MetaSchemalessRdbStoreMapping map, String propId) {
        if (map == null) {
            return "";
        }
        List<MetaRdbColumnMapping> list = map.getColumnMappingList();
        if (list != null) {
            for (MetaRdbColumnMapping cm : list) {
                if (!propId.equals(cm.getPropertyId())) continue;
                return cm.getColumnName();
            }
        }
        return "";
    }

    @Override
    public void applyToData(Statement stmt, RdbAdapter rdb, int tenantId) throws SQLException {
        if (this.needDataModify()) {
            ObjStoreMaintenanceSql sc = rdb.getUpdateSqlCreator(ObjStoreMaintenanceSql.class);
            MetaGRdbEntityStore storeDef = (MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition();
            switch (rdb.getMultiTableUpdateMethod()) {
                case INLINE_VIEW: 
                case NO_SUPPORT: {
                    int i;
                    List<ColContext.ColCopy> ccl = this.colResolver.getColContext().getColCopyList(0);
                    stmt.executeUpdate(sc.updateCol(tenantId, this.nextEntity.getId(), storeDef.getVersion(), 0, ccl, storeDef.getTableNamePostfix(), rdb));
                    stmt.executeUpdate(sc.updateColRB(tenantId, this.nextEntity.getId(), storeDef.getVersion(), 0, ccl, storeDef.getTableNamePostfix(), rdb));
                    int prePageNo = ((MetaGRdbEntityStore)this.previousEntity.getEntityStoreDefinition()).currentMaxPage();
                    int nextPageNo = storeDef.currentMaxPage();
                    if (nextPageNo > prePageNo) {
                        for (i = prePageNo + 1; i <= nextPageNo; ++i) {
                            stmt.executeUpdate(sc.insertNewPage(tenantId, this.nextEntity.getId(), i, storeDef.getTableNamePostfix(), rdb));
                            stmt.executeUpdate(sc.insertNewPageRB(tenantId, this.nextEntity.getId(), i, storeDef.getTableNamePostfix(), rdb));
                        }
                    }
                    for (i = 1; i <= nextPageNo; ++i) {
                        ccl = this.colResolver.getColContext().getColCopyList(i);
                        if (ccl == null) continue;
                        stmt.executeUpdate(sc.updateCol(tenantId, this.nextEntity.getId(), storeDef.getVersion(), i, ccl, storeDef.getTableNamePostfix(), rdb));
                        stmt.executeUpdate(sc.updateColRB(tenantId, this.nextEntity.getId(), storeDef.getVersion(), i, ccl, storeDef.getTableNamePostfix(), rdb));
                    }
                    break;
                }
                case DIRECT_JOIN: {
                    stmt.executeUpdate(sc.updateCol(tenantId, this.nextEntity.getId(), storeDef.getVersion(), 0, null, storeDef.getTableNamePostfix(), rdb));
                    stmt.executeUpdate(sc.updateColRB(tenantId, this.nextEntity.getId(), storeDef.getVersion(), 0, null, storeDef.getTableNamePostfix(), rdb));
                    int prePageNo = ((MetaGRdbEntityStore)this.previousEntity.getEntityStoreDefinition()).currentMaxPage();
                    int nextPageNo = storeDef.currentMaxPage();
                    if (nextPageNo > prePageNo) {
                        for (int i = prePageNo + 1; i <= nextPageNo; ++i) {
                            stmt.executeUpdate(sc.insertNewPage(tenantId, this.nextEntity.getId(), i, storeDef.getTableNamePostfix(), rdb));
                            stmt.executeUpdate(sc.insertNewPageRB(tenantId, this.nextEntity.getId(), i, storeDef.getTableNamePostfix(), rdb));
                        }
                    }
                    List[] ccls = new List[nextPageNo + 1];
                    for (int i = 0; i <= nextPageNo; ++i) {
                        ccls[i] = this.colResolver.getColContext().getColCopyList(i);
                    }
                    stmt.executeUpdate(sc.updateColDirectJoin(tenantId, this.nextEntity.getId(), storeDef.getVersion(), ccls, storeDef.getTableNamePostfix(), rdb));
                    stmt.executeUpdate(sc.updateColDirectJoinRB(tenantId, this.nextEntity.getId(), storeDef.getVersion(), ccls, storeDef.getTableNamePostfix(), rdb));
                    break;
                }
            }
            if (this.propertyList != null) {
                for (Diff p : this.propertyList) {
                    p.applyToData(stmt, rdb, tenantId);
                }
            }
        }
    }

    @Override
    public void modifyMetaData() {
        MetaGRdbEntityStore preStoreDef = (MetaGRdbEntityStore)this.previousEntity.getEntityStoreDefinition();
        MetaGRdbEntityStore nextStoreDef = this.colResolver.getMetaStore();
        nextStoreDef.setVersion(preStoreDef.getVersion() + 1);
        nextStoreDef.setTableNamePostfix(this.storage.generateTableNamePostfix(this.context.getLocalTenantId(), this.nextEntity.getId()));
        this.nextEntity.setEntityStoreDefinition(nextStoreDef);
        if (this.propertyList != null) {
            for (Diff p : this.propertyList) {
                p.modifyMetaData();
            }
        }
    }

    @Override
    public boolean needDataModify() {
        int prePageNo = ((MetaGRdbEntityStore)this.previousEntity.getEntityStoreDefinition()).currentMaxPage();
        int nextPageNo = ((MetaGRdbEntityStore)this.nextEntity.getEntityStoreDefinition()).currentMaxPage();
        if (nextPageNo > prePageNo) {
            return true;
        }
        if (this.colResolver.getColContext().hasColCopy()) {
            return true;
        }
        boolean isDataModify = false;
        if (this.propertyList != null) {
            for (Diff p : this.propertyList) {
                isDataModify |= p.needDataModify();
            }
        }
        return isDataModify;
    }
}

