/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.definition;

import java.util.List;
import org.iplass.mtp.impl.definition.DefinitionService;
import org.iplass.mtp.impl.definition.TypedMetaDataService;
import org.iplass.mtp.impl.metadata.MetaDataContext;
import org.iplass.mtp.impl.metadata.MetaDataEntryInfo;
import org.iplass.mtp.impl.metadata.MetaDataRuntime;
import org.iplass.mtp.impl.metadata.RootMetaData;
import org.iplass.mtp.impl.util.KeyGenerator;

public abstract class AbstractTypedMetaDataService<M extends RootMetaData, R extends MetaDataRuntime>
implements TypedMetaDataService<M, R> {
    private KeyGenerator generator = new KeyGenerator();

    @Override
    public void createMetaData(M meta) {
        meta.setId(this.generator.generateId());
        MetaDataContext.getContext().store(DefinitionService.getInstance().getPathByMeta(this.getMetaDataType(), meta.getName()), (RootMetaData)meta);
    }

    @Override
    public void updateMetaData(M meta) {
        MetaDataContext.getContext().update(DefinitionService.getInstance().getPathByMeta(this.getMetaDataType(), meta.getName()), (RootMetaData)meta);
    }

    @Override
    public void removeMetaData(String definitionName) {
        R handler = this.getRuntimeByName(definitionName);
        RootMetaData meta = (RootMetaData)handler.getMetaData();
        MetaDataContext.getContext().remove(DefinitionService.getInstance().getPathByMeta(this.getMetaDataType(), meta.getName()));
    }

    @Override
    public R getRuntimeByName(String name) {
        return MetaDataContext.getContext().getMetaDataHandler(this.getRuntimeType(), DefinitionService.getInstance().getPathByMeta(this.getMetaDataType(), name));
    }

    @Override
    public R getRuntimeById(String id) {
        return MetaDataContext.getContext().getMetaDataHandlerById(this.getRuntimeType(), id);
    }

    @Override
    public List<String> nameList() {
        String fixedPath = this.getFixedPath();
        List<String> pathList = MetaDataContext.getContext().pathList(fixedPath);
        pathList.replaceAll(path -> this.toDefName((String)path));
        return pathList;
    }

    @Override
    public List<MetaDataEntryInfo> list() {
        return MetaDataContext.getContext().definitionList(this.getFixedPath());
    }

    @Override
    public List<MetaDataEntryInfo> list(String path) {
        return MetaDataContext.getContext().definitionList(DefinitionService.getInstance().getPathByMeta(this.getMetaDataType(), path));
    }

    private String getFixedPath() {
        DefinitionService service = DefinitionService.getInstance();
        return service.getPrefixPath(service.getDefinitionType(this.getMetaDataType()));
    }

    private String toDefName(String path) {
        DefinitionService service = DefinitionService.getInstance();
        return service.getDefinitionName(service.getDefinitionType(this.getMetaDataType()), path);
    }
}

