/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.DeleteCondition;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.SelectValue;
import org.iplass.mtp.entity.UpdateCondition;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.entity.query.ASTNode;
import org.iplass.mtp.entity.query.ASTTransformerSupport;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.entity.query.QueryException;
import org.iplass.mtp.entity.query.QueryVisitorSupport;
import org.iplass.mtp.entity.query.Select;
import org.iplass.mtp.entity.query.SortSpec;
import org.iplass.mtp.entity.query.SubQuery;
import org.iplass.mtp.entity.query.Where;
import org.iplass.mtp.entity.query.condition.Condition;
import org.iplass.mtp.entity.query.condition.predicate.Equals;
import org.iplass.mtp.entity.query.value.ValueExpression;
import org.iplass.mtp.entity.query.value.controlflow.Case;
import org.iplass.mtp.entity.query.value.primary.Cast;
import org.iplass.mtp.entity.query.value.primary.EntityField;
import org.iplass.mtp.entity.query.value.primary.Literal;
import org.iplass.mtp.impl.datastore.strategy.SearchResultIterator;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.property.MetaPrimitiveProperty;
import org.iplass.mtp.impl.entity.property.PrimitivePropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyHandler;
import org.iplass.mtp.impl.entity.property.PropertyType;
import org.iplass.mtp.impl.entity.property.ReferencePropertyHandler;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperType;
import org.iplass.mtp.impl.properties.extend.ComplexWrapperTypeLoadAdapter;
import org.iplass.mtp.impl.properties.extend.SelectType;
import org.iplass.mtp.impl.properties.extend.VirtualType;
import org.iplass.mtp.impl.properties.extend.select.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualPropertyAdapter
extends ASTTransformerSupport
implements SearchResultIterator {
    private static final Logger logger = LoggerFactory.getLogger(VirtualPropertyAdapter.class);
    private Map<ValueExpression, FieldMapping> selectFieldMap;
    private Map<ComplexWrapperType, LoadAdapterMapping> loadAdaptorMap;
    private Query query;
    private Query transformedQuery;
    private EntityContext ec;
    private EntityHandler eh;
    private UpdateCondition updateCond;
    private UpdateCondition transformedUpdateCond;
    private DeleteCondition deleteCond;
    private DeleteCondition transformedDeleteCond;
    private boolean isSubQuery = false;
    private boolean isSelectField = false;
    private SearchResultIterator iterator;

    public VirtualPropertyAdapter(Query query, EntityContext ec, EntityHandler eh) {
        this.selectFieldMap = new HashMap<ValueExpression, FieldMapping>();
        this.query = query;
        this.ec = ec;
        this.eh = eh;
        this.loadAdaptorMap = new HashMap<ComplexWrapperType, LoadAdapterMapping>();
    }

    public VirtualPropertyAdapter(UpdateCondition updateCond, EntityContext ec, EntityHandler eh) {
        this.updateCond = updateCond;
        this.ec = ec;
        this.eh = eh;
    }

    public VirtualPropertyAdapter(DeleteCondition deleteCond, EntityContext ec, EntityHandler eh) {
        this.deleteCond = deleteCond;
        this.ec = ec;
        this.eh = eh;
    }

    public UpdateCondition getTransformedUpdateCondition() {
        if (this.transformedUpdateCond == null) {
            this.transformedUpdateCond = this.updateCond.copy();
            ThisRefNormalizer trn = new ThisRefNormalizer(this.ec, this.eh, null);
            if (this.transformedUpdateCond.getValues() != null) {
                for (UpdateCondition.UpdateValue uv : this.transformedUpdateCond.getValues()) {
                    if (uv.getValue() == null) continue;
                    uv.setValue((ValueExpression)uv.getValue().accept(this));
                    uv.getValue().accept(trn);
                }
            }
            if (this.transformedUpdateCond.getWhere() != null) {
                this.transformedUpdateCond.setWhere((Where)this.transformedUpdateCond.getWhere().accept(this));
                this.transformedUpdateCond.getWhere().accept(trn);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("translate to virtualProperty extracted updateCondition: " + this.transformedUpdateCond);
            }
        }
        return this.transformedUpdateCond;
    }

    public DeleteCondition getTransformedDeleteCondition() {
        if (this.transformedDeleteCond == null) {
            this.transformedDeleteCond = this.deleteCond.copy();
            ThisRefNormalizer trn = new ThisRefNormalizer(this.ec, this.eh, null);
            if (this.transformedDeleteCond.getWhere() != null) {
                this.transformedDeleteCond.setWhere((Where)this.transformedDeleteCond.getWhere().accept(this));
                this.transformedDeleteCond.getWhere().accept(trn);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("translate to virtualProperty extracted deleteCondition: " + this.transformedDeleteCond);
            }
        }
        return this.transformedDeleteCond;
    }

    public Query getTransformedQuery() {
        if (this.transformedQuery == null) {
            this.transformedQuery = (Query)this.query.accept(this);
            this.transformedQuery.accept(new ThisRefNormalizer(this.ec, this.eh, null));
            if (logger.isDebugEnabled()) {
                logger.debug("translate to virtualProperty extracted query: " + this.transformedQuery);
            }
        }
        return this.transformedQuery;
    }

    public void setIterator(SearchResultIterator iterator) {
        this.iterator = iterator;
        for (Map.Entry<ComplexWrapperType, LoadAdapterMapping> e : this.loadAdaptorMap.entrySet()) {
            e.getValue().loadAdapter.setContext(this.ec);
        }
    }

    @Override
    public boolean next() {
        if (this.iterator == null) {
            return false;
        }
        boolean isNext = this.iterator.next();
        if (isNext && this.loadAdaptorMap.size() != 0) {
            for (Map.Entry<ComplexWrapperType, LoadAdapterMapping> e : this.loadAdaptorMap.entrySet()) {
                ArrayList<Object> values = new ArrayList<Object>();
                for (FieldMapping f : e.getValue().fields) {
                    Object val = this.iterator.getValue(f.actualField);
                    if (val == null) continue;
                    if (val instanceof Object[]) {
                        for (Object v : (Object[])val) {
                            values.add(v);
                        }
                        continue;
                    }
                    values.add(val);
                }
                if (values.size() == 0) continue;
                e.getValue().loadAdapter.nextCalled(values);
            }
        }
        return isNext;
    }

    @Override
    public Object getValue(ValueExpression propName) {
        FieldMapping mappedProp = this.selectFieldMap.get(propName);
        ValueExpression mappedPropName = mappedProp.actualField;
        Object[] value = this.iterator.getValue(mappedPropName);
        if (mappedProp.needTrans) {
            if (mappedProp.isSelectCast) {
                if (value != null) {
                    value = new SelectValue(value.toString());
                }
            } else if (mappedProp.lam != null) {
                if (mappedProp.ph.getMetaData().getMultiplicity() == 1) {
                    value = mappedProp.lam.loadAdapter.toComplexWrapperTypeValue(value);
                } else if (value != null) {
                    Object[] valArray = value;
                    Object[] extendValArray = mappedProp.lam.loadAdapter.newComplexWrapperTypeArray(valArray.length);
                    for (int i = 0; i < valArray.length; ++i) {
                        extendValArray[i] = mappedProp.lam.loadAdapter.toComplexWrapperTypeValue(valArray[i]);
                    }
                    value = extendValArray;
                }
            } else if (mappedProp.ph.getMetaData().getType() instanceof VirtualType) {
                VirtualType vt = (VirtualType)mappedProp.ph.getMetaData().getType();
                if (mappedProp.ph.getMetaData().getMultiplicity() == 1) {
                    value = vt.toVirtualTypeValue(value, mappedProp.ph);
                } else if (value != null) {
                    Object[] valArray = value;
                    Object[] extendValArray = vt.newVirtualTypeArray(valArray.length);
                    for (int i = 0; i < valArray.length; ++i) {
                        extendValArray[i] = vt.toVirtualTypeValue(valArray[i], mappedProp.ph);
                    }
                    value = extendValArray;
                }
            }
        }
        return value;
    }

    @Override
    public void close() {
        if (this.iterator != null) {
            this.iterator.close();
        }
    }

    @Override
    public ASTNode visit(Select select) {
        ArrayList<ValueExpression> selectValues = new ArrayList<ValueExpression>();
        if (select.getSelectValues() != null) {
            for (ValueExpression v : select.getSelectValues()) {
                if (!this.isSubQuery && v instanceof EntityField) {
                    this.isSelectField = true;
                }
                ValueExpression transV = (ValueExpression)v.accept(this);
                this.isSelectField = false;
                selectValues.add(transV);
                if (this.isSubQuery) continue;
                if (v instanceof EntityField) {
                    EntityHandler handler = null;
                    handler = this.eh.getMetaData().getName().equals(this.query.getFrom().getEntityName()) ? this.eh : this.ec.getHandlerByName(this.query.getFrom().getEntityName());
                    PropertyHandler ph = handler.getPropertyCascade(((EntityField)v).getPropertyName(), this.ec);
                    if (!(ph instanceof PrimitivePropertyHandler)) continue;
                    FieldMapping fMap = new FieldMapping(v, transV, (PrimitivePropertyHandler)ph);
                    this.selectFieldMap.put(v, fMap);
                    PropertyType type = fMap.ph.getMetaData().getType();
                    if (type instanceof ComplexWrapperType) {
                        LoadAdapterMapping laMap = null;
                        for (Map.Entry<ComplexWrapperType, LoadAdapterMapping> e : this.loadAdaptorMap.entrySet()) {
                            if (!e.getKey().equals(type)) continue;
                            laMap = e.getValue();
                            break;
                        }
                        if (laMap == null) {
                            laMap = new LoadAdapterMapping((ComplexWrapperType)type, ((ComplexWrapperType)type).createLoadAdapter());
                            this.loadAdaptorMap.put(laMap.type, laMap);
                        }
                        laMap.addField(fMap);
                        fMap.needTrans = true;
                        continue;
                    }
                    if (!(type instanceof VirtualType)) continue;
                    fMap.needTrans = true;
                    continue;
                }
                if (v instanceof Cast && ((Cast)v).getType() == PropertyDefinitionType.SELECT) {
                    this.selectFieldMap.put(v, new FieldMapping(v, transV, true));
                    continue;
                }
                this.selectFieldMap.put(v, new FieldMapping(v, transV, null));
            }
        }
        Select copy = new Select(select.isDistinct(), selectValues);
        copy.setHintComment(select.getHintComment());
        return copy;
    }

    @Override
    public ASTNode visit(EntityField entityField) {
        ValueExpression v = null;
        if (entityField.getPropertyName().charAt(0) == '.') {
            return (ValueExpression)super.visit(entityField);
        }
        PropertyHandler ph = this.getPh(entityField.getPropertyName());
        if (ph instanceof PrimitivePropertyHandler) {
            MetaPrimitiveProperty mpp = (MetaPrimitiveProperty)ph.getMetaData();
            if (mpp.getType() instanceof VirtualType) {
                v = ((VirtualType)mpp.getType()).translate(entityField);
                v = (ValueExpression)v.accept(this);
            } else if (!this.isSelectField && mpp.getType() instanceof ComplexWrapperType) {
                try {
                    v = ((ComplexWrapperType)mpp.getType()).translate(entityField);
                }
                catch (EntityRuntimeException e) {
                    logger.warn(e.getMessage() + " of eql: " + this.query);
                }
            }
        }
        if (v == null) {
            v = (ValueExpression)super.visit(entityField);
        }
        return v;
    }

    @Override
    public ASTNode visit(SubQuery sq) {
        boolean parentIsSubQuery = this.isSubQuery;
        boolean parentIsSelectField = this.isSelectField;
        Query parentQuery = this.query;
        this.isSubQuery = true;
        this.query = sq.getQuery();
        Query subQuery = null;
        Condition on = null;
        if (sq.getQuery() != null) {
            subQuery = (Query)sq.getQuery().accept(this);
        }
        if (sq.getOn() != null) {
            on = (Condition)sq.getOn().accept(this);
        }
        SubQuery transSubQuery = new SubQuery(subQuery, on);
        this.query = parentQuery;
        this.isSubQuery = parentIsSubQuery;
        this.isSelectField = parentIsSelectField;
        return transSubQuery;
    }

    protected PropertyHandler getPh(String propName) {
        EntityHandler handler = null;
        handler = this.query != null ? (this.eh.getMetaData().getName().equals(this.query.getFrom().getEntityName()) ? this.eh : this.ec.getHandlerByName(this.query.getFrom().getEntityName())) : (this.updateCond != null ? (this.eh.getMetaData().getName().equals(this.updateCond.getDefinitionName()) ? this.eh : this.ec.getHandlerByName(this.updateCond.getDefinitionName())) : (this.eh.getMetaData().getName().equals(this.deleteCond.getDefinitionName()) ? this.eh : this.ec.getHandlerByName(this.deleteCond.getDefinitionName())));
        return handler.getPropertyCascade(propName, this.ec);
    }

    @Override
    public ASTNode visit(Literal literal) {
        if (literal.getValue() instanceof SelectValue) {
            return new Literal(((SelectValue)literal.getValue()).getValue(), literal.isBindable());
        }
        return super.visit(literal);
    }

    @Override
    public ASTNode visit(Cast cast) {
        if (cast.getType() == PropertyDefinitionType.SELECT) {
            ValueExpression val = cast.getValue();
            if (val != null) {
                val = (ValueExpression)val.accept(this);
            }
            return new Cast(val, PropertyDefinitionType.STRING);
        }
        return super.visit(cast);
    }

    @Override
    public ASTNode visit(SortSpec order) {
        SelectType type;
        List<Value> sl;
        String propName;
        PropertyHandler ph;
        if (order.getSortKey() instanceof EntityField && (ph = this.eh.getPropertyCascade(propName = ((EntityField)order.getSortKey()).getPropertyName(), this.ec)) != null && ph.getEnumType() == PropertyDefinitionType.SELECT && (sl = (type = (SelectType)((PrimitivePropertyHandler)ph).getMetaData().getType()).runtimeValues()) != null && sl.size() > 0) {
            Case cs = new Case();
            for (int i = 0; i < sl.size(); ++i) {
                cs.when(new Equals(propName, (Object)new Literal(sl.get(i).getValue(), false)), new Literal(i, false));
            }
            cs.elseClause(new Literal(null, false));
            return new SortSpec(cs, order.getType(), order.getNullOrderingSpec());
        }
        return super.visit(order);
    }

    private static class ThisRefNormalizer
    extends QueryVisitorSupport {
        private EntityContext ec;
        private EntityHandler eh;
        private ThisRefNormalizer parent;
        private boolean isOn;

        private ThisRefNormalizer(EntityContext ec, EntityHandler eh, ThisRefNormalizer parent) {
            this.ec = ec;
            this.eh = eh;
            this.parent = parent;
        }

        @Override
        public boolean visit(EntityField entityField) {
            if (this.isOn) {
                String pname = entityField.getPropertyName();
                ThisRefNormalizer cn = this;
                String prefix = null;
                for (int i = 0; i < pname.length(); ++i) {
                    if (pname.charAt(i) != '.') {
                        prefix = pname.substring(0, i);
                        pname = pname.substring(i);
                        break;
                    }
                    if (this.parent == null) {
                        throw new QueryException("can't unnest property:" + entityField);
                    }
                    cn = this.parent;
                }
                if (pname.equalsIgnoreCase("this")) {
                    pname = "oid";
                } else {
                    EntityHandler target = cn.eh;
                    PropertyHandler ph = target.getPropertyCascade(pname, this.ec);
                    if (ph == null) {
                        throw new QueryException("can't find property:" + entityField);
                    }
                    if (ph instanceof ReferencePropertyHandler) {
                        pname = pname + "." + "oid";
                    }
                }
                if (prefix.length() > 0) {
                    pname = prefix + pname;
                }
                entityField.setPropertyName(pname);
            }
            return super.visit(entityField);
        }

        @Override
        public boolean visit(SubQuery subQuery) {
            EntityHandler subEh = this.ec.getHandlerByName(subQuery.getQuery().getFrom().getEntityName());
            if (subEh == null) {
                throw new QueryException(subQuery.getQuery().getFrom().getEntityName() + " not defined");
            }
            ThisRefNormalizer subNor = new ThisRefNormalizer(this.ec, subEh, this);
            subQuery.getQuery().accept(subNor);
            if (subQuery.getOn() != null) {
                subNor.isOn = true;
                subQuery.getOn().accept(subNor);
            }
            return false;
        }
    }

    private class LoadAdapterMapping {
        ComplexWrapperType type;
        ComplexWrapperTypeLoadAdapter loadAdapter;
        List<FieldMapping> fields;

        public LoadAdapterMapping(ComplexWrapperType type, ComplexWrapperTypeLoadAdapter loadAdapter) {
            this.type = type;
            this.loadAdapter = loadAdapter;
        }

        void addField(FieldMapping field) {
            if (this.fields == null) {
                this.fields = new ArrayList<FieldMapping>();
            }
            this.fields.add(field);
            field.lam = this;
        }
    }

    private class FieldMapping {
        boolean needTrans;
        ValueExpression field;
        ValueExpression actualField;
        PrimitivePropertyHandler ph;
        LoadAdapterMapping lam;
        boolean isSelectCast;

        public FieldMapping(ValueExpression field, ValueExpression actualField, PrimitivePropertyHandler ph) {
            this.field = field;
            this.actualField = actualField;
            this.ph = ph;
        }

        public FieldMapping(ValueExpression field, ValueExpression actualField, boolean isSelectCast) {
            this.field = field;
            this.actualField = actualField;
            this.isSelectCast = isSelectCast;
            this.needTrans = true;
        }
    }
}

