/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.interceptor;

import java.util.function.Predicate;
import org.iplass.mtp.entity.SearchOption;
import org.iplass.mtp.entity.interceptor.EntityInterceptor;
import org.iplass.mtp.entity.interceptor.EntityQueryInvocation;
import org.iplass.mtp.entity.interceptor.InvocationType;
import org.iplass.mtp.entity.query.Query;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.EntityStreamSearchHandler;
import org.iplass.mtp.impl.entity.interceptor.EntityInvocationImpl;

public class EntityQueryInvocationImpl
extends EntityInvocationImpl<Void>
implements EntityQueryInvocation {
    private Query query;
    private Predicate<?> resultCallback;
    private EntityStreamSearchHandler<?> streamSearchHandler;
    private InvocationType type;
    private SearchOption searchOption;

    public EntityQueryInvocationImpl(Query query, SearchOption searchOption, Predicate<?> resultCallback, InvocationType type, EntityInterceptor[] entityInterceptors, EntityHandler entityHandler) {
        super(entityInterceptors, entityHandler);
        this.query = query;
        this.searchOption = searchOption;
        this.resultCallback = resultCallback;
        this.type = type;
    }

    public EntityQueryInvocationImpl(Query query, SearchOption searchOption, EntityStreamSearchHandler<?> streamSearchHandler, InvocationType type, EntityInterceptor[] entityInterceptors, EntityHandler entityHandler) {
        super(entityInterceptors, entityHandler);
        this.query = query;
        this.searchOption = searchOption;
        this.resultCallback = streamSearchHandler.getDummyCallback();
        this.streamSearchHandler = streamSearchHandler;
        this.type = type;
    }

    @Override
    public Query getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(Query query) {
        this.query = query;
    }

    @Override
    public InvocationType getType() {
        return this.type;
    }

    @Override
    public Predicate<?> getPredicate() {
        return this.resultCallback;
    }

    @Override
    public void setPredicate(Predicate<?> resultCallback) {
        this.resultCallback = resultCallback;
    }

    public EntityStreamSearchHandler<?> getStreamSearchHandler() {
        return this.streamSearchHandler;
    }

    @Override
    protected Void callEntityHandler(EntityHandler eh) {
        switch (this.type) {
            case SEARCH: {
                eh.search(this.query, this.streamSearchHandler, this.resultCallback);
                break;
            }
            case SEARCH_ENTITY: {
                eh.searchEntity(this.query, this.searchOption.isReturnStructuredEntity(), this.streamSearchHandler, this.resultCallback);
                break;
            }
        }
        return null;
    }

    @Override
    public SearchOption getSearchOption() {
        return this.searchOption;
    }
}

