/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.listener;

import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.EntityEventContext;
import org.iplass.mtp.entity.EntityEventListener;
import org.iplass.mtp.entity.EntityRuntimeException;
import org.iplass.mtp.entity.definition.EventListenerDefinition;
import org.iplass.mtp.entity.definition.listeners.JavaClassEventListenerDefinition;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.MetaEventListener;

public class MetaJavaClassEventListener
extends MetaEventListener {
    private static final long serialVersionUID = 817043706754815712L;
    private String className;

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    @Override
    public void applyConfig(EventListenerDefinition def) {
        this.fillFrom(def);
        JavaClassEventListenerDefinition d = (JavaClassEventListenerDefinition)def;
        this.className = d.getClassName();
    }

    @Override
    public MetaEventListener copy() {
        MetaJavaClassEventListener copy = new MetaJavaClassEventListener();
        this.copyTo(copy);
        copy.className = this.className;
        return copy;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MetaJavaClassEventListener other = (MetaJavaClassEventListener)obj;
        return !(this.className == null ? other.className != null : !this.className.equals(other.className));
    }

    @Override
    public EventListenerDefinition currentConfig() {
        JavaClassEventListenerDefinition d = new JavaClassEventListenerDefinition();
        this.fillTo(d);
        d.setClassName(this.className);
        return d;
    }

    @Override
    public JavaClassEventListenerRuntime createRuntime(MetaEntity entity) {
        return new JavaClassEventListenerRuntime();
    }

    public class JavaClassEventListenerRuntime
    extends MetaEventListener.EventListenerRuntime {
        private EntityEventListener listener;

        public JavaClassEventListenerRuntime() {
            super(MetaJavaClassEventListener.this);
            try {
                this.listener = (EntityEventListener)Class.forName(MetaJavaClassEventListener.this.className).newInstance();
            }
            catch (InstantiationException e) {
                throw new EntityRuntimeException("can not instantiate " + MetaJavaClassEventListener.this.className, e);
            }
            catch (IllegalAccessException e) {
                throw new EntityRuntimeException("can not instantiate " + MetaJavaClassEventListener.this.className, e);
            }
            catch (ClassNotFoundException e) {
                throw new EntityRuntimeException("class not found:" + MetaJavaClassEventListener.this.className, e);
            }
        }

        @Override
        public void handleAfterDelete(Entity entity, EntityEventContext context) {
            this.listener.afterDelete(entity, context);
        }

        @Override
        public void handleAfterInsert(Entity entity, EntityEventContext context) {
            this.listener.afterInsert(entity, context);
        }

        @Override
        public void handleAfterUpdate(Entity entity, EntityEventContext context) {
            this.listener.afterUpdate(entity, context);
        }

        @Override
        public boolean handleBeforeDelete(Entity entity, EntityEventContext context) {
            return this.listener.beforeDelete(entity, context);
        }

        @Override
        public boolean handleBeforeInsert(Entity entity, EntityEventContext context) {
            return this.listener.beforeInsert(entity, context);
        }

        @Override
        public boolean handleBeforeUpdate(Entity entity, EntityEventContext context) {
            return this.listener.beforeUpdate(entity, context);
        }

        @Override
        public void handleOnLoad(Entity entity) {
            this.listener.onLoad(entity);
        }

        @Override
        public MetaJavaClassEventListener getMetaData() {
            return MetaJavaClassEventListener.this;
        }

        @Override
        public void handleBeforeValidate(Entity entity, EntityEventContext context) {
            this.listener.beforeValidate(entity, context);
        }

        @Override
        public void handleAfterRestore(Entity entity) {
            this.listener.afterRestore(entity);
        }

        @Override
        public void handleAfterPurge(Entity entity) {
            this.listener.afterPurge(entity);
        }
    }
}

