/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.entity.property;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.iplass.mtp.entity.Entity;
import org.iplass.mtp.entity.ValidateError;
import org.iplass.mtp.entity.ValidationContext;
import org.iplass.mtp.entity.definition.IndexType;
import org.iplass.mtp.entity.definition.PropertyDefinitionType;
import org.iplass.mtp.impl.datastore.PropertyStoreHandler;
import org.iplass.mtp.impl.entity.EntityContext;
import org.iplass.mtp.impl.entity.EntityHandler;
import org.iplass.mtp.impl.entity.MetaEntity;
import org.iplass.mtp.impl.entity.property.MetaProperty;
import org.iplass.mtp.impl.i18n.I18nUtil;
import org.iplass.mtp.impl.i18n.MetaLocalizedString;
import org.iplass.mtp.impl.validation.MetaValidation;
import org.iplass.mtp.impl.validation.ValidationHandler;

public abstract class PropertyHandler {
    protected MetaProperty metaData;
    private List<ValidationHandler> validators;
    private EntityHandler parent;
    private PropertyStoreHandler entityStorePropertyHandler;
    private Map<String, String> localizedStringMap = new HashMap<String, String>();

    public PropertyHandler(MetaProperty metaproperty, MetaEntity metaEntity) {
        this.metaData = metaproperty;
        List<MetaValidation> vDefs = metaproperty.getValidations();
        if (vDefs != null) {
            this.validators = new ArrayList<ValidationHandler>();
            for (MetaValidation vDef : vDefs) {
                this.validators.add(vDef.createRuntime(metaEntity, metaproperty));
            }
        }
        if (metaproperty.getEntityStoreProperty() != null) {
            this.entityStorePropertyHandler = metaproperty.getEntityStoreProperty().createRuntime(this, metaEntity);
        }
        if (this.metaData.getLocalizedDisplayNameList() != null) {
            for (MetaLocalizedString mls : this.metaData.getLocalizedDisplayNameList()) {
                this.localizedStringMap.put(mls.getLocaleName(), mls.getStringValue());
            }
        }
    }

    public boolean isIndexed() {
        return this.getMetaData().getIndexType() == IndexType.NON_UNIQUE || this.getMetaData().getIndexType() == IndexType.UNIQUE || this.getMetaData().getIndexType() == IndexType.UNIQUE_WITHOUT_NULL;
    }

    public boolean isUniqueIndexed() {
        return this.getMetaData().getIndexType() == IndexType.UNIQUE || this.getMetaData().getIndexType() == IndexType.UNIQUE_WITHOUT_NULL;
    }

    public EntityHandler getParent() {
        return this.parent;
    }

    public void setParent(EntityHandler parent) {
        this.parent = parent;
    }

    public String getId() {
        if (this.metaData == null) {
            return null;
        }
        return this.metaData.getId();
    }

    public String getName() {
        return this.metaData.getName();
    }

    public String getDisplayName() {
        String name = this.metaData.getDisplayName();
        if (name == null) {
            name = this.metaData.getName();
        }
        return name;
    }

    public Map<String, String> getLocalizedStringMap() {
        return this.localizedStringMap;
    }

    public void setLocalizedStringMap(Map<String, String> localizedStringMap) {
        this.localizedStringMap = localizedStringMap;
    }

    public ValidateError validate(Entity model) {
        ValidationContext context = new ValidationContext(model, this.metaData.getName());
        if (this.validators != null) {
            String entityDispName = this.parent.getLocalizedDisplayName();
            String propDispName = this.getLocalizedDisplayName();
            for (ValidationHandler v : this.validators) {
                Object value = model.getValue(this.metaData.getName());
                if (this.getMetaData().getMultiplicity() != 1 && value != null && value.getClass().isArray()) {
                    if (v.validateArray((Object[])value, context)) continue;
                    ValidateError res = new ValidateError();
                    res.setPropertyName(this.metaData.getName());
                    res.setPropertyDisplayName(propDispName);
                    res.addErrorMessage(v.generateErrorMessage(value, context, propDispName, entityDispName), v.getErrorCode());
                    return res;
                }
                if (v.validate(value, context)) continue;
                ValidateError res = new ValidateError();
                res.setPropertyName(this.metaData.getName());
                res.setPropertyDisplayName(propDispName);
                res.addErrorMessage(v.generateErrorMessage(value, context, propDispName, entityDispName), v.getErrorCode());
                return res;
            }
        }
        return null;
    }

    public String getLocalizedDisplayName() {
        return I18nUtil.stringMeta(this.getDisplayName(), this.getMetaData().getLocalizedDisplayNameList());
    }

    public PropertyStoreHandler getStoreSpecProperty() {
        return this.entityStorePropertyHandler;
    }

    public abstract PropertyDefinitionType getEnumType();

    public abstract MetaProperty getMetaData();

    public abstract Object[] newArrayInstance(int var1, EntityContext var2);
}

