/*
 * Decompiled with CFR 0.152.
 */
package org.iplass.mtp.impl.http;

import java.util.function.Predicate;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.AbstractExecutionAwareRequest;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.iplass.mtp.impl.http.ExponentialBackoff;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleHttpInvoker {
    private static Logger logger = LoggerFactory.getLogger(SimpleHttpInvoker.class);
    private CloseableHttpClient httpClient;
    private ExponentialBackoff exponentialBackoff;

    public SimpleHttpInvoker(CloseableHttpClient httpClient, ExponentialBackoff exponentialBackoff) {
        this.httpClient = httpClient;
        this.exponentialBackoff = exponentialBackoff == null ? ExponentialBackoff.NO_RETRY : exponentialBackoff;
    }

    private final boolean noRetry(Response res) {
        return true;
    }

    public Response call(HttpUriRequest request) {
        return this.call(request, this::noRetry);
    }

    public Response call(HttpUriRequest request, Predicate<Response> stopRetryCondition) {
        Response response = new Response();
        long start = System.currentTimeMillis();
        try {
            this.exponentialBackoff.execute(() -> {
                try (CloseableHttpResponse res = this.httpClient.execute(request);){
                    response.status = res.getStatusLine().getStatusCode();
                    HttpEntity entity = res.getEntity();
                    response.content = entity == null ? null : EntityUtils.toString((HttpEntity)entity, (String)"UTF-8");
                }
                catch (Exception e) {
                    if (response.exception != null) {
                        e.addSuppressed(response.exception);
                    }
                    response.exception = e;
                    response.status = 0;
                    response.content = null;
                    if (logger.isDebugEnabled()) {
                        logger.debug("error while http call:" + request.toString(), (Throwable)e);
                    }
                }
                finally {
                    if (request instanceof AbstractExecutionAwareRequest) {
                        ((AbstractExecutionAwareRequest)request).reset();
                    }
                }
                return stopRetryCondition.test(response);
            });
        }
        catch (InterruptedException e) {
            if (response.exception != null) {
                e.addSuppressed(response.exception);
            }
            response.exception = e;
            response.status = 0;
            response.content = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("call external web resource: " + request + " " + (System.currentTimeMillis() - start) + "ms");
        }
        return response;
    }

    public static class Response {
        public String content;
        public int status;
        public Exception exception;
    }
}

